import request from '@/utils/request.js'

//询价公告列表
export function getInquiryList(data){
    return request({
        url:"/notice/list?noticeType=ENQUIRY",
        method:'post',
        data:data
  })
}
//候选人公告列表
export function getCadidateList(data){
  return request({
      url:"/notice/list?noticeType=CADIDATE",
      method:'post',
      data:data
})
}
//中标候选人公告详情
export function getCadidateDetails(id){
  return request({
      url:`/notice/cadidate/${id}`,
      method:'get',
})
}
//变更公告列表
export function getChangeList(data){
  return request({
      url:"/notice/list?noticeType=CHANGE",
      method:'post',
      data:data
})
}
//流标公告列表
export function getErrorList(data){
  return request({
      url:"/notice/list?noticeType=ABORTIVE",
      method:'post',
      data:data
})
}
//流标公告详情
export function getErrorDetails(id){
  return request({
      url:`/notice/abortive/${id}`,
      method:'get',
})
}
//询价公告详情
export function getenquirydetails(id){
  return request({
      url:`/notice/enquiry/${id}`,
      method:'get'
})
}
export function getBidingList(data){
    return request({
        url:'/notice/list?noticeType=BIDDING',
        method:'post',
        data:data
  })
}
//招标详情页
export function getBidingdetails(id){
  return request({
      url:`/notice/bidding/${id}`,
      method:'get',
})
}
//中标详情页
export function getWindetails(id){
  return request({
      url:`/notice/win/${id}`,
      method:'get',
})
}
//中标列表页
export function getWinList(data){
    return request({
        url:"/notice/list?noticeType=WIN",
        method:'post',
        data:data
  })
}
//全部列表
export function getAllList(data){
  return request({
      url:"/notice/list",
      method:'post',
      data:data
})
}
//忘记密码---->发送短信
export function sendSms(params){
  return request({
      url:"/sms/send-sms",
      method:'post',
      params:params
})
}
//忘记密码---->手机验证码
export function getVerifyPhone(data){
  return request({
      url:"/verify-phone",
      method:'post',
      data:data
})
}
//忘记密码---->重置密码
export function getResetPassword(data){
  return request({
      url:"reset-password",
      method:'post',
      data:data
})
}

//文章列表
export function getListContent(params){
  return request({
      url:"/news/list-content",
      method:'get',
      params
})
}
//文章列表首页
export function getListSite(params){
  return request({
      url:"/news/list-content",
      method:'get',
      params:params
})
}
//分类列表
export function getCategoryList(){
  return request({
      url:"/news/list-category",
      method:'get',
})
}
//查看分类
 export function getCateList(id){
  return request({
      url:`/news/cate/${id}`,
      method:'get',
})
}
//查看文章
export function getList(id){
  return request({
      url:`/news/content/${id}`,
      method:'get',
})
}
//获取noticeType
export function getNoticeType(){
  return request({
      url:"/notice/notice-type",
      method:'get',
})
}
//变更详情
export function getChangeDetails(id){
  return request({
      url:`/notice/change/${id}`,
      method:'get',
})
}
//轮播图
export function getLoopPic(params){
  return request({
      url:'/banner/list',
      method:'get',
      params:params
})
}
//二次验证
export function getSecond(data){
  return request({
      url:'/sys/user/userInfo',
      method:'get',
      data:data
})
}