import request from '@/utils/request'

// 获取城市列表
 export function cityList(id) {
  return request({
    url: `/city/getList?pid=${id}`,
    method: 'get'
  })
} 

// 获取行业所属列表
export function industryList() {
  return request({
    url: '/industryList',
    method: 'get'
  })
}

// 获取单位性质列表
export function companyNatureList() {
  return request({
    url: '/CompanyNatureList',
    method: 'get'
  })
}
// 获取验证码图片
export function getVerify() {
  return request({
    url: '/getVerify',
    method: 'get'
  })
}

// 获取手机验证码
export function sendSms(params) {
  return request({
    url: 'sms/send-sms',
    method: 'post',
    params:params
  })
}

// 验证手机和验证码是否正确
export function verifyPhone(data) {
  return request({
    url: 'sms/verify-phone',
    method: 'post',
    data:data
  })
}

// 验证手机唯一性
export function checkAccount(account) {
  return request({
    url:`sys/user/check/account/${account}`,
    method: 'get',
  })
}
