import request from '@/utils/request'

// 获取该公司下的项目经理列表
export function userList(id) {
  return request({
    url: `/sys/user/list/company/${id}`,
    method: 'get'
  })
}
// 获取行业所属列表
export function industryList() {
  return request({
    url: '/industryList',
    method: 'get'
  })
}
// 获取项目分类列表
export function projectClassifyList() {
  return request({
    url: '/projectClassifyList',
    method: 'get'
  })
}

// 获取城市列表
export function cityList(id) {
  return request({
    url: `/city/getList?pid=${id}`,
    method: 'get'
  })
}

// 获取所有供应商列表列表
export function supplierList(data) {
  return request({
    url:   "/company/list",
    method: 'post',
	data:data
  })
}

// 获取所有列表(有分页) 有查询
export function getList(data, url) {
  return request({  
    url: url,
    method: 'post',
    data: data
  })
}

// 获取所有列表(无分页) 有查询
export function queryList(data, url) {
  return request({
   url: url,
   method: 'post',
   data: data
  })
}

// 获取工作台列表的状态
export function projectStatusList() {
  return request({
    url: '/projectStatusList',
    method: 'get'
  })
}
// 该公司下的所有成员
export function opener(companyId) {
  return request({
    url:`tender-openBid/opener/${companyId}`,
    method: 'get'
  })
}

// 获取该项目下的项目经理
export function mamager(projectId) {
  return request({
    url:`tender-openBid/mamager/${projectId}`,
    method: 'get'
  })
}
// 获取用户信息
export function userInfo() {
  return request({
    url:"sys/user/userInfo",
    method: 'get'
  })
}