import request from '@/utils/request'




// 采购商
// 2.1.1
// 创建招标项目
export function creatProject(data) {
  return request({
    url: '/tender-project/save',
    method: 'POST',
    data: data
  })
}

// 编辑招标项目
export function editProject(data) {
  return request({
    url: '/tender-project/edit',
    method: 'POST',
    data: data
  })
}



// 2.1.2
//  发送询价公告
export function createEnquiry(data) {
  return request({
    url: '/tender-notice/create-enquiry',
    method: 'POST',
    data: data
  })
}
//  编辑询价公告
export function editEnquiry(data) {
  return request({
    url: 'tender-notice/edit-enquiry',
    method: 'POST',
    data: data
  })
}


// 发送招标公告
export function bidMessage(data) {
  return request({
    url: '/tender-notice/create-bidding',
    method: 'POST',
    data: data
  })
}
// 编辑招标公告
export function editBidding(data) {
  return request({
    url: 'tender-notice/edit-bidding',
    method: 'POST',
    data: data
  })
}
// 查看招标公告（通过项目id）
// 发送邀请公告
export function inviteMessage(data) {
  return request({
    url: '/tender-notice/create-invite',
    method: 'POST',
    data: data
  })
}

// 2.1.3
//采购商提出问题
export function purchaseAsk(data) {
  return request({
    url: '/clarifies/purchase-ask',
    method: 'POST',
    data: data
  })
}
// 采购商提出澄清
export function forwardClarify(data) {
  return request({
    url: '/tender-clarifies/forwardClarify',
    method: 'POST',
    data: data
  })
}
// 修改澄清公告
export function editClarifiesNotice(data) {
  return request({
    url: '/tender-clarifies/edit-clarifiesNotice',
    method: 'POST',
    data: data
  })
}




// 问题内容接口
export function questionDetail(id) {
  return request({
    url: `/tender-clarifies/question/${id}`,
    method: 'get'
  })
}

// 澄清内容接口
export function clarifiesDetail(id) {
  return request({
    url: `/tender-clarifies/clarifiesNotice/${id}`,
    method: 'get'
  })
} 	
//查看某个澄清的 投标方列表
export function bidClarifies(params) {
  return request({
    url: 'tender-clarifies/bid-clarifies/list',
    method: 'get',
    params: params
  })
}
//澄清确认回执查看
export function confirmation(confirmId) {
  return request({
    url: `tender-clarifies/confirm/detail/${confirmId}`,
    method: 'get'
  })
}

// 新增
// 标书费缴纳详情
export function bidbookDetail(params) {
  return request({
    url: "tender-bidbook/detail",
    method: 'get',
	params:params
  })
}

// 标书费拒绝或者通过
export function operationAduit(data) {
  return request({
    url: "tender-bidbook/operation/aduit",
    method: 'post',
	data:data
  })
}

//投标保证金缴纳详情
export function earnestDetail(feeId) {
  return request({
    url: `tender-earnest/detail/${feeId}`,
    method: 'get',
  })
}
// 保证金拒绝或者通过
export function aduit(data) {
  return request({
    url: "tender-earnest/aduit",
    method: 'post',
	data:data
  })
}

// 投标信息查看
export function reviewInfomation(projectId) {
  return request({
    url: `/tender-project/reviewInfomation/${projectId}`,
    method: 'get'
  })
}

// 变更公告管理
// export function createChange(data) {
//   return request({
//     url: '/notice/list',
//     method: 'post',
//     data: data
//   })
// }

export function changeList(projectId) {
  return request({
    url: `/tender-notice/changeList/${projectId}`,
    method: 'get'
  })
}
// 发布变更公告
export function createChange(data) {
  return request({
    url: '/tender-notice/create-change',
    method: 'post',
    data: data
  })
}
// 编辑变更公告
export function editchange(data) {
  return request({
    url: 'tender-notice/edit-change',
    method: 'post',
    data: data
  })
}

// 变更公告详情
export function noticeChange(id) {
  return request({
    url: `/notice/change/${id}`,
    method: 'get'
  })
}


// 流标公告管理
export function abortiveList(projectId) {
  return request({
    url: `/tender-notice/list/${projectId}`,
    method: 'get'
  })
}
// export function abortiveList(projectId) {
//   return request({
//     url: `/tender-evaluate/bidFailed/${projectId}`,
//     method: 'get'
//   })
// }
// 发布流标公告
export function createAbortive(data) {
  return request({
    url: '/tender-notice/create-abortive',
    method: 'post',
    data: data
  })
}

// 编辑流标公告
export function editabortive(data) {
  return request({
    url: 'tender-notice/edit-abortive',
    method: 'post',
    data: data
  })
}

// 流标公告详情
export function noticeAbortive(id) {
  return request({
    url: `/notice/abortive/${id}`,
    method: 'get'
  })
}


// 流标公告管理
// export function reviewInfomation(projectId) {
//   return request({
//     url: `/tender-project/reviewInfomation/${projectId}`,
//     method: 'get'
//   })
// }



// 2.1.4
//开标大厅
// 开标一览表
export function openInfo(projectId) {
  return request({
    url: `open-bid/openInfo/${projectId}`,
    method: 'get',
  })
}
// 下发开标一览表
export function issueopenInfo(projectId) {
  return request({
    url: `open-bid/issue/openInfo/${projectId}`,
    method: 'put',
  })
}


//签到解密简略
export function signdetail(projectId) {
  return request({
    url: `/open-bid/sign/${projectId}`,
    method: 'get',
  })
}


// 开标按钮上三个信息（投标人数，缴纳保证金人数，签到人数）
export function startInfo(projectId) {
  return request({
    url: `open-bid/startInfo/${projectId}`,
    method: 'get',
  })
}
//获取开标大厅的时间信息
export function timeInfo(projectId) {
  return request({
    url: `open-bid/timeInfo/${projectId}`,
    method: 'get',
  })
}

// 立即开标
export function startbid(projectId) {
  return request({
    url: `open-bid/start/${projectId}`,
    method: 'put',
  })
}
// 流标
export function openbidFailed(data) {
  return request({
    url: "open-bid/bidFailed",
    method: 'post',
	data:data
  })
}
// 查看流标信息
export function bidFaileddetail(projectId) {
  return request({
    url: `open-bid/bidFailed/detail/${projectId}`,
    method: 'get',
  })
}
// 开标大厅消息记录
export function messageRecord(projectId) {
  return request({
    url: `open-bid/messageRecord/${projectId}`,
    method: 'get',
  })
}
// 结束开标
export function bidFinish(projectId) {
  return request({
    url: `open-bid/finish/${projectId}`,
    method: 'get',
  })
}

// 2.1.5
// 	评标管理：变更公告列表
export function accessoryupload(data) {
  return request({
    url: "tender-evaluate/accessory/upload",
    method: 'post',
	data:data
  })
}

// 	评标管理：变更公告列表
export function changeNoticelist(projectId) {
  return request({
    url: `tender-evaluate/changeNotice/list/${projectId}`,
    method: 'get',
  })
}
//投标文件
export function bidFilelist(projectId) {
  return request({
    url: `tender-evaluate/bidFile/list/${projectId}`,
    method: 'get',
  })
}
// 评标附件
export function accessorydownload(projectId) {
  return request({
    url: `tender-evaluate/accessory/download/${projectId}`,
    method: 'get',
  })
}

// 流标
export function bidFailed(data) {
  return request({
    url: "tender-evaluate/bidFailed",
    method: 'post',
	data:data
  })
}



// // 保存编辑(专家)
export function saveEvaluate(data) {
  return request({
    url: "tender-evaluate/saveEvaluate",
    method: 'post',
	data:data
  })
}
//是否已经提交评分等等的状态
export function isEvaluate(projectId) {
  return request({
    url: `tender-evaluate/isEvaluate/${projectId}`,
    method: 'get',
  })
}

//项目经理中的评标结算按钮 
export function bidend(projectId) {
  return request({
    url: `/tender-evaluate/end/${projectId}`,
    method: 'put',
  })
}

// 查看投标公司评审信息
export function CompanyEvaluatec(projectId) {
  return request({
    url: `/tender-evaluate/CompanyEvaluatec/${projectId}`,
    method: 'get'
  })
}
// 查看投标公司排名信息
export function companyRank(projectId) {
  return request({
    url: `/tender-evaluate/companyRank/${projectId}`,
    method: 'get'
  })
}

// 评审信息和排名信息
export function bidderlist(projectId) {
  return request({
    url: `tender-evaluate/bidder/list/${projectId}`,
    method: 'get'
  })
}

// 保存投标公司评审信息
export function saveCompanyEvaluate(data) {
  return request({
    url: '/tender-evaluate/saveCompanyEvaluate',
    method: 'post',
    data: data
  })
}
// 保存投标公司排名信息
export function saveCompanyRank(data) {
  return request({
    url: '/tender-evaluate/saveCompanyRank',
    method: 'post',
    data: data
  })
}
// 评标管理：新增问题
export function addQuestion(data) {
  return request({
    url: '/tender-evaluate/tenderQuiz/save',
    method: 'post',
    data: data
  })
}
// 获取递交了投标文件的供应商
export function bidsupplyList(projectId) {
  return request({
    url: `/tender-evaluate/bid-file/bidList/${projectId}`,
    method: 'get'
  })
}

// 获取澄清质疑列表
export function clarifyinquiryList(projectId) {
  return request({
    url: `/tender-evaluate/clarify-inquiry/list/${projectId}`,
    method: 'get'
  })
}
// 专家
// 查看问题详情
export function expertquestionDetail(questionId) {
  return request({
    url: `/tender-evaluate/question-detail/${questionId}`,
    method: 'get'
  })
}
//查看某个问题的回复详情
export function expertreplyDetail(questionId) {
  return request({
    url: `/tender-evaluate/reply-deatil/${questionId}`,
    method: 'get'
  })
}
// 2.1.6
// 确定中标人
export function winnerSave(data) {
  return request({
    url: "/tender-decide/winner/save",
    method: 'post',
	data:data
  })
}
// 中标候选人名单
export function winPersionInfoDetail(projectId) {
  return request({
    url: `/tender-decide/winPersionInfoDetail/${projectId}`,
    method: 'get'
  })
}


// 中标候选人名单
export function candidate(projectId) {
  return request({
    url: `/tender-decide/candidate/${projectId}`,
    method: 'get'
  })
}
// 中标通知书列表
export function sentBookList(projectId) {
  return request({
    url: `/tender-decide/sentBook/list/${projectId}`,
    method: 'get'
  })
}
// 中标通知书提交审核
export function sentBookAduit(projectId) {
  return request({
    url: `/tender-decide/winner/sentBook/aduit/${projectId}`,
    method: 'put'
  })
}
// 保存/编辑中标通知书
export function editSentBook(data) {
  return request({
    url: "/tender-decide/winner/sentBook",
    method: 'post',
	data:data
  })
}

// 招标结果通知书列表
export function resultBookList(projectId) {
  return request({
    url: `tender-decide/resultBook/list/${projectId}`,
    method: 'get'
  })
}
// 保存/编辑招标结果通知书
export function editResultBook(data) {
  return request({
    url: "/tender-decide/resultBook/save",
    method: 'post',
	data:data
  })
}
// 招标结果提交审核
export function resultBookAduit(projectId) {
  return request({
    url: `/tender-decide/resultBook/aduit/${projectId}`,
    method: 'put'
  })
}


// 合同管理保存
export function contract(data) {
  return request({
    url: "/tender-decide/contract/save",
    method: 'post',
	data:data
  })
}

// 
// 开标设置
export function bidsetting(data) {
  return request({
    url: "/tender-openBid/bid-setting",
    method: 'post',
	data:data
  })
}
// 开标设置查看
export function bidsettingInfo(projectId) {
  return request({
    url:`/tender-openBid/bid-setting/info?projectId=${projectId}`,
    method: 'get',
  })
}


//中标候选人公示提交
export function createcadidate(data) {
  return request({
    url: "/tender-notice/create-cadidate",
    method: 'post',
	data:data
  })
}
//中标候选人公示编辑
export function editcadidate(data) {
  return request({
    url: "tender-notice/edit-cadidate",
    method: 'post',
	data:data
  })
}

//中标公告提交
export function createwin(data) {
  return request({
    url: "tender-notice/create-win",
    method: 'post',
	data:data
  })
}
//中标公告编辑
export function editwin(data) {
  return request({
    url: "tender-notice/edit-win",
    method: 'post',
	data:data
  })
}

// 中标人列表
export function winPersonInfo(projectId) {
  return request({
    url: `/tender-decide/winPersonInfo/${projectId}`,
    method: 'get'
  })
}









// 招标文件下载
export function bidBookDownload(projectId) {
  return request({
    url: `tender-evaluate/bidBook-download/${projectId}`,
    method: 'get',
  })
}


// 工作台接口
export function projectConsole(params) {
  return request({
    url: "/project/console",
    method: 'get',
	params:params
  })
}

//采购商详情
export function contractDetails(projectId) {
    return request({
      url: `/tender-decide/contract/detail/${projectId}`,
      method: 'get',
    })
  }

