import request from '@/utils/request'



// 2.1在线报名

// 2.1.1
// 查看招标公告
export function biddingDetail(id) {
  return request({
    url: `notice/bidding/${id}`,
    method: 'get',
  })
}
// 获取采购商是否点击邀请了的状态和他是邀请还是公共的
export function inviteStatus(projectId) {
  return request({
    url: `/bidder-apply/inviteStatus/${projectId}`,
    method: 'get',
  })
}
// 拒绝邀请
export function refuseInvite(projectId) {
  return request({
    url: `/bidder-apply/refuseInvite/${projectId}`,
    method: 'get',
  })
}


// 2.1.2
//供应商报名
export function projectapply(data) {
  return request({
    url: "bidder-apply/apply",
    method: 'post',
	data:data
  })
}

// 2.1.3
//查看询价公告里的商品报价列表
export function offerBidderDetail(params) {
  return request({
    url: "bidder-apply/offerBidder/detail",
    method: 'get',
	params:params
  })
}


// 其他地方的商品报价列表
export function commoditylist(projectId) {
  return request({
    url: `/bidder-apply/commodity/list/${projectId}`,
    method: 'get',
  })
}

//供应商对询价公告的标的进行报价
export function offerPrice(data) {
  return request({
    url: "bidder-apply/offer-price",
    method: 'post',
	data:data
  })
}

// 参与报价的供应商的情况
export function offerBidderlist(projectId) {
  return request({
    url: `bidder-apply/offerBidder/list/${projectId}`,
    method: 'get',
  })
}




//2.2.1
// 查看询价公告
export function noticeEnquiry(id) {
  return request({
    url: `notice/enquiry/${id}`,
    method: 'get',
  })
}
// 招标文件下载
export function bidBooklist(params) {
  return request({
    url: "bidder-bidbook/bidBook/list",
    method: 'get',
	params:params
  })
}
// 检测是否能下载
export function downLoad(params) {
  return request({
    url:"bidder-bidbook/bidBook/downLoad",
    method: 'get',
	params:params
  })
}
//项目完整详情查看
export function projectdetail(id) {
  return request({
    url: `project/detail/${id}`,
    method: 'get',
  })
}

  //     ------------------------------------------------------------------------------------
//流程进度
export function timeInfo(projectId) {
  return request({
    url: `project/timeInfo/${projectId}`,
    method: 'get',
  })
}

// 标书费缴纳
export function bidBookpayment(data) {
  return request({
    url: "/bidder-bidbook/bidBook/payment",
    method: 'post',
	data:data
  })
}

// 保证金缴纳
export function bidderEarnestpayment(data) {
  return request({
    url: "/bidder-earnest/payment",
    method: 'post',
	data:data
  })
}


// 提出问题
export function interrogate(data) {
  return request({
    url: "bidder-clarifies/interrogate",
    method: 'post',
	data:data
  })
}

// 澄清确认
export function affirm(data) {
  return request({
    url: "bidder-clarifies/affirm",
    method: 'post',
	data:data
  })
}
// 查看澄清详情
export function clarifiesDetail(noticeId) {
  return request({
    url: `bidder-clarifies/clarifies/detail/${noticeId}`,
    method: 'get',
  })
}
// 查看问题详情
export function questionDetail(questionId) {
  return request({
    url: `bidder-clarifies/question/detail/${questionId}`,
    method: 'get',
  })
}

//查看某个澄清的 投标方列表
// export function bidClarifies(params) {
//   return request({
//     url: '/clarifies/bid-clarifies/list',
//     method: 'get',
//     params: params
//   })
// }
//.........--------------
// 变更公告查看
export function changeNoticelist(projectId) {
  return request({
    url: `bidder/project/changeNotice/list/${projectId}`,
    method: 'get',
  })
}

// 2.2.2
// 投标文件列表(下拉框)
export function bidBooks(projectId) {
  return request({
    url: `tender/bidBook/list/${projectId}`,
    method: 'get',
  })
}

//递交投标文件
export function bidFile(data) {
  return request({
    url: "tender/upload/bidFile",
    method: 'post',
	data:data
  })
}
// 制作投标文件
export function makeFile(data) {
  return request({
    url: "tender/makeFile",
    method: 'post',
	data:data
  })
}
// 撤回投标文件
export function revocationBidbFile(bidFileId) {
  return request({
    url: `tender/revocation/bidbFile/${bidFileId}`,
    method: 'put',
  })
}


//2.2.3

// 2.2.4 评标
// 评标问题澄清列表
export function clarifyInquirylist(params) {
  return request({
    url: "bidder-evaluate/clarify-inquiry/list",
    method: 'get',
	params:params
  })
}
// 查看问题
export function question(questionId) {
  return request({
    url: `bidder-evaluate/question/detail/${questionId}`,
    method: 'get',
  })
}

// 回复问题
export function evaluateReply(data) {
  return request({
    url: "bidder-evaluate/reply",
    method: 'post',
	data:data
  })
}
// 查看回复
export function reply(replyId) {
  return request({
    url: `bidder-evaluate/reply/detail/${replyId}`,
    method: 'get',
  })
}
// 查看开标一览表
export function openInfolist(projectId) {
  return request({
    url: `open-bid/openInfo/${projectId}`,
    method: 'get',
  })
}

// 2.2.5 定标
// 查看招标结果通知书
export function bidResultBook(params) {
  return request({
    url: "bidder-decide/bidResultBook/detail",
    method: 'get',
	params:params
  })
}

// 查看合同
export function contractdetail(projectId) {
  return request({
    url: `bidder-decide/contract/detail/${projectId}`,
    method: 'get',
  })
}

// 中标公告查看
export function noticeWin(projectId) {
  return request({
    url: `notice/winNotice/${projectId}`,
    method: 'get',
  })
}
// 中标候选人公示查看
export function cadidate(projectId) {
  return request({
    url: `notice/cadidate?projectId=${projectId}`,
    method: 'get',
  })
}
// 中标通知书查看
export function winBookdetail(projectId) {
  return request({
    url: `bidder-decide/winBook/detail/${projectId}`,
    method: 'get',
  })
}

// 2.2.3  开标大厅
// 签到解密简略
export function openBidsign(projectId) {
  return request({
    url: `bidder-openBid/signInfo?projectId=${projectId}`,
    method: 'get',
  })
}

// 开标大厅三个截止时间
export function opentimeInfo(projectId) {
  return request({
    url: `open-bid/timeInfo/${projectId}`,
    method: 'get',
  })
}
// 解密
export function decode(projectId) {
  return request({
    url: `open-bid/decode?projectId=${projectId}`,
    method: 'put',
  })
}

// 签名
export function signature(projectId) {
  return request({
    url: `open-bid/signature?projectId=${projectId}`,
    method: 'put',
  })
}



//标书费缴纳详情
export function bidbookDetail(projectId) {
  return request({
    url: `/bidder-bidbook/detail?projectId=${projectId}`,
    method: 'get',
  })
}

// 标书费编辑
export function editBidBook(data) {
  return request({
    url: "bidder-bidbook/edit-bidBook/payment",
    method: 'post',
	data:data
  })
}

//保证金缴纳详情
export function earnestDetail(projectId) {
  return request({
    url: `bidder-earnest/detail?projectId=${projectId}`,
    method: 'get',
  })
}

// 保证金编辑
export function earnestEdit(data) {
  return request({
    url: "bidder-earnest/edit",
    method: 'post',
	data:data
  })
}

// 新增接口
// 查看是否报价状态
export function isOffer(projectId) {
  return request({
    url: `bidder-apply/isOffer/${projectId}`,
    method: 'get',
  })
}

// 查看是否投递的状态
export function bidCondition(projectId) {
  return request({
    url: `tender/bid/condition/${projectId} `,
    method: 'get',
  })
}