import axios from 'axios'
import { Message, MessageBox } from 'element-ui'
// import store from '../store'
// import { getToken,get } from '@/utils/auth'

// 创建axios实例
const service = axios.create({
  // baseURL: 'http://192.168.200.201:8082/apis', 
  baseURL: 'http://192.168.3.35:8085/apis',
  timeout: 35000 // 请求超时时间
})

// request拦截器
service.interceptors.request.use(config => {
	let token=localStorage.getItem("token")
	if(token||token!=="undefined"){
	  config.headers['token']=token;
	}
	return config
}, error => {
  // Do something with request error
  console.log(error) // for debug
  Promise.reject(error)
})

// respone拦截器
service.interceptors.response.use(
  response => {
  /**
  * code为非200是抛错 可结合自己业务进行修改
  */
    const res = response
    if (res.status !== 200) {
      alert('接口错误')	
    }else {
      return res.data
    }
  },
  error => {
    if(error.response.status == 500){
    	 Message.error("登陆失效,请重新登录!")
    //    localStorage.removeItem('token');
    //    setTimeout(function () {
    //      // location.href = 'http://192.168.200.201:8081/';
		  // location.href = 'http://localhost:3000/';
    //    }, 2000);
    }
  }
)

export default service
