import Vue from 'vue';
import App from './App.vue';
import router from './router';
import ElementUI from 'element-ui';
import VueI18n from 'vue-i18n';
import { messages } from './components/common/i18n';
import 'element-ui/lib/theme-chalk/index.css'; // 默认主题
// import './assets/css/theme-green/index.css'; // 浅绿色主题
import './assets/css/icon.css';
import './components/common/directives';
import 'babel-polyfill';

import store from "@/store/index";

import VueClipboard from 'vue-clipboard2'
Vue.use(VueClipboard)

Vue.config.productionTip = false;
Vue.use(VueI18n);
Vue.use(ElementUI, {
    size: 'small'
});
const i18n = new VueI18n({
    locale: 'zh',
    messages
});
     


new Vue({
    router,
    i18n,
    store,
    render: h => h(App)
}).$mount('#app');


// 使用钩子函数对路由进行权限跳转
// router.beforeEach((to, from, next) => {
//     document.title = `${to.meta.title} | vue-manage-system`;
//     const role = localStorage.getItem('user');
//     console.log(role)
//     if (!role && to.path !== '/login') {
//         next('/login');
//     } else if (to.meta.permission) {
//         // 如果是管理员权限则可进入，这里只是简单的模拟管理员权限而已
//         role === 'admin' ? next() : next('/403');
//     } else {
//         // 简单的判断IE10及以下不进入富文本编辑器，该组件不兼容
//         if (navigator.userAgent.indexOf('MSIE') > -1 && to.path === '/editor') {
//             Vue.prototype.$alert('vue-quill-editor组件不兼容IE10及以下浏览器，请使用更高版本的浏览器查看', '浏览器不兼容通知', {
//                 confirmButtonText: '确定'
//             });
//         } else {
//             next();
//         }
//     }
// });

// router.beforeEach((to, from, next) => {
//     document.title = `${to.meta.title} | vue-manage-system`;
//     const role = localStorage.getItem('user');
//    console.log(role)
//     if (!role && to.path !== '/login') {
//         next('/login');
//         let newTime = parseInt(new Date().getTime() / 1000);
//             let rand_str = Math.floor(Math.random() * 99999);
//             this.$api
//                 .getUserInfo({
//                     signature: md5.hexMD5(
//                         `app_id=62720965&app_secret=LAsBNSOcufUjeZnKafVKLlmVzGkefmZb&device_id=${rand_str}&rand_str=${rand_str}&timestamp=${newTime}`
//                     ),
//                     app_id: 62720965,
//                     device_id: rand_str,
//                     timestamp: newTime,
//                     rand_str: rand_str
//                 })
//                 .then(res => {
//                     console.log(res);
//                     if (res.code == '1') {
//                         this.access_token = res.data.access_token;
//                         localStorage.setItem('token', this.access_token);
//                     }
//                 });
//     } else {
//         next('/dashboard');
//     }
// });

//路由守卫
// router.beforeEach((to, from, next)=>{
//     //路由中设置的needLogin字段就在to当中 
//     console.log(window.localStorage);
//     if(window.localStorage.user){
    
//      // console.log(to.path) //每次跳转的路径
//      if(to.path === '/'){
//       //登录状态下 访问login.vue页面 会跳到index.vue
//       next({path: '/dashboard'});
//      }else{
//       next();
//      }
//     }else{
//      // 如果没有session ,访问任何页面。都会进入到 登录页
//      if (to.path === '/') { // 如果是登录页面的话，直接next() -->解决注销后的循环执行bug
//       next();
//      } else { // 否则 跳转到登录页面
//       next({ path: '/' });
//      }
//     }
//   })