
const path = require("path");

function resolve(dir) {
    return path.join(__dirname, dir);
}
module.exports = {
    // publicPath: '/static/vue/index/',
    assetsDir: 'static',
    productionSourceMap: false,
    chainWebpack: config => {
       config.resolve.alias.set('@components', resolve('src/components'))
       config.resolve.alias.set('@lib', resolve('src/lib'))
       config.resolve.alias.set('@styles', resolve('src/styles'))
       config.resolve.alias.set('@enum', resolve('src/enum'))
       config.resolve.alias.set('@common', resolve('src/common'))
       config.resolve.alias.set('@static', resolve('src/static'))
       config.resolve.alias.set('@api', resolve('src/api'))
       config.resolve.alias.set('@utils', resolve('src/utils'))
	   config.resolve.alias.set("@", resolve("src")); // key,value自行定义，比如.set('@@', resolve('src/components'))
    },
    // devServer: {
    //     port:3001,
    //     proxy: {
    //         '/api':{
    //             target:'http://xd.cbeid.cn',
    //             // changeOrigin:true,
    //             // pathRewrite:{
    //             //     '/api':''
    //             // }
    //         }
    //     }
    // }
   
}