import request from '@/utils/request'


// 采购商
// 2.1.1
// 创建招标项目
export function creatProject(data) {
  return request({
    url: '/tender-project/save',
    method: 'POST',
    data: data
  })
}

// 2.1.2
//  发送询价公告
export function createEnquiry(data) {
  return request({
    url: '/tender-notice/create-enquiry',
    method: 'POST',
    data: data
  })
}

// 发送招标公告
export function bidMessage(data) {
  return request({
    url: '/tender-notice/create-bidding',
    method: 'POST',
    data: data
  })
}

// 发送邀请公告
export function inviteMessage(data) {
  return request({
    url: '/tender-notice/create-invite',
    method: 'POST',
    data: data
  })
}

// 2.1.3
//采购商提出问题
export function purchaseAsk(data) {
  return request({
    url: '/clarifies/purchase-ask',
    method: 'POST',
    data: data
  })
}
// 采购商提出澄清
export function forwardClarify(data) {
  return request({
    url: '/tender-clarifies/forwardClarify',
    method: 'POST',
    data: data
  })
}


// 问题内容接口
export function questionDetail(id) {
  return request({
    url: `/tender-clarifies/question/${id}`,
    method: 'get'
  })
}

// 澄清内容接口
export function clarifiesDetail(id) {
  return request({
    url: `/tender-clarifies/clarifiesNotice/${id}`,
    method: 'get'
  })
} 	
//查看某个澄清的 投标方列表
export function bidClarifies(params) {
  return request({
    url: 'tender-clarifies/bid-clarifies/list',
    method: 'get',
    params: params
  })
}
//澄清确认回执查看
export function confirmation(confirmId) {
  return request({
    url: `tender-clarifies/confirm/detail/${confirmId}`,
    method: 'get'
  })
}

// 新增
// 
// 投标信息查看
export function reviewInfomation(projectId) {
  return request({
    url: `/tender-project/reviewInfomation/${projectId}`,
    method: 'get'
  })
}

// 变更公告管理
export function changeList(projectId) {
  return request({
    url: `/tender-notice/changeList/${projectId}`,
    method: 'get'
  })
}
// 发布变更公告
export function createChange(data) {
  return request({
    url: '/tender-notice/create-change',
    method: 'post',
    data: data
  })
}
// 变更公告详情
export function noticeChange(id) {
  return request({
    url: `/notice/change/${id}`,
    method: 'get'
  })
}


// 流标公告管理
export function abortiveList(projectId) {
  return request({
    url: `/tender-evaluate/bidFailed/${projectId}`,
    method: 'get'
  })
}
// 发布流标公告
export function createAbortive(data) {
  return request({
    url: '/tender-notice/create-abortive',
    method: 'post',
    data: data
  })
}

// 流标公告详情
export function noticeAbortive(id) {
  return request({
    url: `/notice/abortive/${id}`,
    method: 'get'
  })
}


// 流标公告管理
// export function reviewInfomation(projectId) {
//   return request({
//     url: `/tender-project/reviewInfomation/${projectId}`,
//     method: 'get'
//   })
// }

// 2.1.5

// 查看投标公司评审信息
export function CompanyEvaluatec(projectId) {
  return request({
    url: `/tender-evaluate/CompanyEvaluatec/${projectId}`,
    method: 'get'
  })
}
// 查看投标公司排名信息
export function companyRank(projectId) {
  return request({
    url: `/tender-evaluate/companyRank/${projectId}`,
    method: 'get'
  })
}


// 保存投标公司评审信息
export function saveCompanyEvaluate(data) {
  return request({
    url: '/tender-evaluate/saveCompanyEvaluate',
    method: 'post',
    data: data
  })
}
// 保存投标公司排名信息
export function saveCompanyRank(data) {
  return request({
    url: '/tender-evaluate/saveCompanyRank',
    method: 'post',
    data: data
  })
}
// 评标管理：新增问题
export function addQuestion(data) {
  return request({
    url: '/tender-evaluate/tenderQuiz/save',
    method: 'post',
    data: data
  })
}
// 获取递交了投标文件的供应商
export function bidsupplyList(projectId) {
  return request({
    url: `/tender-evaluate/bid-file/bidList/${projectId}`,
    method: 'get'
  })
}

// 获取澄清质疑列表
export function clarifyinquiryList(projectId) {
  return request({
    url: `/tender-evaluate/clarify-inquiry/list/${projectId}`,
    method: 'get'
  })
}
// 专家
// 查看问题详情
export function expertquestionDetail(questionId) {
  return request({
    url: `/tender-evaluate/question-detail/${questionId}`,
    method: 'get'
  })
}
//查看某个问题的回复详情
export function expertreplyDetail(questionId) {
  return request({
    url: `/tender-evaluate/reply-deatil/${questionId}`,
    method: 'get'
  })
}
// 2.1.6
// 确定中标人
export function winnerSave(data) {
  return request({
    url: "/tender-decide/winner/save",
    method: 'post',
	data:data
  })
}
// 中标候选人名单
export function candidate(projectId) {
  return request({
    url: `/tender-decide/candidate/${projectId}`,
    method: 'get'
  })
}
// 中标通知书列表
export function sentBookList(projectId) {
  return request({
    url: `/tender-decide/sentBook/list/${projectId}`,
    method: 'get'
  })
}
// 保存/编辑中标通知书
export function editSentBook(data) {
  return request({
    url: "/tender-decide/winner/sentBook",
    method: 'post',
	data:data
  })
}
// 招标结果通知书列表
export function resultBookList(projectId) {
  return request({
    url: `tender-decide/resultBook/list/${projectId}`,
    method: 'get'
  })
}
// 保存/编辑中标通知书
export function editResultBook(data) {
  return request({
    url: "/tender-decide/resultBook/save",
    method: 'post',
	data:data
  })
}
// 合同管理保存
export function contract(data) {
  return request({
    url: "/tender-decide/contract/save",
    method: 'post',
	data:data
  })
}

// 
// 开标设置
export function bidsetting(data) {
  return request({
    url: "/tender-openBid/bid-setting",
    method: 'post',
	data:data
  })
}

