import request from '@/utils/request'



// 2.1在线报名

// 2.1.1
// 查看招标公告
export function biddingDetail(id) {
  return request({
    url: `notice/bidding/${id}`,
    method: 'get',
  })
}

// 2.1.2
//供应商报名
export function projectapply(data) {
  return request({
    url: "bidder-apply/apply",
    method: 'post',
	data:data
  })
}

// 2.1.3
// 查看询价公告里的商品报价列表
export function commoditylist(projectId) {
  return request({
    url: `/bidder-apply/commodity/list/${projectId}`,
    method: 'get',
  })
}

//供应商对询价公告的标的进行报价
export function offerPrice(data) {
  return request({
    url: "bidder-apply/offer-price",
    method: 'post',
	data:data
  })
}

// 参与报价的供应商的情况
export function offerBidderlist(projectId) {
  return request({
    url: `bidder-apply/offerBidder/list/${projectId}`,
    method: 'get',
  })
}




//2.2.1
// 查看询价公告
export function noticeEnquiry(id) {
  return request({
    url: `notice/enquiry/${id}`,
    method: 'get',
  })
}
// 招标文件下载
export function bidBooklist(params) {
  return request({
    url: "bidder-bidbook/bidBook/list",
    method: 'get',
	params:params
  })
}
// 检测是否能下载
export function downLoad(projectId) {
  return request({
    url: `bidder-bidbook/bidBook/downLoad/${projectId}`,
    method: 'get',
  })
}
//项目完整详情查看
export function projectdetail(id) {
  return request({
    url: `project/detail/${id}`,
    method: 'get',
  })
}
//流程进度
export function timeInfo(projectId) {
  return request({
    url: `project/timeInfo/${projectId}`,
    method: 'get',
  })
}

// 标书费缴纳
export function bidBookpayment(data) {
  return request({
    url: "/bidder-bidbook/bidBook/payment",
    method: 'post',
	data:data
  })
}
// 保证金缴纳
export function bidderEarnestpayment(data) {
  return request({
    url: "/bidder-earnest/payment",
    method: 'post',
	data:data
  })
}

//查看某个澄清的 投标方列表
export function bidClarifies(params) {
  return request({
    url: '/clarifies/bid-clarifies/list',
    method: 'get',
    params: params
  })
}