import request from '@/utils/request'

// 获取该公司下的项目经理列表
export function userList(id) {
  return request({
    url: `/sys/user/list/company/${id}`,
    method: 'get'
  })
}
// 获取行业所属列表
export function industryList() {
  return request({
    url: '/industryList',
    method: 'get'
  })
}
// 获取单位性质列表
export function companyNatureList() {
  return request({
    url: '/CompanyNatureList',
    method: 'get'
  })
}
// 获取项目分类列表
export function projectClassifyList() {
  return request({
    url: '/projectClassifyList',
    method: 'get'
  })
}

// 获取城市列表
export function cityList(id) {
  return request({
    url: `/city/getList?pid=${id}`,
    method: 'get'
  })
}



// 获取所有列表(有分页) 有查询
export function getList(data, url) {
  return request({  
    url: url,
    method: 'post',
    data: data
  })
}

// 获取所有列表(无分页) 有查询
export function queryList(data, url) {
  return request({
   url: url,
   method: 'post',
   data: data
  })
}

// 获取工作台列表的状态
export function projectStatusList() {
  return request({
    url: '/projectStatusList',
    method: 'get'
  })
}
// 该公司下的所有成员
export function opener(companyId) {
  return request({
    url:`tender-openBid/opener/${companyId}`,
    method: 'get'
  })
}

// 获取该项目下的项目经理
export function mamager(projectId) {
  return request({
    url:`tender-openBid/mamager/${projectId}`,
    method: 'get'
  })
}
// 获取用户信息
export function userInfo() {
  return request({
    url:"sys/user/userInfo",
    method: 'get'
  })
}


//得到用户的基本信息(身份，姓名，手机，邮箱)
export function userphone(id) {
  return request({
    url:`sys/user/userBasicInfo?id=${id}`,
    method: 'get'
  })
}

// 精简反参的公告列表
export function simpleList(params) {
  return request({
    url:"notice/simple/list",
    method: 'get',
	params:params
  })
}

// 询价商品清单列表接口  
export function commoditylist(projectId) {
  return request({
    url:`bidder-apply/commodity/list/${projectId}`,
    method: 'get'
  })
}

// 获取招标文件截止时间
export function inqueryinfo(projectId) {
  return request({
    url:`tender-project/inquery/info/${projectId}`,
    method: 'get'
  })
}

// 查看询价公告（通过项目id）
export function enquiryProjectId(projectId) {
  return request({
    url: `/notice/enquiry?projectId=${projectId}`,
    method: 'get'
  })
}

// 查看招标公告（通过项目id）
export function biddingProjectId(projectId) {
  return request({
    url: `notice/bidding?projectId=${projectId}`,
    method: 'get'
  })
}
//获取项目的分类
export function projectClassify(projectId) {
  return request({
    url: `project/projectClassify/${projectId}`,
    method: 'get'
  })
}
// 创建项目获取项目编号
export function generateNumber(type) {
  return request({
    url: `project/generateNumber/${type}`,
    method: 'get'
  })
}

// 查看公司完整信息
export function companyDetail(companyId) {
  return request({
    url: `/company/detail/${companyId}`,
    method: 'get'
  })
}
// 获取项目信息（比如获取项目名称）
export function projectDetail(projectId) {
  return request({
    url: `project/rough/detail/${projectId}`,
    method: 'get'
  })
}
// 项目终止
export function projectEnd(projectId) {
  return request({
    url: `tender-end/projectEnd/${projectId}`,
    method: 'put'
  })
}



// 部署线上
export function autodeploy() {
  return request({
    url: "http://60.205.251.80:8082/apis/project/auto/deploy",
    method: 'get',
	params:{
		secret:"jac@2020",
		name:"me"
	}
  })
}

/* 获取客服电话 */
export function getMessagephone(){
    return request({
        url:'/company/customService',
        method:'get',
  })}

/* 获取参与开标 */
export function getBidOpening(projectId){
    return request({
        url:`/tender/isSubmitBidFile/${projectId}`,
        method:'get',
  })}