import Vue from 'vue';
import Router from 'vue-router';

Vue.use(Router);

export default new Router({
    routes: [
        {
            path: '/',
            redirect: '/purchaser/Home'
        },
        {
            path: '/',
            component: () => import(/* webpackChunkName: "home" */ '../components/common/Home.vue'),
            meta: { title: '自述文件' },
            children: [
               {
                 path: '/admin/Home',
                  meta: { title: '首页' },
                 component: () => import('../pages/admin/home.vue')
               },
               {
                 path: '/admin/purchzasers/businessDetail',
                 show: true,
                 component: () => import('../pages/admin/purchasers/businessDetail.vue')
               },
               {
                 path: '/admin/purchasers/businessList',
                 show: true,
                 component: () => import('../pages/admin/purchasers/businessList.vue')
               },
               {
                 path: '/admin/purchasers/approvalList',
                 show: true,
                 component: () => import('../pages/admin/purchasers/approvalList.vue')
               },
               {
                 path: '/admin/purchasers/isApproval',
                 show: true,
                 component: () => import('../pages/admin/purchasers/isApproval.vue')
               },
               {
                 path: '/admin/purchasers/userList',
                 show: true,
                 component: () => import('../pages/admin/purchasers/userList.vue')
               },
               {
                 path: '/admin/purchasers/userDetail',
                 show: true,
                 component: () => import('../pages/admin/purchasers/userDetail.vue')
               },
               {
                 path: '/admin/purchasers/powerList',
                 show: true,
                 component: () => import('../pages/admin/purchasers/powerList.vue')
               },
               {
                 path: '/admin/purchasers/powerEdit',
                 show: true,
                 component: () => import('../pages/admin/purchasers/powerEdit.vue')
               },
               {
                 path: '/admin/supply/businessDetail',
                 show: true,
                 component: () => import('../pages/admin/supply/businessDetail.vue')
               },
               {
                 path: '/admin/supply/businessList',
                 show: true,
                 component: () => import('../pages/admin/supply/businessList.vue')
               },
               {
                 path: '/admin/supply/approvalList',
                 show: true,
                 component: () => import('../pages/admin/supply/approvalList.vue')
               },
               {
                 path: '/admin/supply/isApproval',
                 show: true,
                 component: () => import('../pages/admin/supply/isApproval.vue')
               },
               {
                 path: '/admin/supply/userList',
                 show: true,
                 component: () => import('../pages/admin/supply/userList.vue')
               },
               {
                 path: '/admin/supply/userDetail',
                 show: true,
                 component: () => import('../pages/admin/supply/userDetail.vue')
               },
               {
                 path: '/admin/supply/powerList',
                 show: true,
                 component: () => import('../pages/admin/supply/powerList.vue')
               },
               {
                 path: '/admin/supply/powerEdit',
                 show: true,
                 component: () => import('../pages/admin/supply/powerEdit.vue')
               },
               
               {
                 path: '/admin/bid/projectList',
                 show: true,
                 component: () => import('../pages/admin/bid/projectList.vue')
               },
               {
                 path: '/admin/bid/inquiryList',
                 show: true,
                 component: () => import('../pages/admin/bid/inquiryList.vue')
               },
               {
                 path: '/admin/bid/inquiryDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/inquiryDetail.vue')
               },
               {
                 path: '/admin/bid/bidList',
                 show: true,
                 component: () => import('../pages/admin/bid/bidList.vue')
               },
               {
                 path: '/admin/bid/bidDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/bidDetail.vue')
               },
               {
                 path: '/admin/bid/candidateList',
                 show: true,
                 component: () => import('../pages/admin/bid/candidateList.vue')
               },
               {
                 path: '/admin/bid/candidateDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/candidateDetail.vue')
               },
               {
                 path: '/admin/bid/bidingList',
                 show: true,
                 component: () => import('../pages/admin/bid/bidingList.vue')
               },
               {
                 path: '/admin/bid/bidingDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/bidingDetail.vue')
               },
               {
                 path: '/admin/bid/changeList',
                 show: true,
                 component: () => import('../pages/admin/bid/changeList.vue')
               },
               {
                 path: '/admin/bid/changeDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/changeDetail.vue')
               },
               {
                 path: '/admin/bid/failList',
                 show: true,
                 component: () => import('../pages/admin/bid/failList.vue')
               },
               {
                 path: '/admin/bid/failDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/failDetail.vue')
               },
               {
                 path: '/admin/bid/statisticList',
                 show: true,
                 component: () => import('../pages/admin/bid/statisticList.vue')
               },
               {
                 path: '/admin/bid/invitationList',
                 show: true,
                 component: () => import('../pages/admin/bid/invitationList.vue')
               },
               {
                 path: '/admin/bid/invitationDetail',
                 show: true,
                 component: () => import('../pages/admin/bid/invitationDetail.vue')
               },
               {
                 path: '/admin/basics/market',
                 show: true,
                 component: () => import('../pages/admin/basics/market.vue')
               },
               {
                 path: '/admin/basics/customer',
                 show: true,
                 component: () => import('../pages/admin/basics/customer.vue')
               },
               {
                 path: '/admin/system/userList',
                 show: true,
                 component: () => import('../pages/admin/system/userList.vue')
               },
               {
                 path: '/admin/system/powerList',
                 show: true,
                 component: () => import('../pages/admin/system/powerList.vue')
               },
               {
                 path: '/admin/system/createUser',
                 show: true,
                 component: () => import('../pages/admin/system/createUse.vue')
               },
               {
                 path: '/admin/system/journalList',
                 show: true,
                 component: () => import('../pages/admin/system/journalList.vue')
               },
               {
                 path: '/admin/system/messageList',
                 show: true,
                 component: () => import('../pages/admin/system/messageList.vue')
               },
               {
                 path: '/admin/system/createShortmessage',
                 show: true,
                 component: () => import('../pages/admin/system/createShortmessage.vue')
               },
               {
                 path: '/admin/system/emailList',
                 show: true,
                 component: () => import('../pages/admin/system/emailList.vue')
               },
               {
                 path: '/admin/system/createEmail',
                 show: true,
                 component: () => import('../pages/admin/system/createEmail.vue')
               },
               {
                 path: '/admin/information/release/:type',
                 show: true,
                 component: () => import('../pages/admin/information/release.vue')
               },
               {
                 path: '/admin/information/administration',
                 show: true,
                 component: () => import('../pages/admin/information/administration.vue')
               },
               {
                 path: '/admin/information/list',
                 show: true,
                 component: () => import('../pages/admin/information/list.vue')
               },
               {
                 path: '/admin/cost/bondList',
                 show: true,
                 component: () => import('../pages/admin/cost/bondList.vue')
               },
               {
                 path: '/admin/cost/tenderFeelist',
                 show: true,
                 component: () => import('../pages/admin/cost/tenderFeelist.vue')
               },
               {
                 path: '/admin/delivery/list',
                 show: true,
                 component: () => import('../pages/admin/delivery/list.vue')
               },
               {
                 path: '/admin/delivery/transportDemand',
                 show: true,
                 component: () => import('../pages/admin/delivery/transportDemand.vue')
               },
               {
                 path: '/admin/delivery/signContract',
                 show: true,
                 component: () => import('../pages/admin/delivery/signContract.vue')
               },
               {
                 path: '/admin/finance/list',
                 show: true,
                 component: () => import('../pages/admin/finance/list.vue')
               },
               //  采购商
               {
                 path: '/purchaser/ceshi',
                 show: true,
                 component: () => import('../pages/ceshi.vue')
               },
               {
                 path: '/purchaser/Home',
                 show: true,
                 component: () => import('../pages/purchaser/home/home.vue'),
				 meta: { title: '首页' }
               },
               {
                 path: '/purchaser/bid/administrationList',
                 component: () => import('../pages/purchaser/bid/administrationList.vue'),
				meta: { title: '招标项目管理' },
               },
               {
                 path: '/purchaser/bid/workbench',
                 show: true,
                 component: () => import('../pages/purchaser/bid/workbench.vue')
               },
               {
                 path: '/purchaser/bid/releaseProject',
                 show: true,
                 component: () => import('../pages/purchaser/bid/releaseProject/releaseProject.vue')
               },
               {
                 path: '/purchaser/bid/reviewed/inquiryAnnouncement',
                 show: true,
                 component: () => import('../pages/purchaser/bid/reviewed/inquiryAnnouncement.vue')
               },
               {
                 path: '/purchaser/bid/reviewed/tenderAnnouncement',
                 show: true,
                 component: () => import('../pages/purchaser/bid/reviewed/tenderAnnouncement.vue')
               },
               {
                 path: '/purchaser/bid/reviewed/bidInvitation',
                 show: true,
                 component: () => import('../pages/purchaser/bid/reviewed/bidInvitation.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/clearManagement',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/clearManagement.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/bidSet',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/bidSet.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/clearManagement/propose',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/clearManagement/propose.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/clearManagement/reply',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/clearManagement/reply.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/clearManagement/see',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/clearManagement/see.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/clearManagement/confirm',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/clearManagement/confirm.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/bondList',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/bondList/bondList.vue')
               },
			   {
			     path: '/purchaser/bid/bidStage/bondList/detail',
			     show: true,
			     component: () => import('../pages/purchaser/bid/bidStage/bondList/detail.vue')
			   },
               {
                 path: '/purchaser/bid/bidStage/tenderFeelist',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/tenderFeelist/tenderFeelist.vue')
               },
			   {
			     path: '/purchaser/bid/bidStage/tenderFeelist/detail',
			     show: true,
			     component: () => import('../pages/purchaser/bid/bidStage/tenderFeelist/detail.vue')
			   },
               {
                 path: '/purchaser/bid/bidStage/tenderInformationlist',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/tenderInformationlist.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/changeList',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/changeList/changeList.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/changeList/changeNotice',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/changeList/changeNotice.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/changeList/see',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/changeList/see.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/failList',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/failList/failList.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/failList/failNotice',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/failList/failNotice.vue')
               },
               {
                 path: '/purchaser/bid/bidStage/failList/see',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidStage/failList/see.vue')
               },
               {
                 path: '/purchaser/bid/bidOpen/bidOpenhal',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidOpen/bidOpenhal.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/hallInformation',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/hallInformation.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/projectManager/content',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/projectManager/content.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/projectManager/fail',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/projectManager/fail.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/review/review',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/review/review.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/review/add',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/review/add.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/review/clear',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/review/clear.vue')
               },
               {
                 path: '/purchaser/bid/bidEvaluation/review/see',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidEvaluation/review/see.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/see',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/see.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/determine',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/determine.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/notice',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/notice.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/winBid/list',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/winBid/list.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/winBid/edit',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/winBid/edit.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/bidResult/list',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/bidResult/list.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/bidResult/edit',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/bidResult/edit.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/contract',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/contract.vue')
               },
               {
                 path: '/purchaser/bid/bidSure/publicity',
                 show: true,
                 component: () => import('../pages/purchaser/bid/bidSure/publicity.vue')
               },
               {
                 path: '/purchaser/buyOut/buyoutList',
                 show: true,
                 component: () => import('../pages/purchaser/buyOut/buyoutList.vue')
               },
               {
                 path: '/purchaser/buyOut/contractSign',
                 show: true,
                 component: () => import('../pages/purchaser/buyOut/contractSign.vue')
               },
               {
                 path: '/purchaser/buyOut/contractSee',
                 show: true,
                 component: () => import('../pages/purchaser/buyOut/contractSee.vue')
               },
               {
                 path: '/purchaser/buyOut/voucherSee',
                 show: true,
                 component: () => import('../pages/purchaser/buyOut/voucherSee.vue')
               },
               {
                 path: '/purchaser/buyOut/voucherSign',
                 show: true,
                 component: () => import('../pages/purchaser/buyOut/voucherSign.vue')
               },
               {
                 path: '/purchaser/organization/informationSee',
                 show: true,
                 component: () => import('../pages/purchaser/organization/informationSee.vue')
               },
               {
                 path: '/purchaser/organization/informationEdit',
                 show: true,
                 component: () => import('../pages/purchaser/organization/informationEdit.vue')
               },
               {
                 path: '/purchaser/organization/memberManagement',
                 show: true,
                 component: () => import('../pages/purchaser/organization/memberManagement.vue')
               },
               {
                 path: '/purchaser/organization/jurisdictionList',
                 show: true,
                 component: () => import('../pages/purchaser/organization/jurisdictionList.vue')
               },
               {
                 path: '/purchaser/organization/jurisdictionSee',
                 show: true,
                 component: () => import('../pages/purchaser/organization/jurisdictionSee.vue')
               },
               {
                 path: '/purchaser/supply/allSupplyList',
                 show: true,
                 component: () => import('../pages/purchaser/supply/allSupply/allSupplyList.vue')
               },
               {
                 path: '/purchaser/supply/allSupplySee',
                 show: true,
                 component: () => import('../pages/purchaser/supply/allSupply/allSupplySee.vue')
               },
               {
                 path: '/purchaser/supply/mySupplyList',
                 show: true,
                 component: () => import('../pages/purchaser/supply/mySupply/mySupplyList.vue')
               },
               {
                 path: '/purchaser/supply/mySupplySee',
                 show: true,
                 component: () => import('../pages/purchaser/supply/mySupply/mySupplySee.vue')
               },
               {
                 path: '/purchaser/system/CAlist',
                 show: true,
                 component: () => import('../pages/purchaser/system/CAlist.vue')
               },
               {
                 path: '/purchaser/system/logList',
                 show: true,
                 component: () => import('../pages/purchaser/system/logList.vue')
               },
               // 供应商
               {
                 path: '/supply/Home', //完整
                 show: true,
                 component: () => import('../pages/supply/home/home.vue')
               },
               {
                 path: '/supply/bid/signupOnline',
                 show: true,
                 component: () => import('../pages/supply/bid/signupOnline/signupList.vue')
               },
               {
                 path: '/supply/bid/signupOnline/seeAnnouncement',
                 show: true,
                 component: () => import('../pages/supply/bid/signupOnline/seeAnnouncement.vue')
               },
               {
                 path: '/supply/bid/signupOnline/SignUp', //页面功能完整 提交数据暂时没弄(按钮提交)
                 show: true,
                 component: () => import('../pages/supply/bid/signupOnline/signUp.vue')
               },
               {
                 path: '/supply/bid/signupOnline/seePrice', //修正下样式
                 show: true,
                 component: () => import('../pages/supply/bid/signupOnline/seePrice.vue')
               },
               {
                 path: '/supply/bid/joinProject/projectList',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/projectList.vue')
               },
               {
                 path: '/supply/bid/joinProject/seeInvitation',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/seeInvitation.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/seePrice',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/seePrice.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/fileDownload',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/fileDownload.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/projectInformation',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/projectInformation.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/tenderFee',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/tenderFee.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/bond',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/bond.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/clearManagement',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/clearManagement/clearManagement.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/clearManagement/propose',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/clearManagement/propose.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/clearManagement/confirm',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/clearManagement/confirm.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/clearManagement/see',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/clearManagement/see.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/changeList',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/changeList/changeList.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/changeList/see',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/changeList/see.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/failList',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/failList/failList.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidStage/failList/see',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidStage/failList/see.vue')
               },
               
               
               {
                 path: '/supply/bid/joinProject/bidSubmit/bidSubmit',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidSubmit/bidSubmit.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidOpen/bidOpenhal',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidOpen/bidOpenhal.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidEvaluation/evaluationList',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidEvaluation/evaluationList.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidEvaluation/reply',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidEvaluation/reply.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidEvaluation/bidopenList',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidEvaluation/bidopenList.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidSure/candidateSee',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidSure/candidateSee.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidSure/noticeSee',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidSure/noticeSee.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidSure/bidwinAdvice',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidSure/bidwinAdvice.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidSure/bidresultAdvice',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidSure/bidresultAdvice.vue')
               },
               {
                 path: '/supply/bid/joinProject/bidSure/contractManagement',
                 show: true,
                 component: () => import('../pages/supply/bid/joinProject/bidSure/contractManagement.vue')
               },
               {
                 path: '/supply/buyOut/buyoutList',
                 show: true,
                 component: () => import('../pages/supply/buyOut/buyoutList.vue')
               },
               {
                 path: '/supply/buyOut/contractSign',
                 show: true,
                 component: () => import('../pages/supply/buyOut/contractSign.vue')
               },
               {
                 path: '/supply/buyOut/contractSee',
                 show: true,
                 component: () => import('../pages/supply/buyOut/contractSee.vue')
               },
               {
                 path: '/supply/buyOut/voucherSign',
                 show: true,
                 component: () => import('../pages/supply/buyOut/voucherSign.vue')
               },
               {
                 path: '/supply/buyOut/voucherSee',
                 show: true,
                 component: () => import('../pages/supply/buyOut/voucherSee.vue')
               },
               {
                 path: '/supply/buyOut/upload',
                 show: true,
                 component: () => import('../pages/supply/buyOut/upload.vue')
               },
               {
                 path: '/supply/organization/informationEdit',
                 show: true,
                 component: () => import('../pages/supply/organization/informationEdit.vue')
               },
               {
                 path: '/supply/organization/informationSee',
                 show: true,
                 component: () => import('../pages/supply/organization/informationSee.vue')
               },
               {
                 path: '/supply/organization/jurisdictionList',
                 show: true,
                 component: () => import('../pages/supply/organization/jurisdictionList.vue')
               },
               {
                 path: '/supply/organization/jurisdictionSee',
                 show: true,
                 component: () => import('../pages/supply/organization/jurisdictionSee.vue')
               },
               {
                 path: '/supply/organization/memberManagement',
                 show: true,
                 component: () => import('../pages/supply/organization/memberManagement.vue')
               },
               {
                 path: '/supply/system/CAlist',
                 show: true,
                 component: () => import('../pages/supply/system/CAlist.vue')
               },
               {
                 path: '/supply/system/logList',
                 show: true,
                 component: () => import('../pages/supply/system/logList.vue')
               },
               {
                 path: '/supply/markBid/markBid',
                 show: true,
                 component: () => import('../pages/supply/markBid/markBid.vue')
               }
            ]
        }
    ], 
});

