import request from '@/utils/request'

// 成员列表删除
export function userdelete(userId) {
  return request({
    url:`sys/user/delete/${userId}`,
    method: 'delete',
  })
}


// 成员编辑
export function useredit(data) {
  return request({
    url:"sys/user/edit",
    method: 'post',
	data:data
  })
}

// 添加成员
export function useradd(data) {
  return request({
    url:"sys/user/add",
    method: 'post',
	data:data
  })
}

// 添加角色
export function roleadd(data) {
  return request({
    url:"sys/role/add",
    method: 'post',
	data:data
  })
}
// 角色列表
export function roleList(companyType) {
  return request({
    url:`sys/role/roleList?companyType=${companyType}`,
    method: 'get',
  })
}
// 角色删除
export function roledelete(roleId) {
  return request({
    url:`sys/role/delete/${roleId}`,
    method: 'delete',
  })
}
// 角色详情
export function roledetail(roleId) {
  return request({
    url:`sys/role/detail/${roleId}`,
    method: 'get',
  })
}
// 验证手机唯一性
export function checkAccount(account) {
  return request({
    url:`/sys/user/check/account/${account}`,
    method: 'get',
  })
}

// 权限菜单树
export function roleMenus(companyType) {
  return request({
    url: `/sys/menu/roleMenus?companyType=${companyType}`,
    method: 'get'
  })
}

// 公司信息编辑
export function companyedit(data) {
  return request({
    url:"company/edit",
    method: 'post',
	data:data
  })
}