import request from '@/utils/request'


// 采购商
// 2.1.1
// 创建招标项目
export function creatProject(data) {
  return request({
    url: '/tender-project/save',
    method: 'POST',
    data: data
  })
}

// 2.1.2
//  发送询价公告
export function createEnquiry(data) {
  return request({
    url: '/tender-notice/create-enquiry',
    method: 'POST',
    data: data
  })
}

// 发送招标公告
export function bidMessage(data) {
  return request({
    url: '/tender-notice/create-bidding',
    method: 'POST',
    data: data
  })
}

// 发送邀请公告
export function inviteMessage(data) {
  return request({
    url: '/tender-notice/create-invite',
    method: 'POST',
    data: data
  })
}

// 2.1.3
//采购商提出问题
export function purchaseAsk(data) {
  return request({
    url: '/clarifies/purchase-ask',
    method: 'POST',
    data: data
  })
}
// 采购商提出澄清
export function forwardClarify(data) {
  return request({
    url: '/clarifies/forwardClarify',
    method: 'POST',
    data: data
  })
}


// 问题内容接口
export function questionDetail(id) {
  return request({
    url: `/clarifies/question/${id}`,
    method: 'get'
  })
}
// 澄清内容接口
export function clarifiesDetail(id) {
  return request({
    url: `/clarifies/clarifies/${id}`,
    method: 'get'
  })
}

//获取投标方列表
export function bidClarifies(params) {
  return request({
    url: '/clarifies/bid-clarifies/list',
    method: 'get',
    params: params
  })
}

//澄清确认回执查看
export function confirmation(clarifiesId) {
  return request({
    url: `/clarifies/confirmation/${clarifiesId}`,
    method: 'get'
  })
}
// 投标信息查看
export function reviewInfomation(projectId) {
  return request({
    url: `/tender-project/reviewInfomation/${projectId}`,
    method: 'get'
  })
}

// 变更公告管理
export function changeList(projectId) {
  return request({
    url: `/tender-notice/changeList/${projectId}`,
    method: 'get'
  })
}
// 发布变更公告
export function createChange(data) {
  return request({
    url: '/tender-notice/create-change',
    method: 'post',
    data: data
  })
}
// 变更公告详情
export function noticeChange(id) {
  return request({
    url: `/notice/change/${id}`,
    method: 'get'
  })
}


// 流标公告管理
export function abortiveList(projectId) {
  return request({
    url: `/tender-evaluate/bidFailed/${projectId}`,
    method: 'get'
  })
}
// 发布流标公告
export function createAbortive(data) {
  return request({
    url: '/tender-notice/create-abortive',
    method: 'post',
    data: data
  })
}

// 变更公告详情
export function noticeAbortive(id) {
  return request({
    url: `/notice/abortive/${id}`,
    method: 'get'
  })
}


// 流标公告管理
// export function reviewInfomation(projectId) {
//   return request({
//     url: `/tender-project/reviewInfomation/${projectId}`,
//     method: 'get'
//   })
// }

// 2.1.5

// 查看投标公司评审信息
export function CompanyEvaluatec(projectId) {
  return request({
    url: `/tender-evaluate/CompanyEvaluatec/${projectId}`,
    method: 'get'
  })
}
// 查看投标公司排名信息
export function companyRank(projectId) {
  return request({
    url: `/tender-evaluate/companyRank/${projectId}`,
    method: 'get'
  })
}


// 保存投标公司评审信息
export function saveCompanyEvaluate(data) {
  return request({
    url: '/tender-evaluate/saveCompanyEvaluate',
    method: 'post',
    data: data
  })
}
// 保存投标公司排名信息
export function saveCompanyRank(data) {
  return request({
    url: '/tender-evaluate/saveCompanyRank',
    method: 'post',
    data: data
  })
}


