import request from '@/utils/request'

// 获取项目经理列表
export function userList(id) {
  return request({
    url: `/sys/user/list/company/${id}`,
    method: 'get'
  })
}
// 获取行业所属列表
export function industryList() {
  return request({
    url: '/industryList',
    method: 'get'
  })
}
// 获取项目分类列表
export function projectClassifyList() {
  return request({
    url: '/projectClassifyList',
    method: 'get'
  })
}

// 获取城市列表
export function cityList(id) {
  return request({
    url: `/city/getList?pid=${id}`,
    method: 'get'
  })
}

// 获取所有供应商列表列表
export function supplierList(type) {
  return request({
    url: `/company/list/${type}`,
    method: 'get'
  })
}


// 获取所有列表(有分页)
export function getList(data, url) {
  return request({  
    url: url,
    method: 'post',
    data: data
  })
}
