// noinspection JSAnnotator
import Vue from 'vue'
import JSZip from 'jszip'
import FileSaver from 'file-saver'

// import baseUtils from 'baseUtils'

// const staticStrUndefined = 'undefined'

// const staticDocument = typeof document === 'undefined' ? 0 : document

// var staticWindow = typeof window === 'undefined' ? 0 : window


const utils = {
  /**
   * 数组的深处copy
   * @param  {Array}
   * @return {Array}
   */
  deepCopy(data) {
    return JSON.parse(JSON.stringify(data))
  },

  /**
   * 数组对象去重复copy
   * @param  {Array}  数组
   * @param  {key}    去重复key
   * @return {Array}
   */
  unique(arr, key) {
    const res = new Map()
    return arr.filter(a => {
      const val = a[key]
      return !res.has(val) && res.set(val, 1)
    })
  },

  /**
   * 上传base64tupian
   * @param  file  文件
   * @param  {Object}    参数
   * @return {Promise}
   */
  //
  // self.$request({
  // url: API.businessLicensePhoto,
  // method: 'post',
  // data: {
  //   fileBase64Data: base64
  // }
  uploadBase64(file, url, params = {}) {
    return new Promise(resolve => {
      const reader = new FileReader()
      reader.onload = (evt) => {
        const base64 = evt.target.result
        const data = { ...params, fileBase64Data: base64 }
        Vue.prototype.$request({
          url,
          data,
          method: 'post'
        }).then(res => {
          resolve(res)
        })
      }
      reader.readAsDataURL(file)
    })

  },


  /**
   * 获取重复数据与去重复数据
   * @param  {Array}  数组
   * @param  {key}    去重复key
   * @return {Object} data 去重后的数据  uniqueData 重复数据
   */
  getUniqueData(arr, key) {
    const res = new Map()
    const uniqueArr = []
    const newData = arr.filter(a => {
      const val = a[key]
      if (res.has(val)) {
        uniqueArr.push(a)
      }
      return !res.has(val) && res.set(val, 1)
    })
    return { data: newData, uniqueData: uniqueArr }
  },

  /**
   * 下载文件
   * @param {Object} 下载接口入参
   */
  async downFile(params, url, fileName, method) {
    const loading = Vue.prototype.$loading()
    try {
      const result = await Vue.prototype.$request({
        url,
        method: method ? method : 'post',
        data: params,
        headers: {
          'Content-Type': 'application/json; charset=utf-8'
        },
        responseType: 'blob'
      })
      let name = ''
      if (result.headers['content-disposition']) {
        name = decodeURI(
          result.headers['content-disposition'].split('filename=')[1]
        )
      }

      const data = result.data
      const blob = new Blob([data], {
        type: 'application/vnd.ms-excel'
      })
      const downloadElement = document.createElement('a')
      const href = window.URL.createObjectURL(blob)
      downloadElement.href = href
      if (fileName) {
        name = fileName
      }
      downloadElement.download = name

      document.body.appendChild(downloadElement)
      downloadElement.click() // 点击下载
      document.body.removeChild(downloadElement)
      window.URL.revokeObjectURL(href)
    } finally {
      loading.close()
    }
  },

  /**
   * 下载文件formData
   * @param {Object} 下载接口入参
   */
  async downFileFormData(params, url) {
    const sessionId = Vue.prototype.$cookies.get('sessionId')
    const domain = Vue.prototype.$domain
    params._header = sessionId
    const form = document.createElement('form')
    const iframe = document.createElement('iframe')
    iframe.name = 'downForm'
    form.target = 'downForm'
    form.style.display = 'none'
    form.action = domain + url
    form.method = 'POST'
    document.body.appendChild(form)
    for (const key in params) {
      const input = document.createElement('input')
      input.type = 'hidden'
      input.name = key
      input.value = params[key]
      form.appendChild(input)
    }
    form.submit()
    form.remove()
    iframe.remove()

    // const loading = Vue.prototype.$loading()
    // try {
    //   const result = await Vue.prototype.$request({
    //     url,
    //     method: 'post',
    //     data: params,
    //     headers: {
    //       'Content-Type': 'application/x-www-form-urlencoded'
    //     },
    //     responseType: 'blob'
    //   })
    //   const name = decodeURI(
    //     result.headers['content-disposition'].split('filename=')[1]
    //   )
    //   const data = result.data
    //   const blob = new Blob([data], {
    //     type: 'application/vnd.ms-excel'
    //   })
    //   const downloadElement = document.createElement('a')
    //   const href = window.URL.createObjectURL(blob)
    //   downloadElement.href = href
    //   downloadElement.download = name
    //   document.body.appendChild(downloadElement)
    //   downloadElement.click() // 点击下载
    //   document.body.removeChild(downloadElement)
    //   window.URL.revokeObjectURL(href)
    // } catch (e) {
    //
    // }
  },


  /**
   * 下载单张图片
   * @params {String} 下载图片地址
   * @params {String} 图片名字
   */
  downImage(url, name) {
    const image = new Image()
    image.setAttribute('crossOrigin', 'anonymous')
    image.onload = function() {
      const canvas = document.createElement('canvas')
      canvas.width = image.width
      canvas.height = image.height
      const context = canvas.getContext('2d')
      context.drawImage(image, 0, 0, image.width, image.height)
      const url = canvas.toDataURL('image/png') //得到图片的base64编码数据

      const a = document.createElement('a') // 生成一个a元素
      const event = new MouseEvent('click') // 创建一个单击事件
      a.download = name || 'photo' // 设置图片名称
      a.href = url // 将生成的URL设置为a.href属性
      a.dispatchEvent(event) // 触发a的单击事件
    }
    image.src = url
  },

  /**
   * 批量下载打包zip
   * @params{Array} 图片组
   * @params{String} zip 名
   */

  downImages(arr, name) {
    const baseList = []
    const zip = new JSZip()
    const imgs = zip.folder(name)
    arr.forEach(item => {
      const image = new Image()
      image.setAttribute('crossOrigin', 'anonymous')

      image.onload = function() {
        const canvas = document.createElement('canvas')
        canvas.width = image.width
        canvas.height = image.height

        const context = canvas.getContext('2d')
        context.drawImage(image, 0, 0, image.width, image.height)

        const url = canvas.toDataURL() // 得到图片的base64编码数据
        canvas.toDataURL('image/png')

        baseList.push(url.substring(22)) // 去掉base64编码前的 data:image/png;base64,
        if (baseList.length === arr.length && baseList.length > 0) {
          for (let k = 0; k < baseList.length; k++) {
            imgs.file(arr[k].name + '.png', baseList[k], { base64: true })
          }
          zip.generateAsync({ type: 'blob' }).then(function(content) {
            FileSaver.saveAs(content, name + '.zip')
          })
        }

      }
      image.src = item.url
    })
  },


  getPermissionBtn([id, pageId]) {
    const userPermission =
      JSON.parse(window.localStorage.getItem('permissionList')) || {}
    const menuList = JSON.parse(window.localStorage.getItem('menuList')) || {}
    if (
      (userPermission[pageId] &&
        userPermission[pageId].indexOf(id.toString()) >= 0) ||
      (!menuList[pageId] ||
        (menuList[pageId] && menuList[pageId].indexOf(id.toString()) === -1))
    ) {
      return false
    } else {
      return true
    }
  },



  alertMsg(text, type = 'warning') {
    Vue.prototype.$message({
      type: type,
      message: text
    })
  },

  /**
   * 判断参数
   * @params  参数
   * @return {String} 类型
   * @example String | Number | Boolean | Function | Array | Date | RegExp | Error | Symbol | Promise | Set
   */
  isParamsType(o) {
    // return Object.prototype.toString().call(o).slice(8, -1)
    return Object.prototype.toString.call(o).slice(8, -1)
  },
  /** 获取当前时间yyyy/mm/dd hh:mm:ss */
  getNowTime() {
    const date = new Date()
    return date.toLocaleString('chinese', { hour12: false })
  },
  changeToChinese(Num) {
    //判断如果传递进来的不是字符的话转换为字符
    if (typeof Num === 'number') {
      Num = new String(Num)
    }
    Num = Num.replace(/,/g, '') //替换tomoney()中的“,”
    Num = Num.replace(/ /g, '') //替换tomoney()中的空格
    Num = Num.replace(/￥/g, '') //替换掉可能出现的￥字符
    if (isNaN(Num)) { //验证输入的字符是否为数字
      //alert("请检查小写金额是否正确");
      return ''
    }
    //字符处理完毕后开始转换，采用前后两部分分别转换
    var part = String(Num).split('.')
    var newchar = ''
    //小数点前进行转化
    for (var i = part[0].length - 1; i >= 0; i--) {
      if (part[0].length > 10) {
        return ''
        //若数量超过拾亿单位，提示
      }
      var tmpnewchar = ''
      var perchar = part[0].charAt(i)
      switch (perchar) {
        case '0':
          tmpnewchar = '零' + tmpnewchar
          break
        case '1':
          tmpnewchar = '壹' + tmpnewchar
          break
        case '2':
          tmpnewchar = '贰' + tmpnewchar
          break
        case '3':
          tmpnewchar = '叁' + tmpnewchar
          break
        case '4':
          tmpnewchar = '肆' + tmpnewchar
          break
        case '5':
          tmpnewchar = '伍' + tmpnewchar
          break
        case '6':
          tmpnewchar = '陆' + tmpnewchar
          break
        case '7':
          tmpnewchar = '柒' + tmpnewchar
          break
        case '8':
          tmpnewchar = '捌' + tmpnewchar
          break
        case '9':
          tmpnewchar = '玖' + tmpnewchar
          break
      }
      switch (part[0].length - i - 1) {
        case 0:
          tmpnewchar = tmpnewchar + '元'
          break
        case 1:
          if (perchar != 0) tmpnewchar = tmpnewchar + '拾'
          break
        case 2:
          if (perchar != 0) tmpnewchar = tmpnewchar + '佰'
          break
        case 3:
          if (perchar != 0) tmpnewchar = tmpnewchar + '仟'
          break
        case 4:
          tmpnewchar = tmpnewchar + '万'
          break
        case 5:
          if (perchar != 0) tmpnewchar = tmpnewchar + '拾'
          break
        case 6:
          if (perchar != 0) tmpnewchar = tmpnewchar + '佰'
          break
        case 7:
          if (perchar != 0) tmpnewchar = tmpnewchar + '仟'
          break
        case 8:
          tmpnewchar = tmpnewchar + '亿'
          break
        case 9:
          tmpnewchar = tmpnewchar + '拾'
          break
      }
      var newchar = tmpnewchar + newchar
    }
    //小数点之后进行转化
    if (Num.indexOf('.') != -1) {
      if (part[1].length > 2) {
        // alert("小数点之后只能保留两位,系统将自动截断");
        part[1] = part[1].substr(0, 2)
      }
      for (i = 0; i < part[1].length; i++) {
        tmpnewchar = ''
        perchar = part[1].charAt(i)
        switch (perchar) {
          case '0':
            tmpnewchar = '零' + tmpnewchar
            break
          case '1':
            tmpnewchar = '壹' + tmpnewchar
            break
          case '2':
            tmpnewchar = '贰' + tmpnewchar
            break
          case '3':
            tmpnewchar = '叁' + tmpnewchar
            break
          case '4':
            tmpnewchar = '肆' + tmpnewchar
            break
          case '5':
            tmpnewchar = '伍' + tmpnewchar
            break
          case '6':
            tmpnewchar = '陆' + tmpnewchar
            break
          case '7':
            tmpnewchar = '柒' + tmpnewchar
            break
          case '8':
            tmpnewchar = '捌' + tmpnewchar
            break
          case '9':
            tmpnewchar = '玖' + tmpnewchar
            break
        }
        if (i == 0) tmpnewchar = tmpnewchar + '角'
        if (i == 1) tmpnewchar = tmpnewchar + '分'
        newchar = newchar + tmpnewchar
      }
    }
    //替换所有无用汉字
    while (newchar.search('零零') != -1)
      newchar = newchar.replace('零零', '零')
    newchar = newchar.replace('零亿', '亿')
    newchar = newchar.replace('亿万', '亿')
    newchar = newchar.replace('零万', '万')
    newchar = newchar.replace('零元', '元')
    newchar = newchar.replace('零角', '')
    newchar = newchar.replace('零分', '')
    if (newchar.charAt(newchar.length - 1) == '元') {
      newchar = newchar + '整'
    }
    return newchar
  },

  getLength(val) {
    let bytesCount = 0
    if (val && val.length > 0) {
      const str = new String(val)
      for (var i = 0, n = str.length; i < n; i++) {
        var c = str.charCodeAt(i)
        if ((c >= 0x0001 && c <= 0x007e) || (c >= 0xff60 && c <= 0xff9f)) {
          bytesCount += 1
        } else {
          bytesCount += 2
        }
      }
    }
    return bytesCount
  },

  reBytestr(str, len) {
    str = str.replace(/<\/?.+?>/g, '').replace(/ /g, '').replace(/&(\S*)?;/g, '')
    if ((!str && typeof (str) !== 'undefined')) {
      return ''
    }
    let num = 0
    const str1 = str
    str = ''
    for (let i = 0, lens = str1.length; i < lens; i++) {
      num += ((str1.charCodeAt(i) > 255) ? 2 : 1)
      if (num > len) {
        break
      } else {
        str = str1.substring(0, i + 1)
      }
    }
    if (num > len) {
      return str
    } else {
      return str
    }
  }


}

export default utils


