const lang = {
  state: {
    currentTab: '',
    tabs: [
      { title: '首页',
        name: '/admin/dashboard', modulePath: '/admin/dashboard' }
    ]
  },
  mutations: {
    setTabs(state, data) {
      if (typeof (data.length) === 'number') {
        state.tabs = data
      } else {
        state.tabs.push(data)

      }
    },
    setCurrentTab(state, path) {
      state.currentTab = path
    }
  },
  actions: {
    addTabs(context, data) {
      context.commit('setTabs', data)
    },
    setCurrentTab(context, path) {
      context.commit('setCurrentTab', path)
    }
  }
}

export default lang
