import { baseRoutes } from '../../router'
import { API } from '@lib/api'
import menu from '@components/menu/menu'
import Vue from 'vue'
const ENV = process.env.NODE_ENV

// const getRouteFromHref = () => {
//
// }

/**
 * route访问权限判断
 * route.show为true时，默认为可以访问，不与菜单树比较
 * @param  {Object}   route         单个路由对象
 * @param  {Array}    appMenuTree   菜单树
 * @param  {String}   parentPath    父级路由地址
 * @return {Boolean}                当前用户是否有权限访问该路由
 */
const hasPermission = (route, appMenuTree, parentPath) => {
  if (route.show === true) {
    return true
  }
  if (appMenuTree.some(app => {
    const path = !parentPath ? route.path : route.path ? parentPath + '/' + route.path : parentPath
    // const path = app.url.replace(/^(\S)*#/g,'')
    // if (path === getRouteFromHref(app.href)) {
    //     const meta = { title: app.name }
    //     route.meta = meta
    //     // route.name = app.name
    // }
    const url = app.url && app.url.replace(/^(\S)*#\//g, '')
    if (new RegExp('^' + path + '/').test(url) || new RegExp('^' + path + '$').test(url)) {
      const meta = { title: app.label, model: app.model }
      route.meta = { ...route.meta, ...meta }
      return true
    }

    if (app.children && hasPermission(route, app.children, parentPath)) {
      return true
    }
    return false
  })) {
    return true
  }
  return false
}

/**
 * router访问权限判断
 * @param  {Array}    routerList    路由数组
 * @param  {Array}    appMenuTree   菜单树
 * @param  {String}   parentPath    父级路由地址
 * @return {Array}                  当前用户可访问的路由数组
 */
const filterRouterList = (routerList, appMenuTree, parentPath) => {
  return routerList.filter(route => {
    if (route.children && route.children.length > 0) {
      route.children = filterRouterList(route.children, appMenuTree,
        !parentPath ? route.path : route.path ? parentPath + '/' + route.path : parentPath)
    }
    if (hasPermission(route, appMenuTree, parentPath)) {
      return true
    } else {
      return false
    }
  })
}

/**
 * 菜单数据格式化
 * @param  {Array}    list    菜单数
 * @return {Object}           当前用户可访问的路由数组
 */
const buttonsVOS = {}
// 兼容首页
let firstIframeUrl = ''
const recursive = (list) => {
  const menuData = list.map(item => {
    if (Array.isArray(item.children) && item.children.length > 0) {
      item.children = recursive(item.children)
    } else {
      item.children = []
    }
    buttonsVOS[item.id] = item.buttonVOS
      ? item.buttonVOS.map(item => {
        return item.url
      })
      : []

    const href = item.url
    let url = item.url
    // if (url) {
    //   url = item.url.split('#')[1]
    // }

    // if (url && flag === -1 && firstIframeUrl === '') {
    //   firstIframeUrl = url
    // }

    return {
      id: item.id.toString(),
      label: item.label,
      url: url,
      icon: item.icon,
      children: item.children,
      model: !item.model ? 0 : Number(item.model),
      href //新矿口打开href
    }
  })
  return menuData
}

let objMenu = {}
const menuRecuisive = (list) => {
  return list.map(item => {
    if (Array.isArray(item.children) && item.children.length > 0) {
      item.children = menuRecuisive(item.children)
    } else {
      item.children = []
    }
    objMenu[item.id] = item.buttonVOS
      ? item.buttonVOS.map(item => {
        return item.url
      })
      : []
    return {
      id: item.id.toString(),
      label: item.label,
      url: item.url,
      icon: item.icon,
      children: item.children,
      model: !item.model ? 0 : Number(item.model)
    }
  })
}

const permission = {
  state: {
    hasGotRouters: false,
    routers: [],
    addRouters: [],
    menuData: [],
    user: {},
    buttonsVOS: [],
    // firstIframeUrl: '',
    //所有权限
    menuList: []
  },
  mutations: {
    SET_ROUTERS: (state, routers) => {
      state.hasGotRouters = true
      state.addRouters = routers.accessedRouters
      state.routers = [].concat(routers.accessedRouters)
      state.menuData = routers.menuData
      state.user = routers.user
      Object.keys(buttonsVOS).forEach(item => {
        if (buttonsVOS[item].length === 0) {
          delete buttonsVOS[item]
        }
      })
      state.buttonsVOS = buttonsVOS
      // state.firstIframeUrl = firstIframeUrl
      window.localStorage.setItem('permissionList', JSON.stringify(buttonsVOS))
      // window.localStorage.setItem('menuList', JSON.stringify(buttonsVOS))
    },
    SET_MENU: (state, data) => {
      state.menuList = data
    }
  },
  actions: {
    GenerateRoutes({ commit, state }, router) {
      return new Promise(async(resolve, reject) => {
        const loading = Vue.prototype.$loading()
        try {

          const menuData = recursive(menu)
          const accessedRouters = filterRouterList(baseRoutes, menuData, '')
          accessedRouters.push({
            path: '*',
            redirect: 'errors/404'
          })
          commit('SET_ROUTERS', { menuData, accessedRouters, user: {}})


          // const { statusCode, body: { menuTreeVOS, authUserVO }} = await Vue.prototype.$request({
          //   url: API.getPresentUser,
          //   method: 'get'
          // })
          // if (statusCode === 2000) {
          //   if (['development', 'test'].includes(ENV) && menu.length > 0) {
          //     menuTreeVOS.push(...menu)
          //   }
          //   const menuData = recursive(menuTreeVOS)
          //
          //   const accessedRouters = filterRouterList(baseRoutes, menuData, '')
          //   accessedRouters.push({
          //     path: '*',
          //     redirect: 'errors/404'
          //   })
          //   commit('SET_ROUTERS', { menuData, accessedRouters, user: authUserVO })
          // }

          // const {status}
          // 兼容老项目获取所有的权限
          // const result = await Vue.prototype.$request({
          //   url: API.menus,
          //   method: 'post'
          // })
          //
          // if (result.statusCode === 2000) {
          //   objMenu = {}
          //   menuRecuisive(result.body)
          //   Object.keys(objMenu).forEach(item => {
          //     if (objMenu[item].length === 0) {
          //       delete objMenu[item]
          //     }
          //   })
          //   commit('SET_MENU', objMenu)
          //
          //   window.localStorage.setItem('menuList', JSON.stringify(objMenu))
          // }

        } finally {
          loading.close()
        }



        if (router) {
          router.addRoutes(state.addRouters)
        }

        resolve()
      })
    }
  }
}

export default permission
