export default {
  inserted: (el, binding, vnode) => {
    const { arg } = binding || {}
    const { hide } = arg
    if (hide) {
      return
    }
    const MAXLEN = 20
    let total = 0
    const elCols = el.getElementsByClassName('el-col')
    for (const item of elCols) {
      total += Number(item.className.split(' ')[1].split('-col-')[1])
    }
    //控件所占栅栏总数小于临界值，不需要折叠按钮
    if (MAXLEN > total) {
      return
    }
    const button_group = el.getElementsByClassName('button_group')[0]
    let right
    if (button_group) {
      right = button_group.getElementsByClassName('right')[0]
    }


    if ((!binding.arg || !binding.arg.btnBox) && (!button_group && !right)) {
      console.warn('未找到父节点')
      return
    }
    let dataToggle = el.getAttribute('data-toggle')
    const loopSetStyle = () => {
      let curLen = 0
      for (const element of elCols) {
        curLen += Number(element.className.split(' ')[1].split('-col-')[1])
        if (curLen > MAXLEN) {
          dataToggle
            ? (element.style.display = 'block')
            : (element.style.display = 'none')
        }
      }
    }
    loopSetStyle()

    //防重复创建按钮
    if (el.getElementsByClassName('toggle_btn').length) {
      return
    }
    // 创建按钮并绑定事件
    const btn = document.createElement('el-button')
    btn.className = 'el-button el-button--text el-button--medium toggle_btn'
    const i = document.createElement('i')
    i.style.marginLeft = 0

    const setBtn = () => {
      btn.innerHTML = ''
      let text = ''
      if (dataToggle) {
        i.className = 'el-icon-caret-top el-icon--right'
        text = document.createTextNode('收起')
      } else {
        i.className = 'el-icon-caret-bottom el-icon--right'
        text = document.createTextNode('展开')
      }
      btn.appendChild(text)
      btn.appendChild(i)
    }

    setBtn()

    if (binding.arg && binding.arg.btnBox) {
      if (el.getElementsByClassName(binding.arg.btnBox).length === 0) {
        console.warn('请检查父节点是否在filter-container内')
        return
      }
      el.getElementsByClassName(binding.arg.btnBox)[0].appendChild(btn)
    } else {
      if (right) {
        right.appendChild(btn)
      } else {
        button_group.appendChild(btn)
      }
    }

    btn.addEventListener('click', () => {
      if (dataToggle) {
        dataToggle = ''
      } else {
        dataToggle = 1
      }
      el.setAttribute('data-toggle', dataToggle)

      setBtn()
      loopSetStyle()
    })
  },
  update: (el, binding, vnode, oldVnode) => {
    console.log('update', binding)
    const MAXLEN = 20
    let total = 0
    const elCols = el.getElementsByClassName('el-col')
    for (const item of elCols) {
      total += Number(item.className.split(' ')[1].split('-col-')[1])
    }
    if (MAXLEN > total) {
      return
    }
    const button_group = el.getElementsByClassName('button_group')[0]
    let right
    if (button_group) {
      right = button_group.getElementsByClassName('right')[0]
    }
    if ((!binding.arg || !binding.arg.btnBox) && (!button_group && !right)) {
      console.warn('未找到父节点')
      return
    }
    const dataToggle = el.getAttribute('data-toggle')
    let curLen = 0
    for (const element of elCols) {
      curLen += Number(element.className.split(' ')[1].split('-col-')[1])
      if (curLen > MAXLEN) {
        dataToggle
          ? (element.style.display = 'block')
          : (element.style.display = 'none')
      }
    }
  }
}
