const webpack = require('webpack')
const InsertScriptPlugin = require('./scripts/InsertScriptWebpackPlugin')
const APP_NAME = require('./package.json').name
const PORT = require('./package.json').devPort
const path = require('path')
const WebpackAliyunOss = require('webpack-aliyun-oss')
const STATICDOMAIN = process.env.VUE_APP_STATICCDOMAIN || ''
const PROXY = require('./RPOXY')

//

const modules = [
  './web_admin/web_user/main.js',
  // './web_admin/web_all/main.js'
]

// const productionModules = [
//   ''
// ]
// log('PROXY', PROXY)

function resolve(dir) {
  return path.join(__dirname, './' + dir)
}

const NODE_ENV = process.env.NODE_ENV || 'development'

log('APP_NAME: ', APP_NAME)
log('NODE_ENV: ', NODE_ENV)
log('publicPath', `${NODE_ENV === 'development' ? './' : STATICDOMAIN + '/'}`)

module.exports = {
  // publicPath: './',
  publicPath: `${NODE_ENV === 'development' ? './' : STATICDOMAIN + '/'}`,

  productionSourceMap: false,

  configureWebpack: () => {
    const config = {}
    config.externals = {
      vue: 'Vue'
    }
    config.plugins = [
      new webpack.DefinePlugin({
        'process.env.VUE_APP_NAME': JSON.stringify(APP_NAME)
      }),
      new InsertScriptPlugin({ files: modules })
    ]
   // const webpackAliyunOss = [
   //    new WebpackAliyunOss({
   //      // from: './dist/**', // 上传那个文件或文件夹  可以是字符串或数组
   //      // dist: 'web_admin/', // 需要上传到oss上的给定文件目录
   //      // region: 'oss-cn-shenzhen',
   //      // bucket: 'ppy-prod-webadmin',
   //      // test: true,
   //      setOssPath: (filePath) => {
   //        // some operations to filePath
   //        const index = filePath.lastIndexOf('dist')
   //        const Path = filePath.substring(index + 4, filePath.length)
   //        return Path.replace(/\/g, '/')
   //      },
   //      setHeaders: (filePath) => {
   //        // some operations to filePath
   //        // return false to use default header
   //        return {
   //          'Cache-Control': 'max-age=31536000'
   //        }
   //      }
   //    })
   //  ] 

    if (NODE_ENV === 'production') {
      config.plugins = [ ...config.plugins]
    }
    return config
  },

  chainWebpack: (config) => {
    config.resolve.alias
      .set('@components', resolve('src/components'))
      .set('@lib', resolve('src/lib'))
      .set('@styles', resolve('src/styles'))
      .set('@assets', resolve('src/assets'))
      .set('@enum', resolve('src/enum'))

  },

  css: {
    // 是否使用css分离插件 ExtractTextPlugin
    extract: true,
    // 开启 CSS source maps?
    sourceMap: false,
    // css预设器配置项
    loaderOptions: {
      sass: {
        // @/ is an alias to src/
        // so this assumes you have a file named `src/variables.scss`
      }
    },
    // 启用 CSS modules for all css / pre-processor files.
    modules: false
  },
  devServer: {
    port: PORT,
    proxy: PROXY
  }
}

function log(label, content, options) {
  console.log('\x1b[1m%s\x1b[31m%s\x1b[0m', label, content)
}
