import Vue from 'vue'
import Router from 'vue-router'
import Layout from './components/layout'
import store from './store'

import NProgress from 'nprogress'
import 'nprogress/nprogress.css'

import otherRouter from './route'

NProgress.inc(1.0)
NProgress.configure({ easing: 'ease', speed: 500, showSpinner: false })

Vue.use(Router)

const commonRouter = [
  {
    path: '/errors',
    meta: {
      title: '报错'
    },
    component: Layout,
    children: [
      {
        path: '404',
        name: 'error-404',
        meta: {
          title: '404 报错页面'
        },
        component: () => import('./pages/errors/404')
      }
    ]
  },
  {
    path: '/login',
    meta: {
      title: '登录'
    },
    component: () => import('./pages/login/index.vue')
  }
]

const otherRoute = []

if (otherRouter.length > 0) {
  otherRoute.push(...otherRouter)
}

// 获取子项目的 route-list
const routes = Vue.__share_pool__ ? Vue.__share_pool__.routes : {}

const routesArray = Object.values(routes)

if (routesArray.length > 0) {
  const childRoutes = routesArray.reduce((acc, prev) => acc.concat(prev))
  otherRoute.push(...childRoutes)
}


const baseRoute = [
  {
    path: '/',
    component: Layout,
    redirect: { path: '/dashboard' },
    show: true,
    children: [
      {
        path: 'dashboard',
        name: '首页',
        show: true,
        meta: {
          title: '首页'
        },
        component: () => import('./pages/dashboard/index.vue')
      },
      ...otherRoute
    ]
  }
]


const options = {
  routes: [...commonRouter]
}

export const baseRoutes = baseRoute

const route = new Router(options)

route.beforeEach((to, from, next) => {
  if (to.path === '/') {
    route.push({ path: '/dashboard' })
    return
  }
  NProgress.start()
  const urls = ['/login']
  if (urls.includes(to.path)) {
    next()
  } else {
    if (!store.state.permission.hasGotRouters) {
      store.dispatch('GenerateRoutes', route).then((_) => {
        next({ ...to })
      })
    } else {
      next()
    }
  }
})

route.afterEach(() => {
  NProgress.done()
})


Vue.mixin({
})


export default route
