/**
 * list 模版 执行命令 npm run tep:list '文件名'
 */
const fs = require('fs')
const dirName = process.argv[2]
if (!dirName) {
  console.log('文件名不能为空')
}


const indexTemp = `
 <template>
   <div v-loading="loading" class="sweet-mainBox">
     <filter-container>
       <el-row :gutter="12">
        <el-form :model="params"
          label-position="right"
          label-width="6em">
          <el-col :span="4">
            <el-form-item label="战区名称">
              <el-input/>
            </el-form-item>
          </el-col>
           <div
            class="button_group"
          >
            <div class="right">
              <el-button
                type="primary"
                @click="searchData"
              >
                搜索
              </el-button>

              <el-button @click="reset">
                重置
              </el-button>

            </div>
          </div>
        </el-form>
       </el-row>
     </filter-container>
      <div class="handler">
        <button-os>添加</button-os>
      </div>
      <Tables
      :columns="columns"
      :data-source="data.source"
      :border="true"
      :total="data.total"
      :pagination-show="true"
      :current-page="params.pageNum"
      :page-size="params.pageSize"
      @handleSizeChange="handleSizeChange"
      @handleCurrentChange="handleCurrentChange"
        />
   </div>
 </template>
 <script>
export default {
   name: 'index',
    components: {},
    data() {
      return {
        data: {
            source: [],
            total: 0
        },
        loading: false,
        params: {},
        operationRow: {},
        dialogParams: {},
        columns: [],
      }
    },
    computed: {
        $Enum() {}
    },
    created() {
        this.initParams()
        this.searchData()
    },
    methods: {
        initParams() {
            this.params = {
                pageNum: 1,
                pageSize: 10,
            }
        },
        searchData(){
            this.params.pageNum = 1
            this.getList()
        },
        async getList() {
            try{
                this.loading = true
                const {...other} = this.params
                const data = {...other}
                const {statusCode, body} = await this.$request({
                    url: '',
                    method: 'get',
                    data
                })
                if(statusCode === 2000){
                    const {totalSize, pageData} = body
                    this.data.total = totalSize || 0
                    this.data.source = pageData || []
                }
            }finally{
                this.loading = false
            }
        },
        
        reset() {
            this.initParams()
            this.searchData()
        },
        
        handleSizeChange(data) {
            this.params.pageSize = data
            this.searchData()
        },
        handleCurrentChange(data) {
            this.params.pageNum = data
            this.getList()
        }
    }
  }
</script>  
<style scoped lang="scss">
</style>
`
fs.mkdirSync(`./src/pages/${dirName}`)
process.chdir(`./src/pages/${dirName}`)
fs.writeFileSync('index.vue', indexTemp)


process.exit(0)
