import axios from 'axios'
// import { API } from '@lib/api'
import router from '../router'
import qs from 'qs'
const ENV = process.env.NODE_ENV

const service = axios.create({
  baseURL: '', // api的base_url
  withCredentials: true, // 跨域需要使用的凭证
  timeout: 150000, // 请求超时时间
  changeOrigin: true,
  crossDomain: true
})

service.interceptors.request.use(
  (config) => {
    const sessionId = Vue.prototype.$cookies.get('sessionId')
    config.headers = {
      sessionId: sessionId || '',
      'Content-Type': config.headers['Content-Type'] || 'application/json',
      systemCode: 'yypp'
    }
    if (config.headers['Content-Type'] === 'application/x-www-form-urlencoded') {
      config.data = qs.stringify(config.data)
    }
    return config
  },
  (error) => {
    Promise.reject(error)
  }
)

service.interceptors.response.use(
  // 响应拦截器
  (res) => res,
  (error) => {
    Vue.prototype.$message({ type: 'error', message: '接口调用未知错误！' })
    return Promise.reject(error)
  }
)

const requestServer = (arg, resolve, reject) => {
  service(arg)
    .then((response) => {
      if (response) {
        if (!response.data.statusCode) {
          resolve(response)
        } else if (response.data.statusCode === 4001) {
          resolve()
          router.push({ path: '/login' })
        } else if (response.data.statusCode !== 2000) {
          console.log(this)
          let msg = response.data.msg
          if (!/[\u4E00-\u9FA5]/.test(msg)) {
            msg = '接口调用未知错误！'
          }
          Vue.prototype.$message({ type: 'error', message: msg })
          reject(msg)
        } else {
          resolve(response.data)
        }
      }
    })
    .catch((error) => {
      reject(error)
    })
}

const request = (arg, camouflageUrl) => {
  let url = arg.url
  const params = arg.data || {}
  const keys = Object.keys(params)
  if (new RegExp('\\{*}').test(url)) {
    for (const key of keys) {
      const reg = new RegExp('\\{' + key + '\\}', 'g')
      if (reg.test(url)) {
        const val = params[key]
        url = url.replace(new RegExp('\\{' + key + '\\}', 'g'), val)
        if (params) {
          delete params[key]
        }
      }
    }
    arg.url = url
  }

  if (arg.method === 'get') {
    arg.params = params
    delete arg.data
  } else {
    arg.data = params
  }



  return new Promise((resolve, reject) => {
    // if (ENV === 'development') {
    //   arg.url = '/domain' + arg.url
    // }
    arg.url = Vue.prototype.$domain + arg.url

    if (ENV === 'development' && camouflageUrl) {
      arg.url = camouflageUrl
    }

    requestServer(arg, resolve, reject)
  })
}

export default request
