import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store/index'
import request from '@lib/axios'
import Cookies from '@lib/cookies'
import Utils from '@lib/utils'
import FilterContainer from '@components/filter-container'
import Tables from '@components/table'
import OperationDialog from '@components/operationDialog'
import keepAlive from '@components/keepAlive'
import UploadExcel from '@components/uploadExcel'
import buttonOs from '@components/buttonOs'
import dropdownItem from '@components/dropdownItem'
import editTable from '@components/edit-table'
import editTableColumn from '@components/editable-column'
import formItemSelectLabel from '@components/form-item-select-label'
import customDialog from '@components/custom-dialog'
import importAndExport from '@components/importAndExport'
import * as directives from './directives/index'
import '@styles/normalize.scss'
import '@styles/plugins/element-theme-sweet.css'
import '@styles/plugins/theme-default.css'
import '@styles/plugins/cascader.css'
const ENV = process.env.NODE_ENV
let DOMAIN = process.env.VUE_APP_DOMAIN
const IMGDOMAIN = process.env.VUE_APP_IMG

Vue.config.productionTip = false

// 挂载主项目的 store 实例
;(Vue.__share_pool__ = Vue.__share_pool__ || {}).store = store

document.body.style.fontSize = '12px'

// window.ELEMENT = {size: 'medium'}
Vue.prototype.$ELEMENT = { size: 'medium' }
Vue.prototype.$request = request
Vue.prototype.$cookies = new Cookies()
Vue.prototype.$utils = Utils

Object.keys(directives).forEach((k) => {
  Vue.directive(k, directives[k])
})

Vue.component('FilterContainer', FilterContainer)
Vue.component('Tables', Tables)
Vue.component('OperationDialog', OperationDialog)
Vue.component('UploadExcel', UploadExcel)
Vue.component('buttonOs', buttonOs)
Vue.component('dropdownItemOs', dropdownItem)
Vue.component('sweetKeepAlive', keepAlive)
Vue.component('importAndExport', importAndExport)
Vue.component('formItemSelectLabel', formItemSelectLabel)
Vue.component('editTable', editTable)
Vue.component('editTableColumn', editTableColumn)
Vue.component('customDialog', customDialog)

if (!['production', 'beta'].includes(ENV)) {
  const domainPath = Vue.prototype.$cookies.get('domainPath')
  if (domainPath) {
    DOMAIN = JSON.parse(domainPath).path
  }
  // Vue.prototype.$cookies.get('')
}

Vue.prototype.$domain = DOMAIN
Vue.prototype.$imgDomain = IMGDOMAIN
Vue.prototype.$whiteOrigin = `https://h5.pinpianyi.${IMGDOMAIN === 'http://images.alpha.pinpianyi.cn/' ? 'cn' : 'com'}`
Vue.prototype.$appSetting = `https://h5.pinpianyi.${IMGDOMAIN === 'http://images.alpha.pinpianyi.cn/' ? 'cn' : 'com'}/h5custompage/index.html#/setting`

document.oncontextmenu = function() {
  if (ENV === 'development') {
    return true
  } else {
    return false
  }
}

new Vue({
  router,
  store,
  render: function(h) {
    return h(App)
  }
}).$mount('#app')
