export default class cookie {
  set(name, value, expires, path, domain) {
    var myWindow = window
    var cookieStr = myWindow.escape(name) + '=' + myWindow.escape(value) + ';'
    if (expires) {
      const dtExpires = new Date(
        new Date().getTime() + expires * 1000 * 60 * 60 * 24
      )
      cookieStr += 'expires=' + dtExpires.toUTCString() + ';'
    }
    if (path) {
      cookieStr += 'path=' + path + ';'
    }
    if (domain) {
      cookieStr += 'domain=' + domain + ';'
    }
    document.cookie = cookieStr
  }
  get(name) {
    name = window.escape(name)
    const regexp = new RegExp(
      '(?:^' + name + '|;\\s*' + name + ')=(.*?)(?:;|$)',
      'g'
    )
    const result = regexp.exec(document.cookie)
    return result === null ? null : window.unescape(result[1])
  }
  getAll() {
    const cookies = {}
    if (document.cookie && document.cookie !== '') {
      const split = document.cookie.split(';')
      for (let i = 0; i < split.length; i++) {
        const currCookie = split[i].split('=')
        currCookie[0] = currCookie[0].replace(/^ /, '')
        cookies[decodeURIComponent(currCookie[0])] = decodeURIComponent(
          currCookie[1]
        )
      }
    }
    return cookies
  }
  delete(name, path, domain) {
    if (this.get(name)) {
      this.set(name, '', -1, path, domain)
    }
  }
  deleteAll(path, domain) {
    const cookies = this.getAll()
    for (const cookieName in cookies) {
      this.delete(cookieName, path, domain)
    }
  }

}
