const oldIframe = {
  state: {
    iframeObj: {
      path: '',
      name: ''
    },
    tabIframes: []
  },
  mutations: {
    SETURL(state, obj) {
      const {
        tabIframes,
        iframeObj
      } = state
      switch (obj.type) {
        //加
        case '1':
          if (obj.url !== '' && tabIframes.findIndex(item => item.path === obj.url) === -1) {
            state.tabIframes = [...tabIframes, {
              path: obj.url,
              name: obj.label
            }]
          }
          break
          //减
        case '2':
          if (iframeObj.path !== '') {
            const newTabIframes = tabIframes.filter(item => item.path !== iframeObj.path)
            state.tabIframes = newTabIframes
          }
          break
          //切
        case '3':
          break
      }
      state.iframeObj = {
        path: obj.url,
        name: obj.label
      }
    }
  },
  actions: {
    SETIFRAME(context, obj) {
      context.commit('SETURL', obj)
    }
  }
}

export default oldIframe