/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.b.f;
import dm.jdbc.b.j;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.StringUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Arrays;

public class DriverUtil {
    public static int compareDmdbVersion(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n2 = 0;
        while (n2 < stringArray.length) {
            Integer n3 = Integer.valueOf(stringArray[n2]);
            Integer n4 = Integer.valueOf(stringArray2[n2]);
            if (n3 < n4) {
                return -1;
            }
            if (n3.intValue() != n4.intValue()) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    public static boolean isLocalHost(String string) {
        String string2;
        String string3;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(string) || "127.0.0.1".equals(string) || "::1".equals(string)) {
            return true;
        }
        try {
            string3 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string3 = string;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = null;
        }
        return string3.equalsIgnoreCase(string2);
    }

    public static String getHostMchName() {
        String string = "";
        try {
            InetAddress inetAddress = null;
            inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                string = inetAddress.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return string;
    }

    public static void executeWithNewConnection(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = null;
        try {
            dmdbConnection2 = DmDriver.fU.do_connect(dmdbConnection.fk);
            DriverUtil.execute(dmdbConnection2, string);
        }
        catch (Throwable throwable) {
            if (dmdbConnection2 != null) {
                try {
                    dmdbConnection2.do_close();
                }
                catch (SQLException sQLException) {}
            }
            throw throwable;
        }
        if (dmdbConnection2 != null) {
            try {
                dmdbConnection2.do_close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DmdbConnection dmdbConnection, String string, int n2) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbStatement dmdbStatement = null;
            try {
                dmdbStatement = dmdbConnection.do_createStatement();
                dmdbStatement.do_setQueryTimeout(n2);
                dmdbStatement.do_execute(string);
            }
            catch (Throwable throwable) {
                if (dmdbStatement != null) {
                    try {
                        dmdbStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbStatement != null) {
                try {
                    dmdbStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbStatement dmdbStatement = null;
            try {
                dmdbStatement = dmdbConnection.do_createStatement();
                dmdbStatement.do_execute(string);
            }
            catch (Throwable throwable) {
                if (dmdbStatement != null) {
                    try {
                        dmdbStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbStatement != null) {
                try {
                    dmdbStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePrepare(DmdbConnection dmdbConnection, String string, j[] jArray, boolean[] blArray) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbPreparedStatement dmdbPreparedStatement = null;
            try {
                dmdbPreparedStatement = dmdbConnection.do_prepareStatement(string);
                int n2 = 1;
                int n3 = 0;
                while (n3 < jArray.length) {
                    if (blArray[n3]) {
                        dmdbPreparedStatement.do_setObject(n2, jArray[n3].data);
                        ++n2;
                    }
                    ++n3;
                }
                dmdbPreparedStatement.do_executeUpdate();
            }
            catch (Throwable throwable) {
                if (dmdbPreparedStatement != null) {
                    try {
                        dmdbPreparedStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbPreparedStatement != null) {
                try {
                    dmdbPreparedStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePrepareCursorUpdate(DmdbConnection dmdbConnection, String string, j[] jArray, boolean[] blArray, long l2) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbPreparedStatement dmdbPreparedStatement = null;
            try {
                dmdbPreparedStatement = dmdbConnection.do_prepareStatement(string);
                dmdbPreparedStatement.kO = false;
                dmdbPreparedStatement.kI = l2;
                int n2 = 1;
                int n3 = 0;
                while (n3 < jArray.length) {
                    if (blArray[n3]) {
                        if (jArray[n3].eK == null && jArray[n3].eL == null) {
                            dmdbPreparedStatement.do_setObject(n2, jArray[n3].data);
                        } else if (jArray[n3].eK != null && jArray[n3].eL != null) {
                            dmdbPreparedStatement.do_setObject(n2, jArray[n3].data, (int)jArray[n3].eK, jArray[n3].eL);
                        } else if (jArray[n3].eK != null) {
                            dmdbPreparedStatement.do_setObject(n2, jArray[n3].data, jArray[n3].eK);
                        } else {
                            DBError.throwRuntimeException("ResultSetUpdataData must have jtype when use scaleOrLength !");
                        }
                        ++n2;
                    }
                    ++n3;
                }
                dmdbPreparedStatement.do_execute();
            }
            catch (Throwable throwable) {
                if (dmdbPreparedStatement != null) {
                    try {
                        dmdbPreparedStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbPreparedStatement != null) {
                try {
                    dmdbPreparedStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCursorUpdate(DmdbConnection dmdbConnection, String string, long l2) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbPreparedStatement dmdbPreparedStatement = null;
            try {
                dmdbPreparedStatement = dmdbConnection.do_prepareStatement(string);
                dmdbPreparedStatement.kI = l2;
                dmdbPreparedStatement.kO = false;
                dmdbPreparedStatement.do_execute();
            }
            catch (Throwable throwable) {
                if (dmdbPreparedStatement != null) {
                    try {
                        dmdbPreparedStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbPreparedStatement != null) {
                try {
                    dmdbPreparedStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] executePrepareCall(DmdbConnection dmdbConnection, String string, Object[] objectArray, Integer[] integerArray) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbCallableStatement dmdbCallableStatement = dmdbConnection.do_prepareCall(string);
            Object[] objectArray2 = new Object[objectArray.length];
            try {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] != null) {
                        dmdbCallableStatement.do_setObject(n2 + 1, objectArray[n2]);
                    }
                    if (integerArray[n2] != null) {
                        dmdbCallableStatement.do_registerOutParameter(n2 + 1, (int)integerArray[n2]);
                    }
                    ++n2;
                }
                dmdbCallableStatement.do_execute();
                n2 = 0;
                while (n2 < integerArray.length) {
                    if (integerArray[n2] != null) {
                        objectArray2[n2] = dmdbCallableStatement.do_getObject(n2 + 1);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                if (dmdbCallableStatement != null) {
                    try {
                        dmdbCallableStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbCallableStatement != null) {
                try {
                    dmdbCallableStatement.do_close();
                }
                catch (Exception exception) {}
            }
            return objectArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DmdbResultSet executeQuery(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbStatement dmdbStatement = dmdbConnection.do_createStatement(1004, 1007, 1);
            dmdbStatement.do_closeOnCompletion();
            return dmdbStatement.do_executeQuery(string);
        }
    }

    public static String executeAndGetExplain(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            String string2;
            block11: {
                DmdbStatement dmdbStatement = null;
                try {
                    dmdbStatement = dmdbConnection.do_createStatement();
                    dmdbStatement.do_execute(string);
                    string2 = dmdbStatement.jg.et;
                    if (dmdbStatement == null) break block11;
                }
                catch (Throwable throwable) {
                    if (dmdbStatement != null) {
                        try {
                            dmdbStatement.do_close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    dmdbStatement.do_close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
    }

    public static boolean checkDbAlive(String string, int n2) {
        boolean bl;
        block14: {
            bl = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
                    socket.connect(inetSocketAddress, 5000);
                    bl = true;
                }
                catch (Exception exception) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        f f2 = new f();
        f2.setProperty("host", "localhost");
        f2.setProperty("port", "5236");
        f2.setProperty("user", "SYSDBA");
        f2.setProperty("password", "SYSDBA");
        DmdbConnection dmdbConnection = new DmdbConnection(f2);
        Object[] objectArray = new Object[2];
        objectArray[1] = "MYCLS";
        Integer[] integerArray = new Integer[2];
        integerArray[0] = 2004;
        Object[] objectArray2 = DriverUtil.executePrepareCall(dmdbConnection, "BEGIN ? = SF_DESCRIBE_TYPE(?); END;", objectArray, integerArray);
        System.out.println(Arrays.toString(objectArray2));
    }
}

