/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteArray;
import dm.jdbc.util.StringEncoder;
import dm.jdbc.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class ByteUtil {
    public static final StringEncoder GB18030_ENCODER = new StringEncoder("GB18030");
    public static final StringEncoder UTF8_ENCODER = new StringEncoder("UTF-8");
    public static final StringEncoder EUCKR_ENCODER = new StringEncoder("EUC-KR");

    public static int setByte(byte[] byArray, int n2, byte by) {
        byArray[n2] = by;
        return 1;
    }

    public static int setShort(byte[] byArray, int n2, short s2) {
        byArray[n2++] = (byte)s2;
        byArray[n2++] = (byte)(s2 >> 8);
        return 2;
    }

    public static int setInt(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)(n3 >> 16);
        byArray[n2++] = (byte)(n3 >> 24);
        return 4;
    }

    public static int setLong(byte[] byArray, int n2, long l2) {
        byArray[n2++] = (byte)l2;
        byArray[n2++] = (byte)(l2 >> 8);
        byArray[n2++] = (byte)(l2 >> 16);
        byArray[n2++] = (byte)(l2 >> 24);
        byArray[n2++] = (byte)(l2 >> 32);
        byArray[n2++] = (byte)(l2 >> 40);
        byArray[n2++] = (byte)(l2 >> 48);
        byArray[n2++] = (byte)(l2 >> 56);
        return 8;
    }

    public static int setFloat(byte[] byArray, int n2, float f2) {
        return ByteUtil.setInt(byArray, n2, Float.floatToIntBits(f2));
    }

    public static int setDouble(byte[] byArray, int n2, double d2) {
        return ByteUtil.setLong(byArray, n2, Double.doubleToLongBits(d2));
    }

    public static int setUB1(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
        return 1;
    }

    public static int setUB2(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        return 2;
    }

    public static int setUB3(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)(n3 >> 16);
        return 3;
    }

    public static int setUB4(byte[] byArray, int n2, long l2) {
        byArray[n2++] = (byte)l2;
        byArray[n2++] = (byte)(l2 >> 8);
        byArray[n2++] = (byte)(l2 >> 16);
        byArray[n2++] = (byte)(l2 >> 24);
        return 4;
    }

    public static int setBytes(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public static int setBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        System.arraycopy(byArray2, n3, byArray, n2, n4);
        return n4;
    }

    public static byte getByte(byte[] byArray, int n2) {
        return byArray[n2];
    }

    public static short getShort(byte[] byArray, int n2) {
        short s2 = (short)(byArray[n2++] & 0xFF);
        s2 = (short)(s2 | (short)(byArray[n2++] & 0xFF) << 8);
        return s2;
    }

    public static int getInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        n3 |= (byArray[n2++] & 0xFF) << 16;
        return n3 |= (byArray[n2++] & 0xFF) << 24;
    }

    public static long getLong(byte[] byArray, int n2) {
        long l2 = byArray[n2++] & 0xFF;
        l2 |= (long)(byArray[n2++] & 0xFF) << 8;
        l2 |= (long)(byArray[n2++] & 0xFF) << 16;
        l2 |= (long)(byArray[n2++] & 0xFF) << 24;
        l2 |= (long)(byArray[n2++] & 0xFF) << 32;
        l2 |= (long)(byArray[n2++] & 0xFF) << 40;
        l2 |= (long)(byArray[n2++] & 0xFF) << 48;
        return l2 |= (long)(byArray[n2++] & 0xFF) << 56;
    }

    public static float getFloat(byte[] byArray, int n2) {
        int n3 = ByteUtil.getInt(byArray, n2);
        return Float.intBitsToFloat(n3);
    }

    public static double getDouble(byte[] byArray, int n2) {
        long l2 = ByteUtil.getLong(byArray, n2);
        return Double.longBitsToDouble(l2);
    }

    public static int getUB1(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    public static int getUB2(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        return n3 |= (byArray[n2++] & 0xFF) << 8;
    }

    public static int getUB3(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        return n3 |= (byArray[n2++] & 0xFF) << 16;
    }

    public static long getUB4(byte[] byArray, int n2) {
        long l2 = byArray[n2++] & 0xFF;
        l2 |= (long)(byArray[n2++] & 0xFF) << 8;
        l2 |= (long)(byArray[n2++] & 0xFF) << 16;
        return l2 |= (long)(byArray[n2++] & 0xFF) << 24;
    }

    public static byte[] getBytesWithLength(byte[] byArray, int n2) {
        int n3 = ByteUtil.getInt(byArray, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 + 4, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] getBytesWithLength2(byte[] byArray, int n2) {
        int n3 = ByteUtil.getUB2(byArray, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 + 2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] getBytes(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] getBytes(String string, String string2) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DBError.throwRuntimeException("String encode fail!", unsupportedEncodingException);
            return new byte[0];
        }
    }

    public static String getString(byte[] byArray, String string) {
        return ByteUtil.getString(byArray, 0, byArray != null ? byArray.length : 0, string);
    }

    public static String getString(byte[] byArray, int n2, int n3, String string) {
        String string2 = null;
        try {
            string2 = new String(byArray, n2, n3, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DBError.throwRuntimeException("string decode fail", unsupportedEncodingException);
        }
        return string2;
    }

    public static String getStringWithLength(byte[] byArray, int n2, String string) {
        int n3 = ByteUtil.getInt(byArray, n2);
        return ByteUtil.getString(byArray, n2 += 4, n3, string);
    }

    public static String getStringWithLength2(byte[] byArray, int n2, String string) {
        int n3 = ByteUtil.getUB2(byArray, n2);
        return ByteUtil.getString(byArray, n2 += 2, n3, string);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        int n2 = -1;
        int n3 = byArray2.length - byArray.length;
        if (n3 < 0) {
            return n2;
        }
        int n4 = 0;
        while (n4 <= n3) {
            int n5 = 0;
            while (n5 < byArray.length) {
                int n6 = byArray[n5] & 0xFF;
                int n7 = byArray2[n4 + n5] & 0xFF;
                if (n6 != n7) break;
                ++n5;
            }
            if (n5 == byArray.length) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        return n2;
    }

    public static int checkCompleteCharLen(ByteArray byteArray, int n2, int n3, String string) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n3) {
            n5 = ByteUtil.calcCharLen(byteArray, n6, string);
            if (n5 <= 0 || n4 + n5 > n3) break;
            n4 += n5;
            n6 += n5;
        }
        return n4;
    }

    public static int checkCompleteCharLen(byte[] byArray, int n2, int n3, String string) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n3) {
            n5 = ByteUtil.calcCharLen(byArray, n2, string);
            if (n5 <= 0 || n4 + n5 > n3) break;
            n4 += n5;
            n6 += n5;
        }
        return n4;
    }

    private static int calcCharLen(byte[] byArray, int n2, String string) {
        byte by;
        block20: {
            block18: {
                int n3;
                block19: {
                    try {
                        by = byArray[n2];
                        if (!StringUtil.equalsIgnoreCase(string, "GB18030")) break block18;
                        n3 = by & 0xFF;
                        if (n3 > 128) break block19;
                        return 1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                byte by2 = byArray[n2 + 1];
                n3 = by2 & 0xFF;
                if (n3 >= 64 && n3 <= 254 && n3 != 127) {
                    return 2;
                }
                return 4;
            }
            if (!StringUtil.equalsIgnoreCase(string, "EUC-KR")) break block20;
            int n4 = by & 0xFF;
            if (n4 <= 128) {
                return 1;
            }
            return 2;
        }
        int n5 = 1;
        if ((by & 0x80) == 0) {
            n5 = 1;
        } else if ((by & 0xE0) == 192) {
            n5 = 2;
        } else if ((by & 0xF0) == 224) {
            n5 = 3;
        } else if ((by & 0xF8) == 240) {
            n5 = 4;
        } else if ((by & 0xFC) == 248) {
            n5 = 5;
        } else if ((by & 0xFE) == 252) {
            n5 = 6;
        }
        return n5;
    }

    private static int calcCharLen(ByteArray byteArray, int n2, String string) {
        byte by;
        block20: {
            block18: {
                int n3;
                block19: {
                    try {
                        by = byteArray.getByte(n2);
                        if (!StringUtil.equalsIgnoreCase(string, "GB18030")) break block18;
                        n3 = by & 0xFF;
                        if (n3 > 128) break block19;
                        return 1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                byte by2 = byteArray.getByte(n2 + 1);
                n3 = by2 & 0xFF;
                if (n3 >= 64 && n3 <= 254 && n3 != 127) {
                    return 2;
                }
                return 4;
            }
            if (!StringUtil.equalsIgnoreCase(string, "EUC-KR")) break block20;
            int n4 = by & 0xFF;
            if (n4 <= 128) {
                return 1;
            }
            return 2;
        }
        int n5 = 1;
        if ((by & 0x80) == 0) {
            n5 = 1;
        } else if ((by & 0xE0) == 192) {
            n5 = 2;
        } else if ((by & 0xF0) == 224) {
            n5 = 3;
        } else if ((by & 0xF8) == 240) {
            n5 = 4;
        } else if ((by & 0xFC) == 248) {
            n5 = 5;
        } else if ((by & 0xFE) == 252) {
            n5 = 6;
        }
        return n5;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[8];
        ByteUtil.setLong(byArray, 0, -128L);
        System.out.println(ByteUtil.getLong(byArray, 0));
        ByteUtil.setUB4(byArray, 0, 0xFFFFFFFFL);
        System.out.println(ByteUtil.getUB4(byArray, 0));
    }
}

