/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.ByteArray;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;

public abstract class BaseFlusher
extends BaseThread {
    protected String date = new Date(System.currentTimeMillis()).toString();
    protected File logFile = null;
    protected FileOutputStream out;
    protected String filePrefix;
    protected int flushFreq;
    protected String filePath;
    public static final int MAX_FILE_SIZE = 0x6400000;
    public static final int FLUSH_SIZE = 32768;
    protected ByteArray buffer = new ByteArray();

    public BaseFlusher(String string, String string2, String string3, int n2) {
        super(string);
        this.filePath = string2;
        this.filePrefix = string3;
        this.flushFreq = n2;
    }

    protected abstract void doRun();

    @Override
    protected abstract void beforeExit();

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable throwable) {
            try {
                this.beforeExit();
            }
            catch (Throwable throwable2) {}
            this.closeCurrentFile();
            throw throwable;
        }
        try {
            this.beforeExit();
        }
        catch (Throwable throwable) {}
        this.closeCurrentFile();
    }

    protected void doFlush(ByteArray byteArray) {
        if (this.out == null || this.needCreateNewFile()) {
            this.closeCurrentFile();
            this.out = this.createNewFile();
        }
        try {
            byteArray.writeBytes(this.out, byteArray.length());
        }
        catch (IOException iOException) {}
    }

    protected FileOutputStream createNewFile() {
        try {
            this.date = new Date(System.currentTimeMillis()).toString();
            String string = String.valueOf(this.filePrefix) + "_" + this.date + "_" + System.currentTimeMillis() + ".log";
            if (StringUtil.isNotEmpty(this.filePath) && StringUtil.isNotEmpty(string)) {
                File file = new File(this.filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.logFile = new File(String.valueOf(this.filePath) + string);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    protected void closeCurrentFile() {
        if (this.out != null) {
            try {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
            finally {
                this.out = null;
            }
        }
    }

    private boolean needCreateNewFile() {
        String string = new Date(System.currentTimeMillis()).toString();
        return !string.equals(this.date) || this.logFile == null || this.logFile.length() > 0x6400000L;
    }
}

