/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.parser;

import dm.jdbc.a.b;
import dm.jdbc.parser.LVal;
import dm.jdbc.parser.LVal$Type;
import dm.jdbc.parser.Lexer;
import dm.jdbc.parser.SQLProcessor$Parameter;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class SQLProcessor {
    public static List lex(String string) {
        Lexer lexer = new Lexer(new StringReader(string), false);
        int n2 = 0;
        LVal lVal = null;
        ArrayList<LVal> arrayList = new ArrayList<LVal>(32);
        while ((lVal = lexer.yylex()) != null) {
            lVal.position = n2++;
            arrayList.add(lVal);
        }
        return arrayList;
    }

    public static String escape(String string, String[] stringArray) {
        CharSequence charSequence;
        HashMap hashMap = null;
        if (stringArray != null && stringArray.length > 0) {
            hashMap = new HashMap();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                charSequence = stringArray2[n3];
                hashMap.put(((String)charSequence).toUpperCase(), null);
                ++n3;
            }
        }
        charSequence = new StringBuilder();
        Stack<Boolean> stack = new Stack<Boolean>();
        List list = SQLProcessor.lex(string);
        int n4 = 0;
        while (n4 < list.size()) {
            LVal lVal = (LVal)list.get(n4);
            if (lVal.type == LVal$Type.NORMAL) {
                if (StringUtil.equals(lVal.value, "{")) {
                    LVal lVal2;
                    LVal lVal3 = SQLProcessor.next(list, n4 + 1);
                    if (lVal3 == null || lVal3.type != LVal$Type.NORMAL) {
                        stack.push(false);
                        ((StringBuilder)charSequence).append(lVal.value);
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "escape") || StringUtil.equalsIgnoreCase(lVal3.value, "call")) {
                        stack.push(true);
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "oj")) {
                        stack.push(true);
                        lVal3.value = "";
                        lVal3.type = LVal$Type.WHITESPACE_OR_COMMENT;
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "d")) {
                        stack.push(true);
                        lVal3.value = "date";
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "t")) {
                        stack.push(true);
                        lVal3.value = "time";
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "ts")) {
                        stack.push(true);
                        lVal3.value = "datetime";
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "fn")) {
                        stack.push(true);
                        lVal3.value = "";
                        lVal3.type = LVal$Type.WHITESPACE_OR_COMMENT;
                        lVal2 = SQLProcessor.next(list, lVal3.position + 1);
                        if (lVal2 != null && lVal2.type == LVal$Type.NORMAL && StringUtil.equalsIgnoreCase(lVal2.value, "database")) {
                            lVal2.value = "cur_database";
                        }
                    } else if (StringUtil.equals(lVal3.value, "?")) {
                        lVal2 = SQLProcessor.next(list, lVal3.position + 1);
                        if (lVal2 != null && lVal2.type == LVal$Type.NORMAL && StringUtil.equalsIgnoreCase(lVal2.value, "=")) {
                            LVal lVal4 = SQLProcessor.next(list, lVal2.position + 1);
                            if (lVal4 != null && lVal4.type == LVal$Type.NORMAL && StringUtil.equalsIgnoreCase(lVal4.value, "call")) {
                                stack.push(true);
                                lVal4.value = "";
                                lVal4.type = LVal$Type.WHITESPACE_OR_COMMENT;
                            } else {
                                stack.push(false);
                                ((StringBuilder)charSequence).append(lVal.value);
                            }
                        } else {
                            stack.push(false);
                            ((StringBuilder)charSequence).append(lVal.value);
                        }
                    } else {
                        stack.push(false);
                        ((StringBuilder)charSequence).append(lVal.value);
                    }
                } else if (StringUtil.equals(lVal.value, "}")) {
                    if (stack.isEmpty() || !((Boolean)stack.pop()).booleanValue()) {
                        ((StringBuilder)charSequence).append(lVal.value);
                    }
                } else if (hashMap != null && hashMap.containsKey(lVal.value.toUpperCase())) {
                    ((StringBuilder)charSequence).append("\"" + StringUtil.processDoubleQuoteOfName(lVal.value.toUpperCase()) + "\"");
                } else {
                    ((StringBuilder)charSequence).append(lVal.value);
                }
            } else if (lVal.type == LVal$Type.STRING) {
                ((StringBuilder)charSequence).append("'" + StringUtil.processSingleQuoteOfName(lVal.value) + '\'');
            } else {
                ((StringBuilder)charSequence).append(lVal.value);
            }
            ++n4;
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static LVal next(List list, int n2) {
        LVal lVal = null;
        int n3 = list.size();
        int n4 = n2;
        while (n4 < n3) {
            lVal = (LVal)list.get(n4);
            if (lVal.type != LVal$Type.WHITESPACE_OR_COMMENT) break;
            ++n4;
        }
        return lVal;
    }

    public static String execOpt(String string, List list, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        List list2 = SQLProcessor.lex(string);
        int n2 = 0;
        int n3 = 0;
        while (n3 < list2.size()) {
            LVal lVal = (LVal)list2.get(n3);
            switch (lVal.type) {
                case NULL: {
                    stringBuilder.append("?");
                    list.add(new SQLProcessor$Parameter(null, 25, 0));
                    break;
                }
                case INT: {
                    stringBuilder.append("?");
                    Number number = new Long(lVal.value);
                    if ((Long)number <= Integer.MAX_VALUE && (Long)number >= Integer.MIN_VALUE) {
                        list.add(new SQLProcessor$Parameter(b.d((Long)number), 7, 4));
                        break;
                    }
                    list.add(new SQLProcessor$Parameter(b.e((Long)number), 8, 8));
                    break;
                }
                case DOUBLE: {
                    stringBuilder.append("?");
                    Number number = new Double(lVal.value);
                    list.add(new SQLProcessor$Parameter(b.a((Double)number), 11, 8));
                    break;
                }
                case DECIMAL: {
                    stringBuilder.append("?");
                    list.add(new SQLProcessor$Parameter(b.a(lVal.value, 0, 0), 9, 0));
                    break;
                }
                case STRING: {
                    if (lVal.value.length() > Short.MAX_VALUE) {
                        stringBuilder.append("'" + StringUtil.processSingleQuoteOfName(lVal.value) + "'");
                        break;
                    }
                    stringBuilder.append("?");
                    list.add(new SQLProcessor$Parameter(ByteUtil.getBytes(lVal.value, string2), 2, 8188));
                    break;
                }
                case HEX_INT: {
                    stringBuilder.append(lVal.value);
                    break;
                }
                default: {
                    stringBuilder.append(lVal.value);
                }
            }
            if (n2 > 0) break;
            ++n3;
        }
        if (n2 > 0) {
            n3 = n2 + 1;
            while (n3 < list2.size()) {
                stringBuilder.append(((LVal)list2.get((int)n3)).value);
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "insert into TYYW_GG_XYRJBXX (BMSAH, TYSAH, XYRBH, SFSC, CBDW_BM, CBDW_MC, FQDWBM, FQL, CJSJ, ZHXGSJ, SFZF, XM, CYM, CH, XB_DM, XB_MC, ZASNL, CSRQ, CSD_DM, CSD_MC, ZJLX_DM, ZJLX_MC, ZJHM, MZ_DM, MZ_MC, GJ_DM, GJ_MC, HJSZD_DM, HJSZD_MC, ZSD_DM, ZSD_MC, ZSDXXDZ, GZDWSZD_DM, GZDWSZD_MC, GZDW, SF_DM, SF_MC, SJYZK_DM, SJYZK_MC, ZZMM_DM, ZZMM_MC, RDDB_DM, RDDB_MC, ZXWY_DM, ZXWY_MC, ZW, ZJ_DM, ZJ_MC, ZY_DM, ZY_MC, SFDRSZ, SFDWLD, SFNCJCZZRY, WCNFZXYRDJHRQK_DM, WCNFZXYRDJHRQK_MC, FDDLR, SZXXMC, DQQZCSBH, SFZT, JYKSRQ, JYDQRQ, JYYJZT, JYTS, NL, SFDWZFLD, SFWLJYSRDDB, SFWLJYSZXWY, SFCJZZRY, SFCJR, QTGZSF_DM, QTGZSF_MC, SFWDW)values( ?, '37000020190000300', '3700002019000001', 'N', '370000', '\u5c71\u4e1c\u7701\u9662', 3700, '2019','2019-02-15 08:25:42', '2019-02-15 08:25:43', 'N', '\u5f20\u4e09', null, null, '9909180000001', '\u7537\u6027', 32, '1987-09-09', null, null, '9910180300001', '\u5c45\u6c11\u8eab\u4efd\u8bc1', '222222198709091111', '9912180100001', '\u6c49\u65cf', '9911180200001', '\u4e2d\u56fd', '9913000220000', '\u5409\u6797\u7701', '9913000310000', '\u4e0a\u6d77\u5e02', '\u4e0a\u6d77\u5e02\u95f5\u884c\u533a\u91d1\u4e61\u5c0f\u533a40\u680b17\u53f7', '9913000210000', '\u8fbd\u5b81\u7701', '\u4e0a\u6d77\u5e02\u95f5\u884c\u533a\u91d1\u4e61\u5c0f\u533a40\u680b17\u53f7', '9916192603000', '\u5b66\u751f', '9915180600007', '\u9ad8\u804c', '9917180500001', '\u7fa4\u4f17', '9918181500005', '\u7701\u7ea7', '9919181400003', '\u5730\u5e02', null, '9914180800008', '\u53bf\u5904\u7ea7\u6b63\u804c', '9947199700008', '\u5316\u5de5\u4ea7\u54c1\u751f\u4ea7\u4eba\u5458', 'N', 'N', 'N', '9920182400004', '\u7236\u6bcd\u9057\u5f03', null, null, null, null, null, null, null, null, null, 'N', 'N', 'N', 'N', 'N', '9970010000500', '\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784', null)";
        long l2 = System.currentTimeMillis();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < 1000) {
            arrayList.clear();
            SQLProcessor.execOpt(string, arrayList, "GB18030");
            ++n2;
        }
        System.out.println("time: " + (System.currentTimeMillis() - l2) + "ms");
    }
}

