/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.b.g;
import dm.jdbc.filter.stat.StatFlusher$StatFlusherThreadHolder;
import dm.jdbc.filter.stat.StatReader;
import dm.jdbc.processor.BaseFlusher;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;

public class StatFlusher
extends BaseFlusher {
    private static StatReader statReader = new StatReader();
    private static int READ_MAX_SIZE = 100;
    private ArrayList logList;

    private StatFlusher() {
        super("StatFlusher", g.dX, "dm_jdbc_stat", g.dY);
        this.start();
    }

    public static StatFlusher getInstance() {
        return StatFlusher$StatFlusherThreadHolder.access$0();
    }

    public static boolean isConnStatEnabled() {
        return g.dW;
    }

    public static boolean isSlowSqlStatEnabled() {
        return g.dW;
    }

    public static boolean isHighFreqSqlStatEnabled() {
        return g.dW;
    }

    @Override
    protected void doRun() {
        while (this.flushFreq > 0) {
            this.doStat();
            try {
                Thread.sleep(this.flushFreq * 1000);
            }
            catch (Exception exception) {}
        }
    }

    protected void doStat() {
        boolean bl;
        if (this.logList == null) {
            this.logList = new ArrayList(16);
        }
        this.logList.add(StringUtil.formatTime("******************************************************* ", " *******************************************************"));
        if (StatFlusher.isConnStatEnabled()) {
            this.logList.add("#connection stat");
            bl = true;
            while (bl) {
                bl = statReader.readConnStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        if (StatFlusher.isHighFreqSqlStatEnabled()) {
            this.logList.add("#top " + g.ea + " high freq sql stat");
            bl = true;
            while (bl) {
                bl = statReader.readHighFreqSqlStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        if (StatFlusher.isSlowSqlStatEnabled()) {
            this.logList.add("#top " + g.dZ + " slow sql stat");
            bl = true;
            while (bl) {
                bl = statReader.readSlowSqlStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        this.logList.add(StringUtil.LINE_SEPARATOR);
        this.logList.add(StringUtil.LINE_SEPARATOR);
        this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
        this.logList.clear();
    }

    @Override
    protected void beforeExit() {
        this.doStat();
    }

    protected void writeAndFlush(String[] stringArray, int n2, int n3) {
        if (this.out != null) {
            byte[] byArray = null;
            int n4 = n2;
            while (n4 < n2 + n3) {
                byArray = (String.valueOf(stringArray[n4]) + StringUtil.LINE_SEPARATOR).getBytes();
                this.buffer.putBytes(byArray, 0, byArray.length);
                if (this.buffer.length() >= 32768) {
                    this.doFlush(this.buffer);
                }
                ++n4;
            }
            if (this.buffer.length() > 0) {
                this.doFlush(this.buffer);
            }
        }
    }

    /* synthetic */ StatFlusher(StatFlusher statFlusher) {
        this();
    }
}

