/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class DmdbIntervalDT
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3402150044485419841L;
    public static final int LOADPREC_DEFAULT = 2;
    public static final int LOADPREC_MAX = 9;
    public static final int SECDPREC_DEFAULT = 6;
    public static final int SECDPREC_MAX = 6;
    public static final byte QUA_D = 3;
    public static final byte QUA_DH = 4;
    public static final byte QUA_DHM = 5;
    public static final byte QUA_DHMS = 6;
    public static final byte QUA_H = 7;
    public static final byte QUA_HM = 8;
    public static final byte QUA_HMS = 9;
    public static final byte QUA_M = 10;
    public static final byte QUA_MS = 11;
    public static final byte QUA_S = 12;
    public byte type = (byte)3;
    private int hB = 2;
    private int hC = 6;
    private boolean hD = false;
    public int hE = 0;
    public int hF = 0;
    public int hG = 0;
    public int hH = 0;
    public int hI = 0;
    private int hJ = 0;

    public DmdbIntervalDT(byte[] byArray) {
        this.reset(byArray);
    }

    public DmdbIntervalDT(String string) {
        this.parseIntervDTString(string);
    }

    public Object clone() {
        DmdbIntervalDT dmdbIntervalDT = null;
        try {
            dmdbIntervalDT = (DmdbIntervalDT)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return dmdbIntervalDT;
    }

    public int hashCode() {
        return this.getDTString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DmdbIntervalDT) {
            DmdbIntervalDT dmdbIntervalDT = (DmdbIntervalDT)object;
            if (dmdbIntervalDT.type == this.type) {
                switch (this.type) {
                    case 3: {
                        if (this.hE != dmdbIntervalDT.hE) break;
                        return true;
                    }
                    case 4: {
                        if (this.hE != dmdbIntervalDT.hE || this.hF != dmdbIntervalDT.hF) break;
                        return true;
                    }
                    case 5: {
                        if (this.hE != dmdbIntervalDT.hE || this.hF != dmdbIntervalDT.hF || this.hG != dmdbIntervalDT.hG) break;
                        return true;
                    }
                    case 6: {
                        if (this.hE != dmdbIntervalDT.hE || this.hF != dmdbIntervalDT.hF || this.hG != dmdbIntervalDT.hG || this.hH != dmdbIntervalDT.hH) break;
                        return true;
                    }
                    case 7: {
                        if (this.hF != dmdbIntervalDT.hF) break;
                        return true;
                    }
                    case 8: {
                        if (this.hF != dmdbIntervalDT.hF || this.hG != dmdbIntervalDT.hG) break;
                        return true;
                    }
                    case 9: {
                        if (this.hF != dmdbIntervalDT.hF || this.hG != dmdbIntervalDT.hG || this.hH != dmdbIntervalDT.hH) break;
                        return true;
                    }
                    case 10: {
                        if (this.hG != dmdbIntervalDT.hG) break;
                        return true;
                    }
                    case 11: {
                        if (this.hG != dmdbIntervalDT.hG || this.hH != dmdbIntervalDT.hH) break;
                        return true;
                    }
                    case 12: {
                        if (this.hH != dmdbIntervalDT.hH) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getPrecForSvr() {
        return this.hJ;
    }

    public void reset(byte[] byArray) {
        this.type = byArray[21];
        this.hJ = ByteUtil.getInt(byArray, 20);
        this.hB = this.hJ >> 4 & 0xF;
        this.hC = this.hJ & 0xF;
        switch (this.type) {
            case 3: {
                this.hE = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 4: {
                this.hE = ByteUtil.getInt(byArray, 0);
                this.hF = ByteUtil.getInt(byArray, 4);
                break;
            }
            case 5: {
                this.hE = ByteUtil.getInt(byArray, 0);
                this.hF = ByteUtil.getInt(byArray, 4);
                this.hG = ByteUtil.getInt(byArray, 8);
                break;
            }
            case 6: {
                this.hE = ByteUtil.getInt(byArray, 0);
                this.hF = ByteUtil.getInt(byArray, 4);
                this.hG = ByteUtil.getInt(byArray, 8);
                this.hH = ByteUtil.getInt(byArray, 12);
                this.hI = ByteUtil.getInt(byArray, 16);
                break;
            }
            case 7: {
                this.hF = ByteUtil.getInt(byArray, 4);
                break;
            }
            case 8: {
                this.hF = ByteUtil.getInt(byArray, 4);
                this.hG = ByteUtil.getInt(byArray, 8);
                break;
            }
            case 9: {
                this.hF = ByteUtil.getInt(byArray, 4);
                this.hG = ByteUtil.getInt(byArray, 8);
                this.hH = ByteUtil.getInt(byArray, 12);
                this.hI = ByteUtil.getInt(byArray, 16);
                break;
            }
            case 10: {
                this.hG = ByteUtil.getInt(byArray, 8);
                break;
            }
            case 11: {
                this.hG = ByteUtil.getInt(byArray, 8);
                this.hH = ByteUtil.getInt(byArray, 12);
                this.hI = ByteUtil.getInt(byArray, 16);
                break;
            }
            case 12: {
                this.hH = ByteUtil.getInt(byArray, 12);
                this.hI = ByteUtil.getInt(byArray, 16);
            }
        }
    }

    private void setDay(String string) {
        this.type = (byte)3;
        int n2 = Integer.parseInt(string);
        this.hE = this.hD ? -n2 : n2;
    }

    private void setHour(String string) {
        this.type = (byte)7;
        int n2 = Integer.parseInt(string);
        this.hF = this.hD ? -n2 : n2;
    }

    private void setMinute(String string) {
        this.type = (byte)10;
        int n2 = Integer.parseInt(string);
        this.hG = this.hD ? -n2 : n2;
    }

    private void setSecond(String string) {
        this.type = (byte)12;
        String[] stringArray = StringUtil.split(string, ".");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = 0;
        if (stringArray.length > 1) {
            String string2 = "0." + stringArray[1];
            double d2 = Double.valueOf(string2);
            int n4 = (int)Math.pow(10.0, this.hC);
            n3 = (int)(d2 * (double)n4);
        }
        this.hH = this.hD ? -n2 : n2;
        this.hI = this.hD ? -n3 : n3;
    }

    private void setHourToSecond(String string) {
        this.type = (byte)9;
        String[] stringArray = StringUtil.split(string, ":.");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        int n5 = 0;
        if (stringArray.length > 3) {
            String string2 = "0." + stringArray[3];
            double d2 = Double.valueOf(string2);
            int n6 = (int)Math.pow(10.0, this.hC);
            n5 = (int)(d2 * (double)n6);
        }
        this.hF = this.hD ? -n2 : n2;
        this.hG = this.hD ? -n3 : n3;
        this.hH = this.hD ? -n4 : n4;
        this.hI = this.hD ? -n5 : n5;
    }

    private void setHourToMinute(String string) {
        this.type = (byte)8;
        string = string.trim();
        String[] stringArray = StringUtil.split(string, ":");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        this.hF = this.hD ? -n2 : n2;
        this.hG = this.hD ? -n3 : n3;
    }

    private void setMinuteToSecond(String string) {
        this.type = (byte)11;
        String[] stringArray = StringUtil.split(string, ":.");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = 0;
        if (stringArray.length > 2) {
            String string2 = "0." + stringArray[2];
            double d2 = Double.valueOf(string2);
            int n5 = (int)Math.pow(10.0, this.hC);
            n4 = (int)(d2 * (double)n5);
        }
        this.hG = this.hD ? -n2 : n2;
        this.hH = this.hD ? -n3 : n3;
        this.hI = this.hD ? -n4 : n4;
    }

    private void setDayToHour(String string) {
        this.type = (byte)4;
        String[] stringArray = StringUtil.split(string, " ");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        this.hE = this.hD ? -n2 : n2;
        this.hF = this.hD ? -n3 : n3;
    }

    private void setDayToMinute(String string) {
        this.type = (byte)5;
        String[] stringArray = StringUtil.split(string, ": ");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        this.hE = this.hD ? -n2 : n2;
        this.hF = this.hD ? -n3 : n3;
        this.hG = this.hD ? -n4 : n4;
    }

    private void setDayToSecond(String string) {
        this.type = (byte)6;
        String[] stringArray = StringUtil.split(string, ": .");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        int n5 = Integer.parseInt(stringArray[3]);
        int n6 = 0;
        if (stringArray.length > 4) {
            String string2 = "0." + stringArray[4];
            double d2 = Double.valueOf(string2);
            int n7 = (int)Math.pow(10.0, this.hC);
            n6 = (int)(d2 * (double)n7);
        }
        this.hE = this.hD ? -n2 : n2;
        this.hF = this.hD ? -n3 : n3;
        this.hG = this.hD ? -n4 : n4;
        this.hH = this.hD ? -n5 : n5;
        this.hI = this.hD ? -n6 : n6;
    }

    public final int getDay() {
        return this.hE;
    }

    public final int getHour() {
        return this.hF;
    }

    public final int getMinute() {
        return this.hG;
    }

    public final int getSecond() {
        return this.hH;
    }

    public final int getMsec() {
        return this.hI;
    }

    public final byte getDTType() {
        return this.type;
    }

    public final int getSecPrec() {
        return this.hC;
    }

    public final int getLeadScale() {
        return this.hB;
    }

    public final String getDTString() {
        String string = "INTERVAL ";
        switch (this.type) {
            case 3: {
                String string2 = String.valueOf(Math.abs(this.hE));
                if (this.hE < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string2.length() < this.hB) {
                    int n2 = string2.length();
                    int n3 = this.hB;
                    while (n3-- > n2) {
                        string2 = "0" + string2;
                    }
                }
                string = String.valueOf(string) + "'" + string2 + "' DAY(" + this.hB + ")";
                break;
            }
            case 4: {
                String string3 = String.valueOf(Math.abs(this.hE));
                String string4 = String.valueOf(Math.abs(this.hF));
                if (this.hE < 0 || this.hF < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string3.length() < this.hB) {
                    int n4 = string3.length();
                    int n5 = this.hB;
                    while (n5-- > n4) {
                        string3 = "0" + string3;
                    }
                }
                if (string4.length() < 2) {
                    string4 = "0" + string4;
                }
                string = String.valueOf(string) + "'" + string3 + " " + string4 + "' DAY(" + this.hB + ") TO HOUR";
                break;
            }
            case 5: {
                String string5 = String.valueOf(Math.abs(this.hE));
                String string6 = String.valueOf(Math.abs(this.hF));
                String string7 = String.valueOf(Math.abs(this.hG));
                if (this.hE < 0 || this.hG < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string5.length() < this.hB) {
                    int n6 = string5.length();
                    int n7 = this.hB;
                    while (n7-- > n6) {
                        string5 = "0" + string5;
                    }
                }
                if (string6.length() < 2) {
                    string6 = "0" + string6;
                }
                if (string7.length() < 2) {
                    string7 = "0" + string7;
                }
                string = String.valueOf(string) + "'" + string5 + " " + string6 + ":" + string7 + "' DAY(" + this.hB + ") TO MINUTE";
                break;
            }
            case 6: {
                String string8 = String.valueOf(Math.abs(this.hE));
                String string9 = String.valueOf(Math.abs(this.hF));
                String string10 = String.valueOf(Math.abs(this.hG));
                String string11 = String.valueOf(Math.abs(this.hH));
                String string12 = this.getMsecString();
                if (this.hE < 0 || this.hF < 0 || this.hG < 0 || this.hH < 0 || this.hI < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string8.length() < this.hB) {
                    int n8 = string8.length();
                    int n9 = this.hB;
                    while (n9-- > n8) {
                        string8 = "0" + string8;
                    }
                }
                if (string9.length() < 2) {
                    string9 = "0" + string9;
                }
                if (string10.length() < 2) {
                    string10 = "0" + string10;
                }
                if (string11.length() < 2) {
                    string11 = "0" + string11;
                }
                string = String.valueOf(string) + "'" + string8 + " " + string9 + ":" + string10 + ":" + string11 + (StringUtil.isNotEmpty(string12) ? "." + string12 : "") + "' DAY(" + this.hB + ") TO SECOND(" + this.hC + ")";
                break;
            }
            case 7: {
                String string13 = String.valueOf(Math.abs(this.hF));
                if (this.hF < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string13.length() < this.hB) {
                    int n10 = string13.length();
                    int n11 = this.hB;
                    while (n11-- > n10) {
                        string13 = "0" + string13;
                    }
                }
                string = String.valueOf(string) + "'" + string13 + "' HOUR(" + this.hB + ")";
                break;
            }
            case 8: {
                String string14 = String.valueOf(Math.abs(this.hF));
                String string15 = String.valueOf(Math.abs(this.hG));
                if (this.hF < 0 || this.hG < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string14.length() < this.hB) {
                    int n12 = string14.length();
                    int n13 = this.hB;
                    while (n13-- > n12) {
                        string14 = "0" + string14;
                    }
                }
                if (string15.length() < 2) {
                    string15 = "0" + string15;
                }
                string = String.valueOf(string) + "'" + string14 + ":" + string15 + "' HOUR(" + this.hB + ") TO MINUTE";
                break;
            }
            case 9: {
                String string16 = this.getMsecString();
                String string17 = String.valueOf(Math.abs(this.hF));
                String string18 = String.valueOf(Math.abs(this.hG));
                String string19 = String.valueOf(Math.abs(this.hH));
                if (this.hF < 0 || this.hG < 0 || this.hH < 0 || this.hI < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string17.length() < this.hB) {
                    int n14 = string17.length();
                    int n15 = this.hB;
                    while (n15-- > n14) {
                        string17 = "0" + string17;
                    }
                }
                if (string18.length() < 2) {
                    string18 = "0" + string18;
                }
                if (string19.length() < 2) {
                    string19 = "0" + string19;
                }
                string = String.valueOf(string) + "'" + string17 + ":" + string18 + ":" + string19 + (StringUtil.isNotEmpty(string16) ? "." + string16 : "") + "' HOUR(" + this.hB + ") TO SECOND(" + this.hC + ")";
                break;
            }
            case 10: {
                String string20 = String.valueOf(Math.abs(this.hG));
                if (this.hG < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string20.length() < this.hB) {
                    int n16 = string20.length();
                    int n17 = this.hB;
                    while (n17-- > n16) {
                        string20 = "0" + string20;
                    }
                }
                string = String.valueOf(string) + "'" + string20 + "' MINUTE(" + this.hB + ")";
                break;
            }
            case 11: {
                String string21 = this.getMsecString();
                String string22 = String.valueOf(Math.abs(this.hG));
                String string23 = String.valueOf(Math.abs(this.hH));
                if (this.hG < 0 || this.hH < 0 || this.hI < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string22.length() < this.hB) {
                    int n18 = string22.length();
                    int n19 = this.hB;
                    while (n19-- > n18) {
                        string22 = "0" + string22;
                    }
                }
                if (string23.length() < 2) {
                    string23 = "0" + string23;
                }
                string = String.valueOf(string) + "'" + string22 + ":" + string23 + (StringUtil.isNotEmpty(string21) ? "." + string21 : "") + "' MINUTE(" + this.hB + ") TO SECOND(" + this.hC + ")";
                break;
            }
            case 12: {
                String string24 = this.getMsecString();
                String string25 = String.valueOf(Math.abs(this.hH));
                if (this.hH < 0 || this.hI < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (string25.length() < this.hB) {
                    int n20 = string25.length();
                    int n21 = this.hB;
                    while (n21-- > n20) {
                        string25 = "0" + string25;
                    }
                }
                string = String.valueOf(string) + "'" + string25 + (StringUtil.isNotEmpty(string24) ? "." + string24 : "") + "' SECOND(" + this.hB + ", " + this.hC + ")";
            }
        }
        return string;
    }

    private String getMsecString() {
        String string = "" + Math.abs(this.hI);
        int n2 = 6 - string.length();
        while (n2 > 0) {
            string = "0" + string;
            --n2;
        }
        if (string.length() > this.hC) {
            string = string.substring(0, this.hC);
        }
        return string;
    }

    public final String toString() {
        return this.getDTString();
    }

    public byte[] convertStrToBs(int n2) {
        if (n2 == 0) {
            n2 = this.hJ;
        }
        int n3 = n2 >> 4 & 0xF;
        this.checkScale(n3);
        byte[] byArray = new byte[24];
        ByteUtil.setInt(byArray, 0, this.hE);
        ByteUtil.setInt(byArray, 4, this.hF);
        ByteUtil.setInt(byArray, 8, this.hG);
        ByteUtil.setInt(byArray, 12, this.hH);
        ByteUtil.setInt(byArray, 16, this.hI);
        ByteUtil.setInt(byArray, 20, n2);
        return byArray;
    }

    public void clear() {
        this.hE = 0;
        this.hF = 0;
        this.hG = 0;
        this.hH = 0;
        this.hI = 0;
    }

    private int parsePrec(String string) {
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        int n4 = -1;
        if (n3 != -1 && n2 != -1 && n3 > n2 + 1) {
            String string2 = string.substring(n2 + 1, n3).trim();
            n4 = Integer.parseInt(string2);
        }
        return n4;
    }

    private int checkScale(int n2) {
        switch (this.type) {
            case 3: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hE)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.hE)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 4: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hE)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hE)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                if (Math.abs(this.hF) <= 23) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 5: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hE)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hE)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                if (Math.abs(this.hF) <= 23 && Math.abs(this.hG) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 6: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hE)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hE)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                if (Math.abs(this.hF) <= 23 && Math.abs(this.hG) <= 59 && Math.abs(this.hH) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 7: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hF)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.hF)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 8: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hF)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hF)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                if (Math.abs(this.hG) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 9: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hF)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hF)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                if (Math.abs(this.hG) <= 59 && Math.abs(this.hH) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 10: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hG)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.hG)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 11: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hG)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hG)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                if (Math.abs(this.hH) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 12: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hH)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.hH)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
            }
        }
        if (n2 > 9) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        return n2;
    }

    private void setPrecForSvr(String string, String string2, String string3) {
        int n2 = this.checkScale(this.parsePrec(string2));
        this.hB = n2 < 2 ? 2 : n2;
        n2 = this.parsePrec(string3);
        this.hC = n2 > 0 && n2 < 6 ? n2 : 6;
        this.hJ = (this.type << 8) + (this.hB << 4) + this.hC;
    }

    private String checkSign(String string) {
        if (string.charAt(0) == '-') {
            string = string.substring(1).trim();
            this.hD = true;
        } else if (string.charAt(0) == '+') {
            string = string.substring(1).trim();
            this.hD = false;
        }
        return string;
    }

    private void parseIntervDTString(String string) {
        String string2;
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        if (!(string2 = string.toUpperCase().trim()).startsWith("INTERVAL ")) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        try {
            string2 = string2.substring(string2.indexOf(" ")).trim();
            int n2 = 0;
            String string3 = null;
            if (string2.charAt(0) == '\'' && (n2 = string2.indexOf("'", 1)) != -1) {
                string3 = string2.substring(1, n2).trim();
                string3 = this.checkSign(string3);
                string2 = string2.substring(n2 + 1).trim();
            }
            if (string3 == null) {
                if ((string2 = this.checkSign(string2)).charAt(0) != '\'' || (n2 = string2.indexOf("'", 1)) == -1) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                }
                string3 = string2.substring(1, n2).trim();
                string2 = string2.substring(n2 + 1).trim();
            }
            String string4 = "";
            String string5 = "";
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            n3 = string2.indexOf("DAY");
            if (n3 != -1) {
                n5 = string2.indexOf("TO", n3);
                if (n5 == -1) {
                    string4 = string2.substring(n3).trim();
                    this.setDay(string3);
                } else {
                    string4 = string2.substring(n3, n5).trim();
                    if (string2.indexOf("HOUR", n5) != -1) {
                        this.setDayToHour(string3);
                    } else if (string2.indexOf("MINUTE", n5) != -1) {
                        this.setDayToMinute(string3);
                    } else {
                        n4 = string2.indexOf("SECOND", n5);
                        if (n4 != -1) {
                            string5 = string2.substring(n4);
                            this.setDayToSecond(string3);
                        } else {
                            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                        }
                    }
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
            n3 = string2.indexOf("HOUR");
            if (n3 != -1) {
                n5 = string2.indexOf("TO", n3);
                if (n5 == -1) {
                    string4 = string2.substring(n3);
                    this.setHour(string3);
                } else {
                    string4 = string2.substring(n3, n5);
                    if (string2.indexOf("MINUTE", n5) != -1) {
                        this.setHourToMinute(string3);
                    } else {
                        n4 = string2.indexOf("SECOND", n5);
                        if (n4 != -1) {
                            string5 = string2.substring(n4);
                            this.setHourToSecond(string3);
                        } else {
                            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                        }
                    }
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
            n3 = string2.indexOf("MINUTE");
            if (n3 != -1) {
                n5 = string2.indexOf("TO", n3);
                if (n5 == -1) {
                    string4 = string2.substring(n3);
                    this.setMinute(string3);
                } else {
                    string4 = string2.substring(n3, n5);
                    n4 = string2.indexOf("SECOND", n5);
                    if (n4 != -1) {
                        string5 = string2.substring(n4);
                        this.setMinuteToSecond(string3);
                    } else {
                        DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                    }
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
            n3 = string2.indexOf("SECOND");
            if (n3 != -1) {
                this.setSecond(string3);
                string2 = string2.substring(n3).trim();
                int n6 = string2.indexOf(",");
                if (n6 != -1) {
                    string4 = String.valueOf(string2.substring(0, n6).trim()) + ")";
                    string5 = "(" + string2.substring(n6 + 1).trim();
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(exception);
        }
        DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
    }

    public static void main(String[] stringArray) {
        DmdbIntervalDT dmdbIntervalDT = new DmdbIntervalDT("interval -'122222' second(2, 4)");
        System.out.println(dmdbIntervalDT);
    }
}

