/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.InputStream;
import java.sql.SQLException;

public class DmdbInputStream
extends InputStream {
    public static final int IS_BLOB = 0;
    public static final int IS_CLOB = 1;
    public static final int IS_STRING = 2;
    public static final int IS_BYTE = 3;
    public static final int IS_FILE_TYPE = 4;
    public Object o = null;
    private int hv;
    private byte[] hw;
    private int hx;
    public int hy = 0;
    public boolean hz = false;
    private long hA = -1L;

    public DmdbInputStream(Object object) {
        this.o = object;
        this.hy = 0;
        if (object instanceof DmdbBlob) {
            this.hv = 0;
            this.hA = ((DmdbBlob)object).do_length();
        } else if (object instanceof DmdbClob) {
            this.hv = 1;
            this.hA = ((DmdbClob)object).do_length();
        } else if (object instanceof byte[]) {
            this.hv = 3;
            this.hA = ((byte[])object).length;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    protected DmdbInputStream(DmdbBlob dmdbBlob, long l2, long l3) {
        this(dmdbBlob);
        this.hy = (int)(l2 - 1L);
        this.hA = dmdbBlob.do_length();
        this.hA = this.hA > l3 ? l3 : this.hA;
        this.hz = this.hy > 0 || this.hA < dmdbBlob.do_length();
    }

    public Object useRealObject(long l2) {
        if (!(this.hy != 0 || this.hz || -1L != l2 && l2 < this.hA)) {
            return this.o;
        }
        return this;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        switch (this.hv) {
            case 0: {
                return this.readFromBlob(byArray, n2, n3);
            }
            case 1: {
                return this.readFromClob(byArray, n2, n3);
            }
            case 3: {
                return this.readFromByteArray(byArray, n2, n3);
            }
        }
        DBError.throwIOException("io read error,invalid data type of this stream.");
        return 0;
    }

    @Override
    public int available() {
        if (this.hA != -1L) {
            return (int)(this.hA - (long)this.hy);
        }
        return 0;
    }

    private int readFromBlob(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        DmdbBlob dmdbBlob;
        block3: {
            dmdbBlob = (DmdbBlob)this.o;
            n5 = this.available();
            n4 = 0;
            if (n5 != 0) break block3;
            return -1;
        }
        try {
            n4 = n5 > n3 ? n3 : n5;
            byte[] byArray2 = dmdbBlob.do_getBytes(this.hy + 1, n4);
            n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n2, n4);
            this.hy += n4;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readFromClob(byte[] byArray, int n2, int n3) {
        DmdbClob dmdbClob = (DmdbClob)this.o;
        int n4 = 0;
        int n5 = 0;
        try {
            if (this.available() == 0 && this.getBufLeaveLen() == 0) {
                return -1;
            }
            while (n4 < n3) {
                if (this.available() <= 0 && this.getBufLeaveLen() <= 0) {
                    return n4;
                }
                if (this.getBufLeaveLen() == 0) {
                    this.fillBuffer(dmdbClob, this.available() < n3 - n4 ? this.available() : n3 - n4);
                }
                if (this.getBufLeaveLen() <= 0) continue;
                n5 = this.readFromBuffer(byArray, n2, n3 - n4);
                n4 += n5;
                n2 += n5;
            }
            return n4;
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int getBufLeaveLen() {
        return this.hw == null ? 0 : this.hw.length - this.hx;
    }

    private void fillBuffer(DmdbClob dmdbClob, int n2) {
        n2 = n2 < 16000 ? 16000 : n2;
        this.hw = dmdbClob.getBytes(this.hy + 1, n2);
        this.hx = 0;
        this.hy += n2;
    }

    private int readFromBuffer(byte[] byArray, int n2, int n3) {
        int n4 = this.getBufLeaveLen();
        n3 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.hw, this.hx, byArray, n2, n3);
        this.hx += n3;
        return n3;
    }

    private int readFromByteArray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = (byte[])this.o;
        int n4 = this.available();
        int n5 = 0;
        if (n4 == 0) {
            return -1;
        }
        n5 = n4 > n3 ? n3 : n4;
        System.arraycopy(byArray2, this.hy, byArray, n2, n5);
        this.hy += n5;
        return n5;
    }
}

