/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.c;
import dm.jdbc.b.e;
import dm.jdbc.b.f;
import dm.jdbc.b.g;
import dm.jdbc.b.m;
import dm.jdbc.b.o;
import dm.jdbc.c.a;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection$1;
import dm.jdbc.driver.DmdbConnection$2;
import dm.jdbc.driver.DmdbConnection$3;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.filter.Filterable;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.processor.DBAliveCheckThread;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.QueueCache;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class DmdbConnection
extends Filterable
implements Connection {
    public boolean gn = false;
    private String gm = "GB18030";
    public short go = 0;
    public int gp;
    public int gq;
    public boolean gr;
    public int gs = -1;
    public boolean gt;
    public int gu;
    public int gv;
    public boolean gw = false;
    public String gx;
    public String gy;
    public String gz;
    public String gA;
    public String gB;
    public int gC;
    public int gD;
    public int gE;
    public String gF;
    public boolean gG = true;
    public int gH = 0;
    public String gI = null;
    public int gJ = 0;
    public int gK;
    public String gL;
    public int gM;
    public int gN;
    public int gO = 0;
    public boolean gP = true;
    public boolean gQ = false;
    public boolean gR = false;
    public int gS = g.getLanguage();
    public String gT;
    public String gU;
    public String gV;
    public String gW;
    public String gX;
    public long gY = -1L;
    public int connection_property_compress = 0;
    public byte connection_property_compressID = 0;
    public String connection_property_charCode;
    public boolean connection_property_enRsCache = false;
    public int connection_property_rsCacheSize = 20;
    public int connection_property_rsRefreshFreq = 10;
    public int connection_property_loginMode = 0;
    public int connection_property_switchTimes = 3;
    public int connection_property_switchInterval = 200;
    public String[] connection_property_keyWords = null;
    public boolean connection_property_loginEncrypt = true;
    public String connection_property_loginCertificate = null;
    public boolean connection_property_dec2Double = false;
    public boolean connection_property_rwHA = false;
    public boolean connection_property_rwSeparate = false;
    public int connection_property_rwPercent = 25;
    public boolean connection_property_rwAutoDistribute = true;
    public int connection_property_rwStandbyRecoverTime = 0;
    public boolean connection_property_doSwitch = false;
    public String connection_property_cipherPath = null;
    public boolean connection_property_loadBalance = false;
    public int connection_property_loadBalancePercent = 10;
    public String connection_property_url;
    public String connection_property_user;
    public String connection_property_password;
    public String connection_property_host = "localhost";
    public int connection_property_port = 5236;
    public String connection_property_appName = "";
    public String connection_property_osName = System.getProperty("os.name", "");
    public boolean connection_property_mppLocal = false;
    public int connection_property_socketTimeout = 0;
    public int connection_property_connectTimeout = 5000;
    public int connection_property_sessionTimeout = 0;
    public byte connection_property_osAuthType = 0;
    public boolean connection_property_continueBatchOnError = false;
    public boolean connection_property_escapeProcess = false;
    public boolean connection_property_autoCommit = true;
    public int connection_property_maxRows = 0;
    public int connection_property_rowPrefetch = 10;
    public int connection_property_bufPrefetch = 0;
    public int connection_property_lobMode = 1;
    public int connection_property_stmtPoolMaxSize = 15;
    public boolean connection_property_ignoreCase = true;
    public boolean connection_property_alwayseAllowCommit = true;
    public int connection_property_batchType = 1;
    public int connection_property_resultSetType = 1003;
    public boolean connection_property_dbmdChkPrv = false;
    public boolean connection_property_isBdtaRS = false;
    public boolean connection_property_callBatchNot = false;
    public String connection_property_sslFilesPath = "";
    public String connection_property_sslKeystorePass = "";
    public String connection_property_kerberosLoginConfPath = "";
    public String connection_property_uKeyName = "";
    public String connection_property_uKeyPin = "";
    public String connection_property_databaseProductName = "";
    public boolean connection_property_columnNameUpperCase = false;
    public boolean connection_property_caseSensitive = true;
    public boolean connection_property_clobAsString = false;
    public int connection_property_compatibleMode = 0;
    public short connection_property_localTimezone = e.bd;
    public int gZ = 0;
    private Object ha = new Object();
    public boolean L = false;
    public f fk;
    public String hb;
    public a hc;
    public boolean closed = false;
    public boolean readOnly = false;
    public int hd = 1;
    public SQLWarning he;
    public Map hf;
    public QueueCache hg;
    public ArrayList hh = new ArrayList();
    private static final SQLPermission hi = new SQLPermission("abort");
    private static final SQLPermission hj = new SQLPermission("setNetworkTimeout");

    public void setAttributes(f f2) {
        if (f2 == null || f2.size() == 0) {
            return;
        }
        this.connection_property_url = f2.getString("url", this.connection_property_url);
        this.connection_property_host = f2.getString("host", this.connection_property_host);
        this.connection_property_port = f2.a("port", this.connection_property_port, (Integer)null, (Integer)null);
        this.connection_property_user = f2.getString("user", this.connection_property_user);
        this.connection_property_password = f2.getString("password", this.connection_property_password);
        this.gn = f2.getBoolean("rwStandby", this.gn);
        this.connection_property_compress = f2.getBoolean("isCompress", false) ? 2 : this.connection_property_compress;
        this.connection_property_compress = f2.a("compress", this.connection_property_compress, 0, 2);
        this.connection_property_compressID = (byte)f2.a("compressID", this.connection_property_compressID, -1, 1);
        this.connection_property_charCode = f2.getString("charCode", this.connection_property_charCode);
        this.connection_property_enRsCache = f2.getBoolean("enRsCache", this.connection_property_enRsCache);
        this.connection_property_localTimezone = (short)f2.a("localTimezone", this.connection_property_localTimezone, -720, 720);
        this.connection_property_rsCacheSize = f2.a("rsCacheSize", this.connection_property_rsCacheSize, 0, null);
        this.connection_property_rsRefreshFreq = f2.a("rsRefreshFreq", this.connection_property_rsRefreshFreq, 0, null);
        this.connection_property_loginMode = f2.a("loginMode", this.connection_property_loginMode, 0, 4);
        this.connection_property_switchTimes = f2.a("switchTimes", this.connection_property_switchTimes, 0, null);
        this.connection_property_switchInterval = f2.a("switchInterval", this.connection_property_switchInterval, 0, null);
        this.connection_property_loginEncrypt = f2.getBoolean("loginEncrypt", this.connection_property_loginEncrypt);
        this.connection_property_loginCertificate = f2.getString("loginCertificate", this.connection_property_loginCertificate);
        this.connection_property_dec2Double = f2.getBoolean("dec2Double", this.connection_property_dec2Double);
        this.connection_property_rwSeparate = f2.getBoolean("rwSeparate", this.connection_property_rwSeparate);
        this.connection_property_rwAutoDistribute = f2.getBoolean("rwAutoDistribute", this.connection_property_rwAutoDistribute);
        this.connection_property_rwPercent = f2.a("rwPercent", this.connection_property_rwPercent, 0, 100);
        this.connection_property_rwHA = f2.getBoolean("rwHA", this.connection_property_rwHA);
        this.connection_property_rwStandbyRecoverTime = f2.a("rwStandbyRecoverTime", this.connection_property_rwStandbyRecoverTime, 0, null);
        this.connection_property_doSwitch = f2.getBoolean("doSwitch", this.connection_property_doSwitch);
        this.connection_property_cipherPath = f2.getString("cipherPath", this.connection_property_cipherPath);
        if (f2.getBoolean("comOra", false)) {
            this.connection_property_compatibleMode = 1;
        }
        this.parseCompatibleMode(f2);
        this.connection_property_loadBalance = f2.getBoolean("loadBalance", this.connection_property_loadBalance);
        this.connection_property_loadBalancePercent = f2.a("loadBalancePercent", this.connection_property_loadBalancePercent, 0, 100);
        this.connection_property_keyWords = f2.a("keyWords", this.connection_property_keyWords);
        this.connection_property_appName = f2.getString("appName", this.connection_property_appName);
        this.connection_property_mppLocal = f2.getBoolean("mppLocal", this.connection_property_mppLocal);
        this.connection_property_socketTimeout = f2.a("socketTimeout", this.connection_property_socketTimeout, 0, null);
        this.connection_property_connectTimeout = f2.a("connectTimeout", this.connection_property_connectTimeout, 0, null);
        this.connection_property_sessionTimeout = f2.a("sessionTimeout", this.connection_property_sessionTimeout, 0, null);
        this.parseOsAuthType(f2);
        this.connection_property_continueBatchOnError = f2.getBoolean("continueBatchOnError", this.connection_property_continueBatchOnError);
        this.connection_property_escapeProcess = f2.getBoolean("escapeProcess", this.connection_property_escapeProcess);
        this.connection_property_autoCommit = f2.getBoolean("autoCommit", this.connection_property_autoCommit);
        this.connection_property_maxRows = f2.a("maxRows", this.connection_property_maxRows, 0, null);
        this.connection_property_rowPrefetch = f2.a("rowPrefetch", this.connection_property_rowPrefetch, 0, null);
        this.connection_property_bufPrefetch = f2.a("bufPrefetch", this.connection_property_bufPrefetch, 32, 65536);
        this.connection_property_lobMode = f2.a("LobMode", this.connection_property_lobMode, 1, 2);
        this.connection_property_stmtPoolMaxSize = f2.a("StmtPoolSize", this.connection_property_stmtPoolMaxSize, 0, null);
        this.connection_property_ignoreCase = f2.getBoolean("ignoreCase", this.connection_property_ignoreCase);
        this.connection_property_alwayseAllowCommit = f2.getBoolean("alwayseAllowCommit", this.connection_property_alwayseAllowCommit);
        this.connection_property_batchType = f2.a("batchType", this.connection_property_batchType, 1, 2);
        this.connection_property_resultSetType = f2.a("resultSetType", this.connection_property_resultSetType, (Integer)null, (Integer)null);
        this.connection_property_dbmdChkPrv = f2.getBoolean("dbmdChkPrv", this.connection_property_dbmdChkPrv);
        this.connection_property_isBdtaRS = f2.getBoolean("isBdtaRS", this.connection_property_isBdtaRS);
        this.connection_property_clobAsString = f2.getBoolean("clobAsString", this.connection_property_clobAsString);
        this.connection_property_callBatchNot = f2.getBoolean("callBatchNot", this.connection_property_callBatchNot);
        this.connection_property_sslFilesPath = f2.getString("sslFilesPath", this.connection_property_sslFilesPath);
        this.connection_property_sslKeystorePass = f2.getString("sslKeystorePass", this.connection_property_sslKeystorePass);
        this.connection_property_kerberosLoginConfPath = f2.getString("kerberosLoginConfPath", this.connection_property_kerberosLoginConfPath);
        this.connection_property_uKeyName = f2.getString("uKeyName", this.connection_property_uKeyName);
        this.connection_property_uKeyPin = f2.getString("uKeyPin", this.connection_property_uKeyPin);
        this.connection_property_columnNameUpperCase = f2.getBoolean("columnNameUpperCase", this.connection_property_columnNameUpperCase);
        this.connection_property_databaseProductName = f2.getString("databaseProductName", this.connection_property_databaseProductName);
        this.gZ = f2.a("bufferType", this.gZ, 0, 1);
    }

    private void parseOsAuthType(f f2) {
        String string = f2.getProperty("osAuthType");
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "ON")) {
                this.connection_property_osAuthType = 0;
            } else if (StringUtil.equalsIgnoreCase(string, "SYSDBA")) {
                this.connection_property_osAuthType = 1;
            } else if (StringUtil.equalsIgnoreCase(string, "SYSAUDITOR")) {
                this.connection_property_osAuthType = (byte)3;
            } else if (StringUtil.equalsIgnoreCase(string, "SYSSSO")) {
                this.connection_property_osAuthType = (byte)2;
            } else if (StringUtil.equalsIgnoreCase(string, "AUTO")) {
                this.connection_property_osAuthType = (byte)4;
            } else if (StringUtil.equalsIgnoreCase(string, "OFF")) {
                this.connection_property_osAuthType = 0;
            }
        } else {
            this.connection_property_osAuthType = (byte)f2.a("osAuthType", this.connection_property_osAuthType, 0, 4);
        }
        if (this.connection_property_user == null && this.connection_property_osAuthType == 0) {
            this.connection_property_user = "SYSDBA";
        } else if (this.connection_property_osAuthType != 0 && StringUtil.isNotEmpty(this.connection_property_user)) {
            DBError.ECJDBC_OSAUTH_ERROR.throwException(new String[0]);
        } else if (this.connection_property_osAuthType != 0) {
            this.connection_property_user = System.getProperty("user.name", "");
            this.connection_property_password = "";
        }
    }

    private void parseCompatibleMode(f f2) {
        String string = f2.getProperty("compatibleMode");
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "oracle")) {
                this.connection_property_compatibleMode = 1;
            } else if (StringUtil.equalsIgnoreCase(string, "mysql")) {
                this.connection_property_compatibleMode = 2;
            }
        } else {
            this.connection_property_compatibleMode = f2.a("compatibleMode", this.connection_property_compatibleMode, 0, 2);
        }
    }

    public boolean compatibleOracle() {
        return this.connection_property_compatibleMode == 1;
    }

    public boolean compatibleMysql() {
        return this.connection_property_compatibleMode == 2;
    }

    public boolean lobFetchAll() {
        return this.connection_property_lobMode == 2;
    }

    public static int db2jIsoLevel(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    public static int j2dbIsoLevel(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return -1;
    }

    public DmdbConnection(f f2) {
        super(null, f2);
        this.fk = f2;
        this.setAttributes(f2);
        if (this.connection_property_stmtPoolMaxSize > 0) {
            this.hg = new DmdbConnection$1(this, this.connection_property_stmtPoolMaxSize, false);
        }
    }

    public void openConnection() {
        try {
            this.hc = new a(this);
            this.hc.s();
            this.closed = false;
            this.resetClientInfo();
            DBAliveCheckThread.addConnection(this);
        }
        finally {
            if (this.closed) {
                this.free();
            }
        }
    }

    private void resetClientInfo() {
        this.fk.put("ApplicationName", this.connection_property_appName);
        this.fk.put("ClientUser", this.connection_property_user);
        this.fk.put("ClientHostname", this.connection_property_host);
    }

    public DmdbStatement do_createStatement() {
        return this.do_createStatement(this.connection_property_resultSetType, 1007, this.hd);
    }

    public DmdbStatement do_createStatement(int n2, int n3) {
        return this.do_createStatement(n2, n3, this.hd);
    }

    public DmdbStatement do_createStatement(int n2, int n3, int n4) {
        this.checkClosed();
        DmdbStatement dmdbStatement = new DmdbStatement(this, n2, n3, n4);
        this.hh.add(dmdbStatement);
        return dmdbStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string) {
        return this.do_prepareStatement(string, this.connection_property_resultSetType, 1007, this.hd);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2, int n3) {
        return this.do_prepareStatement(string, n2, n3, this.hd);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2, int n3, int n4) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, n2, n3, n4);
        this.hh.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, n2);
        this.hh.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int[] nArray) {
        return this.do_prepareStatement(string, nArray != null && nArray.length > 0 ? 1 : 2);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, String[] stringArray) {
        Object object;
        if (stringArray != null && stringArray.length > 0) {
            Object object2 = object = (string = string.trim()).length() > 20 ? string.substring(0, 20).toLowerCase() : string.toLowerCase();
            if (((String)object).startsWith("insert into ") || ((String)object).startsWith("update ") || ((String)object).startsWith("delete ")) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append(string);
                while (stringBuilder.charAt(stringBuilder.length() - 1) == ';') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                stringBuilder.append(" return ");
                StringUtil.append(stringBuilder, stringArray, ", ");
                stringBuilder.append(" into ");
                StringUtil.append(stringBuilder, "?", stringArray.length, ", ");
                string = stringBuilder.toString();
            }
        }
        object = this.do_prepareStatement(string);
        ((DmdbPreparedStatement)object).iw = stringArray;
        return object;
    }

    public DmdbCallableStatement do_prepareCall(String string) {
        return this.do_prepareCall(string, 1003, 1007, this.hd);
    }

    public DmdbCallableStatement do_prepareCall(String string, int n2, int n3) {
        return this.do_prepareCall(string, n2, n3, this.hd);
    }

    public DmdbCallableStatement do_prepareCall(String string, int n2, int n3, int n4) {
        this.checkClosed();
        DmdbCallableStatement dmdbCallableStatement = new DmdbCallableStatement(this, string, n2, n3, n4);
        this.hh.add(dmdbCallableStatement);
        return dmdbCallableStatement;
    }

    public String do_nativeSQL(String string) {
        try {
            return SQLProcessor.escape(string, this.connection_property_keyWords);
        }
        catch (IOException iOException) {
            DBError.throwException("Sql escape error!", iOException);
            return string;
        }
    }

    public void do_commit() {
        this.checkClosed();
        if (!this.connection_property_autoCommit) {
            this.hc.commit();
            this.gP = true;
        } else if (!this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_COMMIT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
    }

    public void do_rollback() {
        this.checkClosed();
        if (!this.connection_property_autoCommit) {
            this.hc.rollback();
            this.gP = true;
        } else if (!this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_ROLLBACK_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Object object = this.ha;
        synchronized (object) {
            if (this.hc != null) {
                this.hc.close();
            }
            this.closed = true;
            if (this.hh != null) {
                for (DmdbStatement dmdbStatement : this.hh) {
                    dmdbStatement.free();
                }
            }
            if (this.hg != null) {
                this.hg.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_close() {
        Object object = this.ha;
        synchronized (object) {
            if (this.compatibleOracle() && !this.closed) {
                this.commit();
            }
            this.free();
            if (this.hh != null) {
                this.hh.clear();
            }
            this.closed = true;
        }
    }

    public void checkClosed() {
        if (this.closed) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwException(new String[0]);
        }
    }

    public DmdbDatabaseMetaData do_getMetaData() {
        this.checkClosed();
        return new DmdbDatabaseMetaData(this);
    }

    public void do_setTransactionIsolation(int n2) {
        this.checkClosed();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.hc.setTransactionIsolation(n2);
                this.gs = n2;
                break;
            }
            case 4: {
                if (!this.compatibleMysql()) break;
                n2 = 2;
                this.hc.setTransactionIsolation(n2);
                this.gs = n2;
                break;
            }
            default: {
                DBError.ECJDBC_INVALID_TRAN_ISOLATION.throwException(new String[0]);
            }
        }
    }

    public void addSQLWarning(SQLWarning sQLWarning) {
        if (this.he == null) {
            this.he = sQLWarning;
        } else {
            this.he.setNextWarning(sQLWarning);
        }
    }

    public void do_clearWarnings() {
        this.he = null;
    }

    public DmdbSavepoint do_setSavepoint() {
        return this.do_setSavepoint(null);
    }

    public DmdbSavepoint do_setSavepoint(String string) {
        this.checkClosed();
        if (this.connection_property_autoCommit) {
            DBError.ECJDBC_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
        return new DmdbSavepoint(this, string);
    }

    public void do_rollback(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwException(new String[0]);
        }
        if (this.connection_property_autoCommit && !this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_ROLLBACK_TO_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
        DmdbSavepoint dmdbSavepoint = (DmdbSavepoint)savepoint;
        if (dmdbSavepoint.kz) {
            DBError.ECJDBC_SAVEPOINT_RELEASED.throwException(new String[0]);
        }
        String string = "ROLLBACK TO SAVEPOINT \"" + StringUtil.processDoubleQuoteOfName(dmdbSavepoint.name) + "\"";
        DriverUtil.execute(this, string);
    }

    public void do_releaseSavepoint(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwException(new String[0]);
        }
        if (this.connection_property_autoCommit && !this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_RELEASE_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
        ((DmdbSavepoint)savepoint).release();
    }

    public DmdbClob do_createClob() {
        this.checkClosed();
        return DmdbClob.newInstance("", this);
    }

    public DmdbBlob do_createBlob() {
        this.checkClosed();
        return DmdbBlob.newInstanceOfLocal(new byte[0], this);
    }

    public boolean do_isValid(int n2) {
        try {
            this.checkClosed();
            DriverUtil.execute(this, "select 1 from dual", n2);
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public void do_setClientInfo(String string, String string2) {
        this.fk.setProperty(string, string2);
    }

    public void do_setClientInfo(Properties properties) {
        this.fk.setProperties(properties);
    }

    public String do_getClientInfo(String string) {
        return this.fk.getProperty(string);
    }

    public Properties do_getClientInfo() {
        return this.fk;
    }

    public DmdbArray do_createArrayOf(String string, Object[] objectArray) {
        this.checkClosed();
        c c2 = new c(string, this);
        return new DmdbArray(c2, this, objectArray);
    }

    public DmdbStruct do_createStruct(String string, Object[] objectArray) {
        this.checkClosed();
        o o2 = new o(string, this);
        return new DmdbStruct(o2, this, objectArray);
    }

    public void do_setAutoCommit(boolean bl) {
        this.connection_property_autoCommit = bl;
    }

    public boolean do_getAutoCommit() {
        return this.connection_property_autoCommit;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean do_isReadOnly() {
        return this.readOnly;
    }

    public void do_setCatalog(String string) {
    }

    public String do_getCatalog() {
        return null;
    }

    public int do_getTransactionIsolation() {
        return this.gs;
    }

    public SQLWarning do_getWarnings() {
        return this.he;
    }

    public Map do_getTypeMap() {
        return this.hf;
    }

    public void do_setTypeMap(Map map) {
        this.hf = map;
    }

    public void do_setHoldability(int n2) {
        this.hd = n2;
    }

    public int do_getHoldability() {
        return this.hd;
    }

    public NClob do_createNClob() {
        this.checkClosed();
        return DmdbNClob.newInstance("", this);
    }

    public SQLXML do_createSQLXML() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public void do_setSchema(String string) {
        if (StringUtil.isNotEmpty(string)) {
            DriverUtil.execute(this, "set schema " + string);
            this.gz = string;
        }
    }

    public String do_getSchema() {
        return this.gz;
    }

    public void do_abort(Executor executor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(hi);
        }
        if (executor == null) {
            DBError.throwException("Executor can not be null", 0);
        }
        executor.execute(new DmdbConnection$2(this));
    }

    public void do_setNetworkTimeout(Executor executor, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(hj);
        }
        if (executor == null) {
            DBError.throwException("Executor can not be null", 0);
        }
        executor.execute(new DmdbConnection$3(this, n2));
    }

    public int do_getNetworkTimeout() {
        return this.connection_property_socketTimeout;
    }

    public void setTrxFinish(int n2) {
        switch (n2 & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                this.gP = true;
                break;
            }
            default: {
                this.gP = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement();
            }
            return this.filterChain.reset().Connection_createStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_nativeSQL(string);
            }
            return this.filterChain.reset().Connection_nativeSQL(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean bl) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setAutoCommit(bl);
            } else {
                this.filterChain.reset().Connection_setAutoCommit(this, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAutoCommit();
            }
            return this.filterChain.reset().Connection_getAutoCommit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_commit();
            } else {
                this.filterChain.reset().Connection_commit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_rollback();
            } else {
                this.filterChain.reset().Connection_rollback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().Connection_close(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        if (this.filterChain == null) {
            return this.do_isClosed();
        }
        return this.filterChain.reset().Connection_isClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMetaData();
            }
            return this.filterChain.reset().Connection_getMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean bl) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setReadOnly(bl);
            } else {
                this.filterChain.reset().Connection_setReadOnly(this, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isReadOnly();
            }
            return this.filterChain.reset().Connection_isReadOnly(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setCatalog(string);
            } else {
                this.filterChain.reset().Connection_setCatalog(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCatalog();
            }
            return this.filterChain.reset().Connection_getCatalog(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setTransactionIsolation(n2);
            } else {
                this.filterChain.reset().Connection_setTransactionIsolation(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTransactionIsolation();
            }
            return this.filterChain.reset().Connection_getTransactionIsolation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getWarnings();
            }
            return this.filterChain.reset().Connection_getWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_clearWarnings();
            } else {
                this.filterChain.reset().Connection_clearWarnings(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement(n2, n3);
            }
            return this.filterChain.reset().Connection_createStatement(this, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2, n3);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string, n2, n3);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string, n2, n3);
        }
    }

    public Map getTypeMap() {
        if (this.filterChain == null) {
            return this.do_getTypeMap();
        }
        return this.filterChain.reset().Connection_getTypeMap(this);
    }

    public void setTypeMap(Map map) {
        if (this.filterChain == null) {
            this.do_setTypeMap(map);
        } else {
            this.filterChain.reset().Connection_setTypeMap(this, map);
        }
    }

    @Override
    public void setHoldability(int n2) {
        if (this.filterChain == null) {
            this.do_setHoldability(n2);
        } else {
            this.filterChain.reset().Connection_setHoldability(this, n2);
        }
    }

    @Override
    public int getHoldability() {
        if (this.filterChain == null) {
            return this.do_getHoldability();
        }
        return this.filterChain.reset().Connection_getHoldability(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setSavepoint();
            }
            return this.filterChain.reset().Connection_setSavepoint(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setSavepoint(string);
            }
            return this.filterChain.reset().Connection_setSavepoint(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_rollback(savepoint);
            } else {
                this.filterChain.reset().Connection_rollback(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_releaseSavepoint(savepoint);
            } else {
                this.filterChain.reset().Connection_releaseSavepoint(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement(n2, n3, n4);
            }
            return this.filterChain.reset().Connection_createStatement(this, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2, n3, n4);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string, n2, n3, n4);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, nArray);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, stringArray);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createClob();
            }
            return this.filterChain.reset().Connection_createClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createBlob();
            }
            return this.filterChain.reset().Connection_createBlob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob createNClob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createNClob();
            }
            return this.filterChain.reset().Connection_createNClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML createSQLXML() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createSQLXML();
            }
            return this.filterChain.reset().Connection_createSQLXML(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isValid(n2);
            }
            return this.filterChain.reset().Connection_isValid(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String string, String string2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setClientInfo(string, string2);
            } else {
                this.filterChain.reset().Connection_setClientInfo(this, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setClientInfo(properties);
            } else {
                this.filterChain.reset().Connection_setClientInfo(this, properties);
            }
        }
    }

    @Override
    public String getClientInfo(String string) {
        if (this.filterChain == null) {
            return this.do_getClientInfo(string);
        }
        return this.filterChain.reset().Connection_getClientInfo(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClientInfo();
            }
            return this.filterChain.reset().Connection_getClientInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String string, Object[] objectArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createArrayOf(string, objectArray);
            }
            return this.filterChain.reset().Connection_createArrayOf(this, string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStruct(string, objectArray);
            }
            return this.filterChain.reset().Connection_createStruct(this, string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setSchema(string);
            } else {
                this.filterChain.reset().Connection_setSchema(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchema();
            }
            return this.filterChain.reset().Connection_getSchema(this);
        }
    }

    @Override
    public void abort(Executor executor) {
        if (this.filterChain == null) {
            this.do_abort(executor);
        } else {
            this.filterChain.reset().Connection_abort(this, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setNetworkTimeout(executor, n2);
            } else {
                this.filterChain.reset().Connection_setNetworkTimeout(this, executor, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNetworkTimeout() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNetworkTimeout();
            }
            return this.filterChain.reset().Connection_getNetworkTimeout(this);
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionTrace(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            return DriverUtil.executeAndGetExplain(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainInfo(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (StringUtil.isEmpty(string)) {
                DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
            }
            if (!string.equalsIgnoreCase("show_pln_stat")) {
                string = "EXPLAIN " + string;
            }
            return DriverUtil.executeAndGetExplain(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_reconnect() {
        Object object = this.ha;
        synchronized (object) {
            this.free();
            DmdbConnection dmdbConnection = this;
            synchronized (dmdbConnection) {
                m m2;
                m m3 = m2 = StringUtil.isNotEmpty(this.hb) ? g.c(this.hb) : null;
                if (m2 != null) {
                    m2.a(this);
                } else {
                    this.openConnection();
                }
                ArrayList<DmdbStatement> arrayList = new ArrayList<DmdbStatement>(this.hh.size());
                for (DmdbStatement dmdbStatement : this.hh) {
                    try {
                        dmdbStatement.reconnect();
                    }
                    catch (SQLException sQLException) {
                        arrayList.add(dmdbStatement);
                    }
                }
                for (DmdbStatement dmdbStatement : arrayList) {
                    try {
                        dmdbStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void reconnect() {
        if (this.filterChain == null) {
            this.do_reconnect();
        } else {
            this.filterChain.reset().Connection_reconnect(this);
        }
    }

    public short getDBTimeZone() {
        return this.go;
    }

    public String getHostName() {
        return this.connection_property_host;
    }

    public int getHostPort() {
        return this.connection_property_port;
    }

    public boolean getTransFinish() {
        return this.gP;
    }

    public String getLastLoginIP() {
        return this.gA;
    }

    public String getLastLoginTime() {
        return this.gB;
    }

    public int getLoginWarningID() {
        return this.gD;
    }

    public int getGraceTimeRemainder() {
        return this.gE;
    }

    public int getFailedAttempt() {
        return this.gC;
    }

    public boolean getNetworkEncypted() {
        return this.gH == 1;
    }

    public int getNetworkPacketSize() {
        return this.gK;
    }

    public int getConnectTimeout() {
        return this.connection_property_connectTimeout;
    }

    public int getLanguage() {
        return g.getLanguage();
    }

    public boolean getBackslashEsc() {
        return this.gt;
    }

    public int getGlobalServerSeries() {
        return this.gJ;
    }

    public int getEncryptMsg() {
        return this.gH;
    }

    public boolean getEscape() {
        return this.connection_property_escapeProcess;
    }

    public void setEscape(boolean bl) {
        this.connection_property_escapeProcess = bl;
    }

    public void setDbmdChkPrivileges(boolean bl) {
        this.connection_property_dbmdChkPrv = bl;
    }

    public boolean getDbmdChkPrivileges() {
        return this.connection_property_dbmdChkPrv;
    }

    public void reset() {
        if (this.filterChain == null) {
            this.do_reset();
        } else {
            this.filterChain.reset().Connection_reset(this);
        }
    }

    public void do_reset() {
        this.checkClosed();
        if (this.gY != -1L) {
            DriverUtil.executeWithNewConnection(this, "SP_CANCEL_SESSION_OPERATION(" + this.gY + ")");
        }
    }

    public String getServerEncoding() {
        if (StringUtil.isNotEmpty(this.connection_property_charCode)) {
            return this.connection_property_charCode;
        }
        return this.gm;
    }

    public void setServerEncoding(String string) {
        this.gm = string;
    }
}

