/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.SQLException;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;

    public void setFilter(Predicate predicate) throws SQLException {
        this.predicate = predicate;
    }

    public Predicate getFilter() {
        return this.predicate;
    }

    public boolean next() throws SQLException {
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow >= this.rowCount) {
            return false;
        }
        boolean bl = false;
        do {
            ++this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow <= this.rowCount);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow <= 1) {
            return false;
        }
        boolean bl = false;
        do {
            --this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow >= 1);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean absolute(int n) throws SQLException {
        int n2;
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        int n3 = n < 0 ? this.rowCount + n + 1 : n;
        this.presentRow = 0;
        for (n2 = 0; n2 < n3 && this.presentRow <= this.rowCount; ++n2) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n2 == n3) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    protected void checkAndFilterObject(int n, Object object) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(object, n)) {
            throw new SQLException("The object does not satisfy filtering criterion");
        }
    }
}

