/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowSet;
import dm.jdbc.driver.Row;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class DmdbRowSetWriter
implements RowSetWriter {
    private StringBuffer km = null;
    private StringBuffer kn = null;
    private StringBuffer ko = null;
    private int jy = 0;
    private String kp = "";
    private DmdbResultSetMetaData kq = null;
    private DmdbPreparedStatement kr = null;
    private DmdbPreparedStatement ks = null;
    private DmdbPreparedStatement kt = null;
    private DmdbConnection eR = null;

    private void initialize(DmdbRowSet dmdbRowSet) {
        this.kq = (DmdbResultSetMetaData)dmdbRowSet.getMetaData();
        this.jy = this.kq.do_getColumnCount();
        this.eR = dmdbRowSet.getConnection();
        this.kp = dmdbRowSet.getTableName().toUpperCase();
        this.km = new StringBuffer("UPDATE " + this.kp + " SET ");
        this.kn = new StringBuffer("INSERT INTO " + this.kp + "(");
        this.ko = new StringBuffer("DELETE FROM " + this.kp + " WHERE ");
        int n2 = 0;
        while (n2 < this.jy) {
            if (n2 > 0) {
                this.km.append(" , ");
                this.kn.append(" , ");
            }
            this.km.append(this.kq.do_getColumnName(n2 + 1)).append(" = ?");
            this.kn.append(this.kq.do_getColumnName(n2 + 1));
            ++n2;
        }
        this.kn.append(") VALUES(");
        this.km.append(" WHERE ");
        n2 = 0;
        while (n2 < this.jy) {
            if (n2 > 0) {
                this.kn.append(",");
                this.km.append(" AND ");
                this.ko.append(" AND ");
            }
            this.kn.append("?");
            this.km.append(this.kq.do_getColumnName(n2 + 1)).append("= ?");
            this.ko.append(this.kq.do_getColumnName(n2 + 1)).append("= ?");
            ++n2;
        }
        this.kn.append(")");
        this.ks = this.eR.do_prepareStatement(this.kn.substring(0, this.kn.length()));
        this.kr = this.eR.do_prepareStatement(this.km.substring(0, this.km.length()));
        this.kt = this.eR.do_prepareStatement(this.ko.substring(0, this.ko.length()));
    }

    private boolean insertRow(Row row) {
        this.ks.do_clearParameters();
        int n2 = 0;
        while (n2 < this.jy) {
            Object object = row.getColumn(n2);
            if (object == null) {
                this.ks.do_setNull(n2 + 1, this.kq.do_getColumnType(n2 + 1));
            } else {
                this.ks.do_setObject(n2 + 1, object);
            }
            ++n2;
        }
        return 1 == this.ks.do_executeUpdate();
    }

    private boolean updateRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.updateWithNull(row);
        }
        return this.updateNonNull(row);
    }

    private boolean updateWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.kp + " SET ");
        StringBuffer stringBuffer2 = new StringBuffer(" WHERE ");
        int[] nArray = new int[this.jy];
        int n2 = this.jy;
        int n3 = 0;
        while (n3 < this.jy) {
            if (n3 > 0) {
                stringBuffer.append(" , ");
                stringBuffer2.append(" AND ");
            }
            stringBuffer.append(this.kq.do_getColumnName(n3 + 1)).append(" = ?");
            stringBuffer2.append(this.kq.do_getColumnName(n3 + 1));
            if (row.isOriginalNull(n3)) {
                nArray[n3] = -1;
                stringBuffer2.append(" IS NULL ");
            } else {
                nArray[n3] = ++n2;
                stringBuffer2.append(" = ? ");
            }
            ++n3;
        }
        stringBuffer.append(stringBuffer2);
        DmdbPreparedStatement dmdbPreparedStatement = this.eR.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.jy) {
            Object object;
            Object object2 = row.getColumn(n4);
            Object object3 = object = row.isColumnChanged(n4) ? row.getChangedColumn(n4) : object2;
            if (object == null) {
                dmdbPreparedStatement.do_setNull(n4 + 1, this.kq.do_getColumnType(n4 + 1));
            } else {
                dmdbPreparedStatement.do_setObject(n4 + 1, object);
            }
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], object2);
            }
            ++n4;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        stringBuffer = null;
        stringBuffer2 = null;
        return n4 != 0;
    }

    private boolean updateNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.jy) {
            Object object;
            Object object2 = row.getColumn(n2);
            Object object3 = object = row.isColumnChanged(n2) ? row.getChangedColumn(n2) : object2;
            if (object == null) {
                this.kr.do_setNull(n2 + 1, this.kq.do_getColumnType(n2 + 1));
            } else {
                this.kr.do_setObject(n2 + 1, object);
            }
            this.kr.do_setObject(this.jy + n2 + 1, object2);
            ++n2;
        }
        return 1 == this.kr.do_executeUpdate();
    }

    private boolean deleteRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.deleteWithNull(row);
        }
        return this.deleteNonNull(row);
    }

    private boolean deleteWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.kp + " WHERE ");
        int[] nArray = new int[this.jy];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.jy) {
            if (n3 > 0) {
                stringBuffer.append(" AND ");
            }
            if (row.isOriginalNull(n3)) {
                stringBuffer.append(this.kq.do_getColumnName(n3 + 1)).append(" IS NULL ");
                nArray[n3] = -1;
            } else {
                stringBuffer.append(this.kq.do_getColumnName(n3 + 1)).append(" = ? ");
                nArray[n3] = ++n2;
            }
            ++n3;
        }
        DmdbPreparedStatement dmdbPreparedStatement = this.eR.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.jy) {
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], row.getColumn(n4));
            }
            n4 += 1;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        dmdbPreparedStatement = null;
        stringBuffer = null;
        return n4 != 0;
    }

    private boolean deleteNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.jy) {
            this.kt.do_setObject(n2 + 1, row.getColumn(n2));
            ++n2;
        }
        return 1 == this.kt.do_executeUpdate();
    }

    private void release() {
        this.kn = null;
        if (this.ks != null && !this.ks.closed) {
            this.ks.do_close();
            this.ks = null;
        }
        this.km = null;
        if (this.kr != null && !this.kr.closed) {
            this.kr.do_close();
            this.kr = null;
        }
        this.ko = null;
        if (this.kt != null && !this.kt.closed) {
            this.kt.do_close();
            this.kt = null;
        }
        this.jy = 0;
        this.kq = null;
        this.kp = "";
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) {
        DmdbRowSet dmdbRowSet = (DmdbRowSet)rowSetInternal;
        this.initialize(dmdbRowSet);
        if (this.jy < 1) {
            this.release();
            return true;
        }
        boolean bl = dmdbRowSet.getShowDeleted();
        if (this.eR.do_getAutoCommit()) {
            this.eR.do_setAutoCommit(false);
        }
        dmdbRowSet.setShowDeleted(true);
        dmdbRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        while (dmdbRowSet.next()) {
            Row row;
            if (dmdbRowSet.rowInserted()) {
                if (dmdbRowSet.rowDeleted()) continue;
                row = dmdbRowSet.getCurrentRow();
                bl2 = this.insertRow(row) && bl2;
                continue;
            }
            if (dmdbRowSet.rowUpdated()) {
                row = dmdbRowSet.getCurrentRow();
                bl3 = this.updateRow(row) && bl3;
                continue;
            }
            if (!dmdbRowSet.rowDeleted()) continue;
            row = dmdbRowSet.getCurrentRow();
            boolean bl5 = bl4 = this.deleteRow(row) && bl4;
        }
        if (!(bl2 && bl3 && bl4)) {
            this.eR.do_rollback();
        } else {
            this.eR.do_commit();
            dmdbRowSet.setOriginal();
        }
        dmdbRowSet.setShowDeleted(bl);
        this.release();
        if (!dmdbRowSet.keepConnecting() && this.eR != null && !this.eR.do_isClosed()) {
            this.eR.do_close();
            this.eR = null;
        }
        return true;
    }
}

