/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.h;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.ConvertUtil;
import java.util.Calendar;

public class DmdbResultSetCache {
    private long jd;
    private long[] je = null;
    private long[] jf = null;
    public h jg;

    DmdbResultSetCache(h h2) {
        this.jg = h2;
        this.je = (long[])h2.ep.clone();
        this.jf = (long[])h2.eq.clone();
        this.jd = Calendar.getInstance().getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean refreshed(DmdbConnection dmdbConnection) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            int n2;
            if (dmdbConnection.connection_property_rsRefreshFreq == 0) {
                return false;
            }
            if (this.jd + (long)(dmdbConnection.connection_property_rsRefreshFreq * 1000) > Calendar.getInstance().getTimeInMillis()) {
                return false;
            }
            long[] lArray = dmdbConnection.hc.a(dmdbConnection, this.je);
            this.jd = Calendar.getInstance().getTimeInMillis();
            int n3 = n2 = lArray == null ? 0 : lArray.length;
            if (n2 != this.jf.length) {
                return true;
            }
            int n4 = 0;
            while (true) {
                if (n4 >= n2) {
                    return false;
                }
                if (this.jf[n4] != lArray[n4]) {
                    return true;
                }
                ++n4;
            }
        }
    }

    DmdbResultSet getResultSet(DmdbStatement dmdbStatement) {
        int n2;
        Object object = this.jg.ej;
        int n3 = n2 = this.jg.ej == null ? 0 : this.jg.ej.length;
        if (dmdbStatement.kF > 0L && dmdbStatement.kF < (long)n2) {
            object = new byte[ConvertUtil.toInt(dmdbStatement.kF)][][];
            System.arraycopy(this.jg.ej, 0, object, 0, ((byte[][][])object).length);
        }
        DmdbResultSet dmdbResultSet = DmdbResultSet.newLocalResultSet(dmdbStatement, dmdbStatement.iI, object);
        dmdbResultSet.iH = 1;
        return dmdbResultSet;
    }

    long getLastChkTime() {
        return this.jd;
    }

    long getDataLen() {
        return this.jg.ek;
    }
}

