/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

class Row
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private int lc;
    private Object[] ld;
    private Object[] le;
    private boolean[] lf;
    private boolean[] lg;
    private boolean lh;
    private boolean li;
    private int lj;
    private boolean lk;

    public Row(int n2) {
        this.lc = n2;
        this.ld = new Object[n2];
        this.le = new Object[n2];
        this.lf = new boolean[n2];
        this.lg = new boolean[n2];
        this.lh = false;
        this.li = false;
        this.lj = 0;
        this.lk = false;
    }

    public Row(int n2, boolean bl) {
        this(n2);
        this.li = bl;
    }

    public Row(int n2, Object[] objectArray) {
        this(n2);
        System.arraycopy(objectArray, 0, this.ld, 0, n2);
    }

    public Object getColumn(int n2) {
        return this.ld[n2];
    }

    public Object getChangedColumn(int n2) {
        return this.le[n2];
    }

    public Object[] getOriginalRow() {
        return this.ld;
    }

    public boolean isOriginalNull(int n2) {
        return this.lg[n2];
    }

    public boolean isOriginalWithNull() {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.lc) {
            if (this.isOriginalNull(n2)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    void setOriginalNull(int n2, boolean bl) {
        this.lg[n2] = bl;
    }

    public void setColumnValue(int n2, Object object) {
        this.ld[n2] = object;
        if (this.li) {
            ++this.lj;
        }
    }

    public void updateColumnValue(int n2, Object object) {
        this.lf[n2] = true;
        this.le[n2] = object;
        if (this.li) {
            ++this.lj;
        }
    }

    public boolean isColumnChanged(int n2) {
        return this.lf[n2];
    }

    public void insertRow() {
        System.arraycopy(this.le, 0, this.ld, 0, this.lc);
        this.lf = null;
        this.lf = new boolean[this.lc];
        this.le = null;
        this.le = new Object[this.lc];
        this.lj = 0;
    }

    public boolean isRowDeleted() {
        return this.lk;
    }

    public boolean isRowInserted() {
        return this.li;
    }

    public boolean isRowUpdated() {
        if (this.lk || this.li) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.lc) {
            if (this.lf[n2]) {
                return true;
            }
            ++n2;
        }
        return this.lh;
    }

    public void cancelRowDeletion() {
        this.lk = false;
    }

    public void cancelRowUpdates() {
        int n2 = 0;
        while (n2 < this.lc) {
            this.lf[n2] = false;
            ++n2;
        }
        this.le = new Object[this.lc];
        this.lj = 0;
    }

    public void setRowUpdated(boolean bl) {
        this.lh = bl;
        if (!bl) {
            this.cancelRowUpdates();
        }
    }

    public void setRowDeleted(boolean bl) {
        this.lk = bl;
    }

    public void setRowInserted(boolean bl) {
        this.li = bl;
    }

    public boolean isRowFullyPopulated() {
        if (!this.li) {
            return false;
        }
        return this.lc == this.lj;
    }

    void setUpdatesOriginal() {
        int n2 = 0;
        while (n2 < this.lc) {
            if (this.lf[n2]) {
                this.ld[n2] = this.le[n2];
                this.le[n2] = null;
                this.lf[n2] = false;
            }
            ++n2;
        }
        this.lh = false;
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.lc);
        int n2 = 0;
        while (n2 < this.lc) {
            vector.add(this.isColumnChanged(n2) ? this.getChangedColumn(n2) : this.getColumn(n2));
            ++n2;
        }
        return vector;
    }

    public Row createCopy() {
        Row row = new Row(this.lc);
        System.arraycopy(this.ld, 0, row.ld, 0, this.lc);
        System.arraycopy(this.le, 0, this.le, 0, this.lc);
        System.arraycopy(this.lf, 0, row.lf, 0, this.lc);
        row.lj = this.lj;
        row.lk = this.lk;
        row.li = this.li;
        row.lh = this.lh;
        return row;
    }
}

