/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.Reader;
import java.sql.SQLException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DmdbReader
extends Reader {
    public static final int IS_BLOB = 0;
    public static final int IS_CLOB = 1;
    public static final int IS_STRING = 2;
    public static final int IS_BYTE = 3;
    public static final int IS_FILE_TYPE = 4;
    private DmdbBlob if = null;
    private DmdbClob ig = null;
    private int hv;
    private String ix = null;
    byte[] iy = null;
    char[] iz = null;
    int iA = 0;
    static final int iB = 32000;
    static final int iC = 8000;
    int hy = 0;
    int iD;
    int iE;
    private boolean closed = false;
    long iF = -1L;

    public DmdbReader(Object object) {
        if (object instanceof DmdbBlob) {
            this.if = (DmdbBlob)object;
            this.hv = 0;
        } else if (object instanceof DmdbClob) {
            this.ig = (DmdbClob)object;
            this.hv = 1;
        } else if (object instanceof String) {
            this.hv = 2;
            this.ix = (String)object;
        } else if (object instanceof byte[]) {
            this.hv = 3;
            this.iy = (byte[])object;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    protected DmdbReader(DmdbClob dmdbClob, long l2, long l3) {
        this.hv = 1;
        this.ig = dmdbClob;
        this.iA = (int)(l2 - 1L);
        this.iF = l3;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.closed) {
            DBError.throwIOException(DBError.ECJDBC_STREAM_CLOSED.reason);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        switch (this.hv) {
            case 0: {
                return this.readFromBlob(cArray, n2, n3);
            }
            case 1: {
                return this.readFromClob(cArray, n2, n3);
            }
            case 2: {
                return this.readFromString(cArray, n2, n3);
            }
            case 3: {
                return this.readFromByteArray(cArray, n2, n3);
            }
        }
        DBError.throwIOException("io read error.");
        return 0;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private int readFromBlob(char[] cArray, int n2, int n3) {
        int n4;
        block10: {
            block9: {
                n4 = 0;
                if (this.if != null) break block9;
                return -1;
            }
            if (this.iF < 0L) {
                this.iF = this.if.do_length();
            }
            if (this.iy != null && (this.iD = this.iy.length) > this.hy || this.iF > (long)this.iA) break block10;
            return -1;
        }
        try {
            long l2 = 0L;
            l2 = this.iy == null ? this.iF - (long)this.iA : this.iF - (long)this.iA + (long)this.iD - (long)this.hy;
            int n5 = (int)(l2 > (long)n3 ? (long)n3 : l2);
            while (n4 < n5) {
                int n6;
                if (this.iy == null || (this.iD = this.iy.length) <= this.hy) {
                    n6 = (int)(this.iF - (long)this.iA > 32000L ? 32000L : this.iF - (long)this.iA);
                    this.iy = this.if.do_getBytes(this.iA + 1, n6);
                    if (this.iy == null || this.iy.length <= 0) {
                        this.iy = new byte[0];
                        this.hy = 0;
                        this.iD = n6;
                        break;
                    }
                    this.hy = 0;
                    this.iD = n6;
                    this.iA += n6;
                }
                n6 = n5 - n4 < this.iD - this.hy ? n5 - n4 : this.iD - this.hy;
                int n7 = 0;
                while (n7 < n6) {
                    cArray[n2 + n7] = (char)this.iy[this.hy + n7];
                    ++n7;
                }
                n2 += n6;
                this.hy += n6;
                n4 += n6;
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int readFromClob(char[] cArray, int n2, int n3) {
        int n4;
        block9: {
            block8: {
                n4 = 0;
                if (this.ig != null) break block8;
                return -1;
            }
            if (this.iF < 0L) {
                this.iF = this.ig.do_length();
            }
            if (this.iz != null && (this.iE = this.iz.length) > this.hy || this.iF > (long)this.iA) break block9;
            return -1;
        }
        try {
            long l2 = 0L;
            l2 = this.iz == null ? this.iF - (long)this.iA : this.iF - (long)this.iA + (long)this.iE - (long)this.hy;
            int n5 = (int)(l2 > (long)n3 ? (long)n3 : l2);
            while (n4 < n5) {
                int n6;
                if (this.iz == null || (this.iE = this.iz.length) <= this.hy) {
                    n6 = (int)(this.iF - (long)this.iA > 8000L ? 8000L : this.iF - (long)this.iA);
                    String string = this.ig.do_getSubString(this.iA + 1, n6);
                    if (string == null || string.length() <= 0) {
                        this.iz = new char[0];
                        this.hy = 0;
                        this.iE = 0;
                        break;
                    }
                    this.iz = new char[n6];
                    string.getChars(0, n6, this.iz, 0);
                    this.hy = 0;
                    this.iA += n6;
                    this.iE = n6;
                }
                n6 = n5 - n4 < this.iE - this.hy ? n5 - n4 : this.iE - this.hy;
                System.arraycopy(this.iz, this.hy, cArray, n2, n6);
                n2 += n6;
                this.hy += n6;
                n4 += n6;
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int readFromString(char[] cArray, int n2, int n3) {
        int n4;
        if (this.ix == null || (this.iE = this.ix.length()) <= this.hy) {
            return -1;
        }
        int n5 = n4 = n3 > this.iE - this.hy ? this.iE - this.hy : n3;
        if (n2 + n4 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        this.ix.getChars(this.hy, this.hy + n4, cArray, n2);
        this.hy += n4;
        return n4;
    }

    private int readFromByteArray(char[] cArray, int n2, int n3) {
        int n4;
        if (this.iy == null || (this.iD = this.iy.length) <= this.hy) {
            return -1;
        }
        int n5 = n4 = n3 > this.iD - this.hy ? this.iD - this.hy : n3;
        if (n2 + n4 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        int n6 = 0;
        while (n6 < n4) {
            cArray[n2 + n6] = (char)this.iy[n6 + this.hy];
            ++n6;
        }
        this.hy += n4;
        return n4;
    }
}

