/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat.util;

import dm.jdbc.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class JSONWriter {
    private StringBuilder out = new StringBuilder();

    public void writeArrayStart() {
        this.write('[');
    }

    public void writeComma() {
        this.write(',');
    }

    public void writeArrayEnd() {
        this.write(']');
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            this.write(object.toString());
            return;
        }
        if (object instanceof Boolean) {
            this.write(object.toString());
            return;
        }
        if (object instanceof Date) {
            this.writeDate((Date)object);
            return;
        }
        if (object instanceof Collection) {
            this.writeArray((Collection)object);
            return;
        }
        if (object instanceof Throwable) {
            this.writeError((Throwable)object);
            return;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.write('[');
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n2 != 0) {
                    this.write(',');
                }
                this.write(nArray[n2]);
                ++n2;
            }
            this.write(']');
            return;
        }
        if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.write('[');
            int n3 = 0;
            while (n3 < lArray.length) {
                if (n3 != 0) {
                    this.write(',');
                }
                this.write(lArray[n3]);
                ++n3;
            }
            this.write(']');
            return;
        }
        if (object instanceof TabularData) {
            this.writeTabularData((TabularData)object);
            return;
        }
        if (object instanceof CompositeData) {
            this.writeCompositeData((CompositeData)object);
            return;
        }
        if (object instanceof Map) {
            this.writeMap((Map)object);
            return;
        }
        throw new IllegalArgumentException("not support type : " + object.getClass());
    }

    public void writeDate(Date date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.writeString(simpleDateFormat.format(date));
    }

    public void writeError(Throwable throwable) {
        if (throwable == null) {
            this.writeNull();
            return;
        }
        this.write("{\"Class\":");
        this.writeString(throwable.getClass().getName());
        this.write(",\"Message\":");
        this.writeString(throwable.getMessage());
        this.write(",\"StackTrace\":");
        this.writeString(StringUtil.getStackTrace(throwable));
        this.write('}');
    }

    public void writeArray(Object[] objectArray) {
        if (objectArray == null) {
            this.writeNull();
            return;
        }
        this.write('[');
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n2 != 0) {
                this.write(',');
            }
            this.writeObject(objectArray[n2]);
            ++n2;
        }
        this.write(']');
    }

    public void writeArray(Collection collection) {
        if (collection == null) {
            this.writeNull();
            return;
        }
        int n2 = 0;
        this.write('[');
        for (Object e2 : collection) {
            if (n2 != 0) {
                this.write(',');
            }
            this.writeObject(e2);
            ++n2;
        }
        this.write(']');
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeNull();
            return;
        }
        this.write('\"');
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '\"') {
                this.write("\\\"");
            } else if (c2 == '\n') {
                this.write("\\n");
            } else if (c2 == '\r') {
                this.write("\\r");
            } else if (c2 == '\\') {
                this.write("\\\\");
            } else if (c2 == '\t') {
                this.write("\\t");
            } else if (c2 < '\u0010') {
                this.write("\\u000");
                this.write(Integer.toHexString(c2));
            } else if (c2 < ' ') {
                this.write("\\u00");
                this.write(Integer.toHexString(c2));
            } else if (c2 >= '\u007f' && c2 <= '\u00a0') {
                this.write("\\u00");
                this.write(Integer.toHexString(c2));
            } else {
                this.write(c2);
            }
            ++n2;
        }
        this.write('\"');
    }

    public void writeTabularData(TabularData tabularData) {
        if (tabularData == null) {
            this.writeNull();
            return;
        }
        int n2 = 0;
        this.write('[');
        for (Object obj : tabularData.values()) {
            if (n2 != 0) {
                this.write(',');
            }
            CompositeData compositeData = (CompositeData)obj;
            this.writeCompositeData(compositeData);
            ++n2;
        }
        this.write(']');
    }

    public void writeCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            this.writeNull();
            return;
        }
        int n2 = 0;
        this.write('{');
        for (String string : compositeData.getCompositeType().keySet()) {
            if (n2 != 0) {
                this.write(',');
            }
            this.writeString(string);
            this.write(':');
            Object object = compositeData.get(string);
            this.writeObject(object);
            ++n2;
        }
        this.write('}');
    }

    public void writeMap(Map map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        int n2 = 0;
        this.write('{');
        for (Map.Entry entry : map.entrySet()) {
            if (n2 != 0) {
                this.write(',');
            }
            this.writeString((String)entry.getKey());
            this.write(':');
            this.writeObject(entry.getValue());
            ++n2;
        }
        this.write('}');
    }

    protected void write(String string) {
        this.out.append(string);
    }

    protected void write(char c2) {
        this.out.append(c2);
    }

    protected void write(int n2) {
        this.out.append(n2);
    }

    protected void write(long l2) {
        this.out.append(l2);
    }

    public String toString() {
        return this.out.toString();
    }
}

