/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance = null;
    protected Hashtable m_connCache = new Hashtable();
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription = false;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:39:40_PST_2008";

    private OracleConnectionCacheManager() {
    }

    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        try {
            if (cacheManagerInstance == null) {
                cacheManagerInstance = new OracleConnectionCacheManager();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return cacheManagerInstance;
    }

    public String createCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        String string = null;
        if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
            DatabaseError.throwSqlException(137);
        }
        string = oracleDataSource.connCacheName != null ? oracleDataSource.connCacheName : oracleDataSource.dataSourceName + "#0x" + Integer.toHexString(this.m_connCache.size());
        this.createCache(string, oracleDataSource, properties);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache(String string, OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        Object object;
        boolean bl;
        if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
            DatabaseError.throwSqlException(137);
        }
        if (string == null) {
            DatabaseError.throwSqlException(138);
        }
        if (this.m_connCache.containsKey(string)) {
            DatabaseError.throwSqlException(140);
        }
        if ((bl = oracleDataSource.getFastConnectionFailoverEnabled()) && this.failoverEventHandlerThread == null) {
            object = oracleDataSource.getONSConfiguration();
            if (object != null && !((String)object).equals("")) {
                OracleConnectionCacheManager oracleConnectionCacheManager = this;
                synchronized (oracleConnectionCacheManager) {
                    if (!isONSInitializedForRemoteSubscription) {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                                private final /* synthetic */ String val$onsConfigStr;
                                {
                                    this.val$onsConfigStr = string;
                                }

                                public Object run() throws ONSException {
                                    ONS oNS = new ONS(this.val$onsConfigStr);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            DatabaseError.throwSqlException(175, privilegedActionException);
                        }
                        isONSInitializedForRemoteSubscription = true;
                    }
                }
            }
            this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
        }
        object = new OracleImplicitConnectionCache(oracleDataSource, properties);
        ((OracleImplicitConnectionCache)object).cacheName = string;
        oracleDataSource.odsCache = object;
        this.m_connCache.put(string, object);
        if (bl) {
            this.checkAndStartThread(this.failoverEventHandlerThread);
        }
    }

    public void removeCache(String string, long l) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(string) : null;
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.disableConnectionCache();
            if (l > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(l * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (oracleImplicitConnectionCache.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.cleanupFCFThreads(oracleImplicitConnectionCache);
            }
            oracleImplicitConnectionCache.closeConnectionCache(l < 0L ? 32 : 1);
            oracleImplicitConnectionCache = null;
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void reinitializeCache(String string, Properties properties) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            this.disableCache(string);
            oracleImplicitConnectionCache.reinitializeCacheConnections(properties);
            this.enableCache(string);
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public boolean existsCache(String string) throws SQLException {
        return this.m_connCache.containsKey(string);
    }

    public void enableCache(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.enableConnectionCache();
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void disableCache(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.disableConnectionCache();
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void refreshCache(String string, int n) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            switch (n) {
                case 4096: 
                case 8192: {
                    oracleImplicitConnectionCache.refreshCacheConnections(n);
                    break;
                }
                default: {
                    DatabaseError.throwSqlException(68);
                    break;
                }
            }
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void purgeCache(String string, boolean bl) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.purgeCacheConnections(bl, 1);
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public Properties getCacheProperties(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.getConnectionCacheProperties();
        }
        DatabaseError.throwSqlException(141);
        return null;
    }

    public String[] getCacheNameList() throws SQLException {
        return this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
    }

    public int getNumberOfAvailableConnections(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.cacheSize;
        }
        DatabaseError.throwSqlException(141);
        return 0;
    }

    public int getNumberOfActiveConnections(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.getNumberOfCheckedOutConnections();
        }
        DatabaseError.throwSqlException(141);
        return 0;
    }

    public synchronized void setConnectionPoolDataSource(String string, ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            if (oracleImplicitConnectionCache.cacheSize > 0) {
                DatabaseError.throwSqlException(78);
            } else {
                ((OracleConnectionPoolDataSource)connectionPoolDataSource).makeURL();
                ((OracleConnectionPoolDataSource)connectionPoolDataSource).setURL(((OracleConnectionPoolDataSource)connectionPoolDataSource).url);
                oracleImplicitConnectionCache.connectionPoolDS = (OracleConnectionPoolDataSource)connectionPoolDataSource;
            }
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    protected void verifyAndHandleEvent(int n, byte[] byArray) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        StringTokenizer stringTokenizer = null;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string6 = null;
        String string7 = null;
        String string8 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string7 = null;
            string6 = stringTokenizer.nextToken();
            if (string6.equals("=") && stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken();
            } else {
                string8 = string6;
            }
            if (string8.equalsIgnoreCase("version") && string7 != null && !string7.equals("1.0")) {
                DatabaseError.throwSqlException(146);
            }
            if (string8.equalsIgnoreCase("service") && string7 != null) {
                string = string7;
            }
            if (string8.equalsIgnoreCase("instance") && string7 != null && !string7.equals(" ")) {
                string2 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("database") && string7 != null) {
                string3 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("host") && string7 != null) {
                string4 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("status") && string7 != null) {
                string5 = string7;
            }
            if (!string8.equalsIgnoreCase("card") || string7 == null) continue;
            try {
                n2 = Integer.parseInt(string7);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.invokeFailoverProcessingThreads(n, string, string2, string3, string4, string5, n2);
        stringTokenizer = null;
    }

    private void invokeFailoverProcessingThreads(int n, String string, String string2, String string3, String string4, String string5, int n2) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 256) {
            bl = true;
        }
        if (n == 512) {
            bl2 = true;
        }
        Iterator iterator = this.m_connCache.values().iterator();
        while (iterator.hasNext()) {
            oracleImplicitConnectionCache = (OracleImplicitConnectionCache)iterator.next();
            if ((!bl || !string.equalsIgnoreCase(oracleImplicitConnectionCache.dataSourceServiceName)) && !bl2) continue;
            OracleFailoverWorkerThread oracleFailoverWorkerThread = new OracleFailoverWorkerThread(oracleImplicitConnectionCache, n, string2, string3, string4, string5, n2);
            this.checkAndStartThread(oracleFailoverWorkerThread);
            oracleImplicitConnectionCache.failoverWorkerThread = oracleFailoverWorkerThread;
        }
    }

    protected void checkAndStartThread(Thread thread) throws SQLException {
        try {
            if (!thread.isAlive()) {
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    protected boolean failoverEnabledCacheExists() {
        return this.failoverEnabledCacheCount > 0;
    }

    protected void parseRuntimeLoadBalancingEvent(String string, byte[] byArray) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        Enumeration enumeration = this.m_connCache.elements();
        while (enumeration.hasMoreElements()) {
            try {
                oracleImplicitConnectionCache = (OracleImplicitConnectionCache)enumeration.nextElement();
                if (!string.equalsIgnoreCase(oracleImplicitConnectionCache.dataSourceServiceName)) continue;
                if (byArray == null) {
                    oracleImplicitConnectionCache.zapRLBInfo();
                    continue;
                }
                this.retrieveServiceMetrics(oracleImplicitConnectionCache, byArray);
            }
            catch (Exception exception) {}
        }
    }

    private void retrieveServiceMetrics(OracleImplicitConnectionCache oracleImplicitConnectionCache, byte[] byArray) throws SQLException {
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = null;
            string3 = stringTokenizer.nextToken();
            if (string3.equals("=") && stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            } else {
                if (string3.equals("}")) {
                    if (!bl) continue;
                    oracleImplicitConnectionCache.updateDatabaseInstance(string2, string, n, n2);
                    bl = false;
                    continue;
                }
                if (string3.equals("{") || string3.equals(" ")) continue;
                string5 = string3;
                bl = true;
            }
            if (string5.equalsIgnoreCase("version") && string4 != null && !string4.equals("1.0")) {
                DatabaseError.throwSqlException(146);
            }
            if (string5.equalsIgnoreCase("database") && string4 != null) {
                string2 = string4.toLowerCase().intern();
            }
            if (string5.equalsIgnoreCase("instance") && string4 != null) {
                string = string4.toLowerCase().intern();
            }
            if (string5.equalsIgnoreCase("percent") && string4 != null) {
                try {
                    n = Integer.parseInt(string4);
                    if (n == 0) {
                        n = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!string5.equalsIgnoreCase("flag") || string4 == null) continue;
            if (string4.equalsIgnoreCase("good")) {
                n2 = 1;
                continue;
            }
            if (string4.equalsIgnoreCase("violating")) {
                n2 = 3;
                continue;
            }
            if (string4.equalsIgnoreCase("NO_DATA")) {
                n2 = 4;
                continue;
            }
            if (string4.equalsIgnoreCase("UNKNOWN")) {
                n2 = 2;
                continue;
            }
            if (!string4.equalsIgnoreCase("BLOCKED")) continue;
            n2 = 5;
        }
        oracleImplicitConnectionCache.processDatabaseInstances();
    }

    protected void cleanupFCFThreads(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.cleanupFCFWorkerThread(oracleImplicitConnectionCache);
        oracleImplicitConnectionCache.cleanupRLBThreads();
        if (this.failoverEnabledCacheCount <= 0) {
            this.cleanupFCFEventHandlerThread();
        }
        --this.failoverEnabledCacheCount;
    }

    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        if (oracleImplicitConnectionCache.failoverWorkerThread != null) {
            try {
                if (oracleImplicitConnectionCache.failoverWorkerThread.isAlive()) {
                    oracleImplicitConnectionCache.failoverWorkerThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            oracleImplicitConnectionCache.failoverWorkerThread = null;
        }
    }

    protected void cleanupFCFEventHandlerThread() throws SQLException {
        if (this.failoverEventHandlerThread != null) {
            try {
                this.failoverEventHandlerThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.failoverEventHandlerThread = null;
        }
    }

    public boolean isFatalConnectionError(SQLException sQLException) {
        boolean bl = false;
        int n = sQLException.getErrorCode();
        if (n == 3113 || n == 3114 || n == 1033 || n == 1034 || n == 1089 || n == 1090 || n == 17002) {
            bl = true;
        }
        if (!bl && this.fatalErrorCodes != null) {
            for (int i = 0; i < this.fatalErrorCodes.length; ++i) {
                if (n != this.fatalErrorCodes[i]) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public synchronized void setConnectionErrorCodes(int[] nArray) throws SQLException {
        if (nArray != null) {
            this.fatalErrorCodes = nArray;
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        return this.fatalErrorCodes;
    }

    public Map getStatistics(String string) throws SQLException {
        Map map = null;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        if (this.m_connCache != null && (oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string)) != null) {
            map = oracleImplicitConnectionCache.getStatistics();
        }
        return map;
    }
}

