/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBfile;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.BFILE;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeBFILE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -707073491109554687L;
    static int fixedDataSize = 530;
    transient OracleConnection connection;

    public OracleTypeBFILE() {
    }

    public OracleTypeBFILE(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum datum = null;
        if (object != null) {
            if (object instanceof BFILE) {
                datum = (Datum)object;
            } else if (object instanceof OracleBfile) {
                datum = (Datum)object;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
            }
        }
        return datum;
    }

    @Override
    public int getTypeCode() {
        return -13;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 2) {
            return this.connection.createBfile(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray).fillInStackTrace();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

