SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for app
-- ----------------------------
DROP TABLE IF EXISTS `app`;
CREATE TABLE `app` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '站点id',
  `app_name` varchar(60) NOT NULL COMMENT '站点名称',
  `app_url` varchar(200) NOT NULL COMMENT '站点域名，多个回车换行显示',
  `app_logo` varchar(4000) DEFAULT NULL COMMENT '网站logo',
  `app_keyword` varchar(500) DEFAULT NULL COMMENT '站点关键字',
  `app_copyright` varchar(500) DEFAULT NULL COMMENT '站点版权信息',
  `app_style` varchar(50) DEFAULT NULL COMMENT '站点风格',
  `app_description` varchar(500) DEFAULT NULL COMMENT '描述',
  `app_pay` varchar(300) DEFAULT NULL COMMENT '费用清单',
  `app_state` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0运行中 1已停止  ',
  `app_datetime` datetime DEFAULT NULL COMMENT '创建时间',
  `app_pay_date` datetime DEFAULT NULL COMMENT '应用续费时间',
  `app_dir` varchar(10) DEFAULT NULL COMMENT '网站生成的目录',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL,
  `del` int(1) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='应用表';

-- ----------------------------
-- Records of app
-- ----------------------------
BEGIN;
INSERT INTO `app` VALUES (1, '铭飞MCms(5.2.4)', 'http://localhost:8080\r\n', '[{\"url\":\"/upload/1/appLogo/1609397756549.png\",\"name\":\"1593834123492.png\",\"path\":\"/upload/1/appLogo/1609397756549.png\",\"uid\":1609397756411,\"status\":\"success\"}]', '铭飞MCMS', '版权所有 ©铭飞科技有限公司2012-2019 保留一切权利。', 'default', '铭飞MCMS', '', 0, NULL, '2019-11-17 04:00:00', 'web', '2021-05-28 14:25:46', '57', NULL, '', NULL);
COMMIT;

-- ----------------------------
-- Table structure for cms_category
-- ----------------------------
DROP TABLE IF EXISTS `cms_category`;
CREATE TABLE `cms_category` (
  `id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL COMMENT '所属栏目',
  `leaf` int(1) DEFAULT NULL COMMENT '是否是叶子节点',
  `top_id` bigint(20) DEFAULT NULL COMMENT '顶级id',
  `dict_id` int(11) DEFAULT NULL COMMENT '字典对应编号',
  `mdiy_model_id` int(11) DEFAULT NULL COMMENT '栏目管理的内容模型id',
  `category_parent_ids` varchar(255) DEFAULT NULL COMMENT '父类型编号，多个id逗号',
  `category_title` varchar(255) DEFAULT NULL COMMENT '栏目管理名称',
  `category_img` varchar(2000) DEFAULT NULL COMMENT '缩略图',
  `category_flag` varchar(255) DEFAULT NULL COMMENT '栏目属性',
  `category_descrip` varchar(500) DEFAULT NULL COMMENT '栏目管理描述',
  `category_keyword` varchar(300) DEFAULT NULL COMMENT '栏目管理关键字',
  `category_path` varchar(255) DEFAULT NULL COMMENT '栏目路径',
  `category_diy_url` varchar(255) DEFAULT NULL COMMENT '自定义链接',
  `category_url` varchar(50) DEFAULT NULL COMMENT '内容模板',
  `category_list_url` varchar(50) DEFAULT NULL COMMENT '列表模板',
  `category_type` varchar(10) DEFAULT NULL COMMENT '栏目管理属性',
  `category_pinyin` varchar(255) DEFAULT NULL COMMENT '栏目拼音',
  `category_datetime` datetime DEFAULT NULL COMMENT '类别发布时间',
  `category_sort` int(11) DEFAULT NULL COMMENT '自定义顺序',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分类';

-- ----------------------------
-- Records of cms_category
-- ----------------------------
BEGIN;
INSERT INTO `cms_category` VALUES (1329257213283344385, NULL, 1, 0, NULL, NULL, NULL, '公司产品', '[]', 'nav', '', '', '/product', '', 'product-detail.htm', 'product-list.htm', '1', 'product', NULL, 0, '2021-10-21 08:39:21', '57', '2020-11-19 10:56:31', '57', 0);
INSERT INTO `cms_category` VALUES (1329257282518720513, NULL, 0, 0, NULL, NULL, NULL, '新闻动态', '[]', 'nav', '', '', '/news', '', 'news-detail.htm', 'news-list.htm', '1', 'news', NULL, 0, '2020-12-30 05:06:46', '57', '2020-11-19 10:56:47', '57', 0);
INSERT INTO `cms_category` VALUES (1329257498923835394, NULL, 0, 0, NULL, NULL, NULL, '关于我们', '[]', 'nav', '', '', '/gywm', '/gywm/lianxiwomen/index.html', 'about.htm', '', '3', 'gywm', NULL, 0, '2020-12-31 03:43:54', '57', '2020-11-19 10:57:39', '57', 0);
INSERT INTO `cms_category` VALUES (1329257594591715329, 1329257498923835394, 1, 1329257498923835394, NULL, NULL, '1329257498923835394', '联系我们', '[]', 'd', '', '', '/gywm/lianxiwomen', '', 'about.htm', '', '2', 'lianxiwomen', NULL, 0, '2020-11-19 18:33:02', '57', '2020-11-19 10:58:02', '57', 0);
INSERT INTO `cms_category` VALUES (1329257757913718785, 1329257213283344385, 1, 1329257213283344385, NULL, NULL, '1329257213283344385', '开源产品', '[]', '', '', '', '/product/kycp', '', 'product-detail.htm', 'product-list.htm', '1', 'kycp', NULL, 0, '2021-05-28 16:27:25', '57', '2020-11-19 10:58:41', '57', 0);
INSERT INTO `cms_category` VALUES (1329257820769558530, 1329257213283344385, 1, 1329257213283344385, NULL, NULL, '1329257213283344385', '行业产品', '[]', '', '', '', '/product/hycp', '', 'product-detail.htm', 'product-list.htm', '1', 'hycp', NULL, 0, '2020-12-30 20:23:58', '57', '2020-11-19 10:58:56', '57', 0);
INSERT INTO `cms_category` VALUES (1329258628990967809, 1329257282518720513, 1, 1329257282518720513, NULL, NULL, '1329257282518720513', '公司动态', '[]', '', '', '', '/news/gsdt', '', 'news-detail.htm', 'news-list.htm', '1', 'gsdt', NULL, 0, '2020-11-19 18:32:23', '57', '2020-11-19 11:02:08', '57', 0);
INSERT INTO `cms_category` VALUES (1329258744783118337, 1329257282518720513, 1, 1329257282518720513, NULL, NULL, '1329257282518720513', '行业动态', '[]', '', '行业动态', '', '/news/xingyedongtai', '', 'news-detail.htm', 'news-list.htm', '1', 'xingyedongtai', NULL, 0, '2021-01-27 04:32:56', '57', '2020-11-19 11:02:36', '57', 0);
INSERT INTO `cms_category` VALUES (1329259260493766658, 1329257498923835394, 1, 1329257498923835394, NULL, NULL, '1329257498923835394', '公司介绍', '[]', '', '', '', '/gywm/gongsijieshao', '', 'about.htm', '', '2', 'gongsijieshao', NULL, 0, '2020-11-19 18:33:10', '57', '2020-11-19 11:04:39', '57', 0);
INSERT INTO `cms_category` VALUES (1329316146811314177, 1329257213283344385, 1, 1329257213283344385, NULL, NULL, '1329257213283344385', '平台产品', '[]', '', '', '', '/product/pingtaichanpin', '', 'product-detail.htm', 'product-list.htm', '1', 'pingtaichanpin', NULL, 0, '2020-12-30 20:24:10', '57', '2020-11-19 14:50:42', '57', 0);
INSERT INTO `cms_category` VALUES (1329357285870346241, NULL, 1, 0, NULL, NULL, NULL, '幻灯', '[]', '', '', '', '/huandeng', '', 'news-detail.htm', 'news-list.htm', '1', 'huandeng', NULL, 0, '2020-11-19 18:33:47', '57', '2020-11-19 17:34:10', '57', 0);
COMMIT;

-- ----------------------------
-- Table structure for cms_content
-- ----------------------------
DROP TABLE IF EXISTS `cms_content`;
CREATE TABLE `cms_content` (
  `id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL COMMENT '所属栏目',
  `content_details` longtext COMMENT '文章内容',
  `content_title` varchar(255) DEFAULT NULL COMMENT '文章标题',
  `content_url` varchar(255) DEFAULT NULL COMMENT '文章跳转链接地址',
  `content_keyword` varchar(255) DEFAULT NULL COMMENT '关键字',
  `content_description` varchar(400) DEFAULT NULL COMMENT '描述',
  `content_img` varchar(1000) DEFAULT NULL COMMENT '文章缩略图',
  `content_source` varchar(255) DEFAULT NULL COMMENT '文章来源',
  `content_author` varchar(255) DEFAULT NULL COMMENT '文章作者',
  `content_display` varchar(10) DEFAULT '0' COMMENT '是否显示0显示 1不显示',
  `content_type` varchar(100) DEFAULT NULL COMMENT '文章类型',
  `content_datetime` datetime DEFAULT NULL COMMENT '发布时间',
  `content_sort` int(11) DEFAULT NULL COMMENT '自定义顺序',
  `content_hit` int(22) DEFAULT '0' COMMENT '点击次数',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_category_id` (`category_id`),
  CONSTRAINT `fk_category_id` FOREIGN KEY (`category_id`) REFERENCES `cms_category` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章';

-- ----------------------------
-- Records of cms_content
-- ----------------------------
BEGIN;
INSERT INTO `cms_content` VALUES (1329315860382294018, 1329257820769558530, '<p><img src=\"/upload/1/cms/content/editor/1609809963757.png\" title=\"1609809963757.png\" alt=\"image.png\"/></p>', 'MEC工程造价咨询管理软件', NULL, '', '支持分公司、跨地域协同管理，支持微信审批、通知更即时，与钉钉一样的审批，让审批流程更简单', '[{\"url\":\"blob:http://localhost:8080/605fb4e4-7874-4f30-9eb6-87c8dc4b046f\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609837720097.png\",\"uid\":1609837720054,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 14:49:22', 0, NULL, '2021-01-05 03:08:41', '57', '2020-11-19 14:49:33', '57', 0);
INSERT INTO `cms_content` VALUES (1329315928002863105, 1329257820769558530, '<p>1、BIM引擎</p><p>2、项目管理</p><p>3、计划管理</p><p>4、进度管理</p><p>5、质量管理</p><p>6、填报管理</p>', 'BIMCms施工管理软件', NULL, '', 'BIM数字化构件施工模型', '[{\"url\":\"blob:http://localhost:8080/e267453c-5762-40af-ba47-b7979e11421e\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609837616948.png\",\"uid\":1609837616874,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 14:49:35', 0, NULL, '2021-01-05 03:06:58', '57', '2020-11-19 14:49:49', '57', 0);
INSERT INTO `cms_content` VALUES (1329316558960402434, 1329316146811314177, '<p>1、项目管理<br/>2、任务管理</p><p>3、日志管理</p><p>4、周报管理</p>', 'PM项目管理', NULL, '', '敏捷开发模式管理', '[{\"url\":\"blob:http://localhost:8080/ca98a218-a251-4eb5-b1be-7c4d0078a899\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609838116473.png\",\"uid\":1609838116438,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 14:52:08', 0, NULL, '2021-01-05 03:15:17', '57', '2020-11-19 14:52:20', '57', 0);
INSERT INTO `cms_content` VALUES (1329316838384934914, 1329316146811314177, '<p>1、后台页面自动生成</p><p>2、自动生成CURD方法</p><p>3、自定义模版代码生成</p><p>4、自定义表单代码生成</p><p>5、审批代码生成</p>', 'Code代码生成器', NULL, '', '降低后端代码开发成本', '[{\"url\":\"blob:http://localhost:8080/00ddf7e2-b231-4faf-875b-bfa12927ef14\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609838011513.png\",\"uid\":1609838011372,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 14:53:19', 0, NULL, '2021-01-05 03:13:33', '57', '2020-11-19 14:53:26', '57', 0);
INSERT INTO `cms_content` VALUES (1329316887084998658, 1329316146811314177, '<p>前端设计辅助工具</p>', 'Designer设计器', NULL, '', '降低前端开发成本，可以直接导出网站模版，也能给前端提供设计布局参考', '[{\"url\":\"blob:http://localhost:8080/201b456f-445d-4e36-9db6-08efc781b7c8\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609837914855.png\",\"uid\":1609837914821,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 14:53:28', 0, NULL, '2021-01-05 03:11:56', '57', '2020-11-19 14:53:38', '57', 0);
INSERT INTO `cms_content` VALUES (1329316951228489729, 1329316146811314177, '<p>提供上百套免费的模版，提供适用好用的插件</p>', 'Store应用市场', NULL, '', '价值源自分享！', '[{\"url\":\"blob:http://localhost:8080/445e83d9-0a51-40e5-865c-94e6da54fb3d\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609836029087.png\",\"uid\":1609836028997,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 14:53:39', 0, NULL, '2021-01-05 02:40:31', '57', '2020-11-19 14:53:53', '57', 0);
INSERT INTO `cms_content` VALUES (1329374638616158210, 1329258628990967809, '<p><br/></p><ul style=\"box-sizing: border-box; margin-bottom: 0.85em; font-size: 14px; padding: 0px 0px 0px 2em; color: rgb(51, 51, 51); font-family: Roboto, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.3px; white-space: normal; background-color: rgb(250, 250, 250);\" class=\" list-paddingleft-2\"><li><p>【框架】增加MybatisPlus支持</p></li><li><p>【新增】静态化文件夹配置(html)</p></li><li><p>【新增】静态化站点文件夹配置(web)，html/1-&gt;自定义/自定义</p></li><li><p>【优化】模版管理修改</p></li><li><p>【优化】标签修改，更灵活的支持if等逻辑判断</p></li><li><p>【优化】解析速度再次提升</p></li><li><p>【优化】栏目管理操作功能优化</p></li><li><p>【优化】栏目生成链接优化，采用拼音格式</p></li><li><p>【修复】bug修复，具体参考开源中国ISSUES</p></li><li><p>5.1升级5.2.0步骤(1、同步代码；2、导入5.1-to-5.2.0-mysql.sql；3、Store更新内容插件)</p></li></ul><p><br/></p>', '5.2.0稳定版本发布', NULL, '', '', '[{\"url\":\"blob:http://localhost:8080/e246f0df-08a8-41e8-9494-17db1970ba0d\",\"name\":\"5.png\",\"path\":\"/upload/1/cms/content/1609825459624.png\",\"uid\":1609825459171,\"status\":\"success\"}]', '', '', '0', 'c', '2020-11-19 18:43:01', 0, 19, '2021-01-04 23:44:21', '57', '2020-11-19 18:43:07', '57', 0);
INSERT INTO `cms_content` VALUES (1329374684459900929, 1329258628990967809, '<p>http://doc.mingsoft.net/plugs-cms/</p>', 'mcms在线适用手册', NULL, '', 'MCms内容插件提供最基本的菜单、权限、角色、栏目、内容、静态化、等常用功能。', '[{\"url\":\"blob:http://localhost:8080/1a5a3605-d831-4123-8c18-de8197aa7295\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609835836996.png\",\"uid\":1609835836971,\"status\":\"success\"}]', '', '', '0', '', '2020-11-19 18:43:10', 0, 9, '2021-01-05 02:37:19', '57', '2020-11-19 18:43:18', '57', 0);
INSERT INTO `cms_content` VALUES (1329374724146405378, 1329258744783118337, '<p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">国内的开源环境已经相当好，但是国内开发注重是应用，创新有但不多，从榜单可以看出，专门搞技术的还是少数，结合项目实践的站大多数，分享给你们，架构的时候可以参考这些解决方案，传送门：gogeeks.cn</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">zheng征项目(stars 5.6k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">基于Spring+SpringMVC+Mybatis分布式敏捷开发系统架构，提供整套公共微服务服务模块：集中权限管理（单点登录）、内容管理、支付中心、用户管理（支持第三方登录）、微信平台、存储系统、配置中心、日志分析、任务和通知等，支持服务治理、监控和追踪，努力为中小型企业打造全方位J2EE企业级开发解决方案。</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000831977.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/shuzheng/zheng</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JFinal(stars 4.8k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JFinal 是基于 Java 语言的极速 WEB + ORM 框架，其核心设计目标是开发迅速、代码量少、学习简单、功能强大、轻量级、易扩展、Restful。在拥有Java语言所有优势的同时再拥有ruby、python、php等动态语言的开发效率！为您节约更多时间，去陪恋人、家人和朋友 :)</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832098.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：http://www.jfinal.com/</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">SpringBoot-Learning(stars 4.6k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">Spring Boot教程与Spring Cloud教程</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/didispace/SpringBoot-Learning</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">iBase4J(stars 4.1k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">AVA分布式快速开发平台：SpringBoot，SpringMVC，Mybatis，mybatis-plus，motan/dubbo分布式，Redis缓存，Shiro权限管理，Spring-Session单点登录，Quartz分布式集群调度，Restful服务，QQ/微信登录，App token登录，微信/支付宝支付；日期转换、数据类型转换、序列化、汉字转拼音、身份证号码验证、数字转人民币、发送短信、发送邮件、加密解密、图片处理、excel导入导出、FTP/SFTP/fastDFS上传下载、二维码、XML读写、高精度计算、系统配置工具类等等。</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832267.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/iBase4J/iBase4J</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JeeSite(stars 3.1k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JeeSite 是一个企业信息化开发基础平台，Java EE（J2EE）快速开发框架，使用经典技术组合（Spring、Spring MVC、Apache Shiro、MyBatis、Bootstrap UI），包括核心模块如：组织机构、角色用户、权限授权、数据权限、内容管理、工作流等。</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/thinkgem/jeesite</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">jeewx(stars 2.6k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">Jeewx是一款开源、免费的微信管家系统（多触点管理平台）。采用JAVA语言，支持微信公众号、微信企业号、支付宝服务窗、QQ公众号、微博账号等多触点管理。Jeewx实现了微信、支付窗、微信企业号、微博等触点的基础管理功能，便于用户二次开发。2014年荣获CSDN开发商大会第一名</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832393.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/jeecg/jeewx</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">MCMS建站系统（stars 2.5k）</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">完整开源！Java快速开发平台！基于Spring、SpringMVC、Mybatis架构，MStore提供更多好用的插件与模板（文章、商城、微信、论坛、会员、评论、支付、积分、工作流、任务调度等，同时提供上百套免费模板任意选择），价值源自分享！铭飞系统不仅一套简单好用的开源系统、更是一整套优质的开源生态内容体系。铭飞的使命就是降低开发成本提高开发效率，提供全方位的企业级开发解决方案，每月28定期更新版本</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832647.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/mingSoft/MCMS</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">t-io(stars 2.3k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">t-io是基于jdk aio实现的易学易用、稳定耐操、性能强悍、将多线程运用到极致、内置功能丰富、核心代码只有3000多行(2017年05月13号统计)的即时通讯框架(广义上的即时通讯，并非指im)，字母 t 寓意talent。</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832783.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/tywo45/t-io</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">CMS(stars 2.1k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">一款使用Java语言开发的CMS，使用了Spring MVC,Spring,MyBatis等流行框架，提供首页大图管理、目录管理、文章管理和管理员管理等功能。是学习和二次开发的首选</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832990.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/shishuo/CMS</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">hutool(stars 2k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">一个Java基础工具类，对文件、流、加密解密、转码、正则、线程、XML等JDK方法进行封装，组成各种Util工具类，同时提供以下组件： 1. 布隆过滤 2. 缓存 3. 数据库ORM（基于ActiveRecord思想）4. HTTP客户端 5. IO 6. JSON 7. 日志 8. System（JVM和系统信息等） 9. Setting（一种扩展Properties的配置文件）</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000833108.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p><br/></p>', '国内最火的10款Java开源项目，都是国人开发，CMS居多', NULL, '', '价值源自分享！铭飞系统不仅一套简单好用的开源系统、更是一整套优质的开源生态内容体系。铭飞的使命就是降低开发成本提高开发效率，提供全方位的企业级开发解决方案，每月28定期更新版本', '[{\"url\":\"/upload/1/cms/content/1609835640813.jpeg\",\"name\":\"a.jpeg\",\"path\":\"/upload/1/cms/content/1609835640813.jpeg\",\"uid\":1609835640738,\"status\":\"success\"}]', '', '', '0', '', '2020-11-19 18:43:23', 0, 21, '2021-01-07 00:27:24', '57', '2020-11-19 18:43:27', '57', 0);
INSERT INTO `cms_content` VALUES (1329374855797219329, 1329259260493766658, '<p style=\"text-align: center;\"><span class=\"title-big\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; text-align: center; overflow-wrap: break-word; display: inline-block;  font-size: 40px; padding-top: 0px; margin-top: 80px; line-height: 28px; text-rendering: optimizelegibility; -webkit-font-smoothing: antialiased; margin-bottom: 24px;\">关于我们</span><span style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; text-align: center; overflow-wrap: break-word; display: inline-block;  font-size: 16px; padding-top: 0px; margin-top: 60px; line-height: 28px;\"></span></p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px; padding: 0px; text-indent: 2em;\">团队成立于2012年，是一群不断的以技术创新与软件研发为核心的学习型技术团队。团队在软件研发的技术领域，不断地积累通用、实用、好用的通用功能插件，实现系统模块化集成开发解决方案。方案适用于传统互联网、移动互联网、物联网，不仅大大降低软件产品在研发投入的成本，更能加快软件的研发进程！</p><p style=\"text-align: center;\"><span class=\"title-big\" style=\"box-sizing: inherit; text-align: center; overflow-wrap: break-word; display: inline-block; text-rendering: optimizelegibility; -webkit-font-smoothing: antialiased; font-family: inherit; padding-bottom: 0px;  font-size: 40px; margin-bottom: 24px; padding-top: 0px; margin-top: 80px;\">使命</span></p><p style=\"text-align: center;\"><span class=\"mission-desc\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; overflow-wrap: break-word; display: inline-block; font-size: 24px; margin-bottom: 0px; padding-top: 0px; margin-top: 0px;\">降低软件研发成本</span></p><p><span class=\"mission-desc\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; overflow-wrap: break-word; display: inline-block; font-size: 24px; margin-bottom: 0px; padding-top: 0px; margin-top: 0px;\"><br/></span></p><p><span class=\"mission-desc\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; overflow-wrap: break-word; display: inline-block; font-size: 24px; margin-bottom: 0px; padding-top: 0px; margin-top: 0px;\"></span></p><table><tbody><tr class=\"firstRow\"><td width=\"427\" valign=\"top\" style=\"word-break: break-all;\"><p><img title=\"\" alt=\"\" src=\"https://www.mingsoft.net/template/1/ms/images/1596450814375.svg\" class=\"img\" style=\"box-sizing: inherit; height: 232.94px; max-width: 100%; width: 380px; margin-top: 0px;\"/></p><p>只要你是Java开发人员，或是前端开发人员、设计人员，都可以使用我们平台提供的服务，开发人员可以使用我们的平台快速生成业务代码，设计人员可以在线分享设计作品获取收益</p></td><td valign=\"top\" style=\"word-break: break-all;\" width=\"426\"><p><img title=\"\" alt=\"\" src=\"https://www.mingsoft.net/template/1/ms/images/1596450883586.svg\" class=\"img\" style=\"box-sizing: inherit; height: 232.94px; max-width: 100%; width: 380px; margin-top: 0px;\"/></p><p>我们能帮助企业快速的进行业务系统开发，不管是从代码质量、效率都会有极大都提升。平台提供的业务都具备协同操作都特性，也能很好的提高与规范企业内部开发协同，帮助企业提高生产离</p></td><td width=\"427\" valign=\"top\" style=\"word-break: break-all;\"><p><img title=\"\" alt=\"\" src=\"https://www.mingsoft.net/template/1/ms/images/1596451227338.svg\" class=\"img\" style=\"box-sizing: inherit; height: 232.94px; max-width: 100%; width: 380px; margin-top: 0px;\"/></p><p>我们给政府事业单位提供优质的技术支持服务，提供更安全、更稳定的核心业务系统架构。通用的组件化开发的模式能满足政府内部日常化管理需求，同时大大降低政府采购的成本</p></td></tr></tbody></table><p><span class=\"mission-desc\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; overflow-wrap: break-word; display: inline-block; font-size: 24px; margin-bottom: 0px; padding-top: 0px; margin-top: 0px;\"></span><br/></p><p><br/></p><p><br/></p><p style=\"text-align: center;\"><span style=\"font-family: inherit; font-size: 40px; text-align: center;\">价值观</span><br/></p><p><span style=\"font-family: inherit; font-size: 40px; text-align: center;\"><br/></span></p><p style=\"text-align: center;\"><span class=\"mission-desc\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; overflow-wrap: break-word; display: inline-block; font-size: 24px; margin-bottom: 0px; padding-top: 0px; margin-top: 0px;\">价值源自分享</span></p><p style=\"text-align: center;\"><span class=\"title-big\" style=\"box-sizing: inherit; text-align: center; overflow-wrap: break-word; display: inline-block; text-rendering: optimizelegibility; -webkit-font-smoothing: antialiased; font-family: inherit; padding-bottom: 0px;  font-size: 40px; margin-bottom: 24px; padding-top: 0px; margin-top: 80px;\">愿景</span></p><p style=\"text-align: center;\"><span class=\"mission-desc\" style=\"box-sizing: inherit; font-family: inherit; padding-bottom: 0px; overflow-wrap: break-word; display: inline-block; font-size: 24px; margin-bottom: 0px; padding-top: 0px; margin-top: 0px;\">享自由、享生活</span></p><p><br/></p>', '公司介绍', NULL, '关键字', '团队成立于2012年，是一群不断的以技术创新与软件研发为核心的学习型技术团队。团队在软件研发的技术领域，不断地积累通用、实用、好用的通用功能插件，实现系统模块化集成开发解决方案。方案适用于传统互联网、移动互联网、物联网，不仅大大降低软件产品在研发投入的成本，更能加快软件的研发进程！', '[{\"url\":\"blob:http://localhost:8080/a409cd5f-ba90-4fba-b8e3-dc0fff0fde0d\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609838258663.png\",\"uid\":1609838258513,\"status\":\"success\"}]', '', '', '0', '', '2020-11-19 18:43:44', 0, NULL, '2021-01-05 03:17:40', '57', '2020-11-19 18:43:59', '57', 0);
INSERT INTO `cms_content` VALUES (1329374891826290690, 1329257594591715329, '<p><span style=\"color: rgb(127, 127, 127);\">TEL：</span>19970180163</p><p><br/></p><p><span style=\"color: rgb(127, 127, 127);\">客服QQ：</span>942770163&nbsp; &nbsp; &nbsp;&nbsp;<span style=\"color: rgb(127, 127, 127);\">商务QQ：</span>3336073455</p><p><br/></p><p><span style=\"color: rgb(127, 127, 127);\">Email：</span>service@mingsoft.net</p><p><br/></p><p><span style=\"color: rgb(127, 127, 127);\">Addr：</span>江西省南昌市南昌高新技术产业开发区紫阳大道2999号紫阳明珠一期办公室楼503室</p><p><br/></p><p><iframe class=\"ueditor_baidumap\" src=\"http://localhost:8080/static/plugins/ueditor/1.4.3.1/dialogs/map/show.html#center=115.674261,28.719996&zoom=10&width=100%&height=340&markers=116.001927,28.681217&markerStyles=l,A\" frameborder=\"0\" width=\"100%\" height=\"344\"></iframe></p>', '联系我们', NULL, '', '', '[]', '', '', '0', '', '2020-11-19 18:44:00', 0, NULL, '2021-01-06 18:52:19', '57', '2020-11-19 18:44:07', '57', 0);
INSERT INTO `cms_content` VALUES (1329375005479346177, 1329357285870346241, '', '降低软件研发成本', '', '', '', '[{\"url\":\"/upload/1/cms/content/1609838691084.png\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609838691084.png\",\"uid\":1609838690980,\"status\":\"success\"}]', 'https://www.mingsoft.net', '', '0', 'f', '2020-11-19 18:44:22', 0, NULL, '2021-05-28 14:30:28', '57', '2020-11-19 18:44:35', '57', 0);
INSERT INTO `cms_content` VALUES (1345970571501940737, 1329257757913718785, '<p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 20px;\"><span style=\"color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.3px; orphans: 3; widows: 3;\"><span style=\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\">包含会员注册、登录、取回密码、个人中心等基本功能</span></span></span></p><hr style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"/><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mpeople\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mpeople.svg?label=Maven%20Central\" width=\"134\" height=\"20\" border=\"0\" vspace=\"0\" title=\"\" alt=\"\" style=\"width: 134px; height: 20px;\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--会员插件--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mpeople&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-people/chapter1.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-people/chapter1.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-people/jie-kou.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-people/jie-kou.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-people/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-people/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-people/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-people/ban-ben-geng-xin-shuo-ming.html</a></p><p><br/></p>', '会员模块', NULL, '免费', '会员注册、会员登录、基本资料、取回密码、修改密码等基本功能', '[{\"url\":\"blob:http://192.168.2.105:8080/082adb39-0491-49ca-a653-b922dea92e54\",\"name\":\"1531101317481.png\",\"path\":\"/upload/1/cms/content/1609739360761.png\",\"uid\":1609739362946,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:48:19', 0, NULL, '2021-05-28 14:30:28', '0', '2021-01-03 23:49:25', '57', 0);
INSERT INTO `cms_content` VALUES (1345971247867015169, 1329257757913718785, '<p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 20px;\"><span style=\"color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.3px; orphans: 3; widows: 3; background-color: rgb(255, 255, 255);\"><span style=\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\">支持对信息的评论，后台查看用户评论的信息，支持对用户评论的筛选。</span></span></span></p><hr style=\"white-space: normal;\"/><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; white-space: normal;\"><br/></p><p style=\"width: 848px; white-space: normal;\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mcomment\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mcomment.svg?label=Maven%20Central\" width=\"134\" height=\"20\" border=\"0\" vspace=\"0\" title=\"\" alt=\"\" style=\"width: 134px; height: 20px;\"/></a></p><pre class=\"brush:xml;toolbar:false\">&lt;!--评论插件依赖--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mcomment&lt;/artifactId&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; white-space: normal;\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; white-space: normal;\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-comment/chapter1/ping-lun-guan-li.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-comment/chapter1/ping-lun-guan-li.html</a></p><p style=\"width: 848px; white-space: normal;\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-comment/jie-kou/peopleceng-jie-kou.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-comment/jie-kou/peopleceng-jie-kou.html</a></p><p style=\"width: 848px; white-space: normal;\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-comment/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-comment/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; white-space: normal;\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-comment/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-comment/ban-ben-geng-xin-shuo-ming.html</a></p><p style=\"width: 848px; white-space: normal;\"><br style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; background-color: rgb(255, 255, 255);\"/></p><p><br/></p>', '评论插件', NULL, '免费', '好信息必须评～', '[{\"url\":\"blob:http://192.168.2.105:8080/9c3a2ce3-fec3-4f4a-b7ab-e5ba16485ffc\",\"name\":\"1531101378470.png\",\"path\":\"/upload/1/cms/content/1609739792665.png\",\"uid\":1609739794931,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:51:37', 0, NULL, '2021-01-03 23:56:33', '57', '2021-01-03 23:52:07', '57', 0);
INSERT INTO `cms_content` VALUES (1345971375898144770, 1329257757913718785, '<p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(51, 51, 51); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 20px; letter-spacing: 0.2px; orphans: 3; widows: 3;\">一套系统管理多个网站的插件，每个网站的数据、权限可以分开进行管理</span><br/></p><hr style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"/><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>Steup 1：打开站群插件详情，点击在线安装，跳转到支付界面进行支付；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：支付成功后，再次进入站群插件详情页面，点击在线安装，根据系统提示下载代码，将下载的代码src文件夹直接复到项目中对应到src文件，选择合并覆盖。由于是源代码所以覆盖完代码后需要手动重新启项目；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 3：项目启动成功后，再次进入站群插件详情页面，点击在线安装，根据提示进行安装；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 4：在线安装完成后，退出当前登录账号（通常是msopen账号），直接使用站群管理员账号(<span style=\"caret-color: rgb(0, 0, 0); font-family: Arial, Helvetica, sans-serif; text-size-adjust: auto;\">账号：adminms 密码：msopen</span>)重新登录后台；</p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">源码</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>请通过赞助方式下载源代码<br/></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-website/chapter1/ying-yong-guan-li.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-website/chapter1/ying-yong-guan-li.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-website/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-website/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-website/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-website/ban-ben-geng-xin-shuo-ming.htm</a></p><p><br/></p>', '站群插件', NULL, '500', '省资源、高效益。MS给你提供完整的站群解决方案＋优质人工服务 更新说明： 1、增加站点停止服务功能 2、增加站点访问日志记录功能', '[{\"url\":\"blob:http://192.168.2.105:8080/17817984-f0e7-4d4d-964b-d85e17128d21\",\"name\":\"1531101138214.png\",\"path\":\"/upload/1/cms/content/1609739781890.png\",\"uid\":1609739784218,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:52:12', 0, NULL, '2021-01-03 23:56:23', '57', '2021-01-03 23:52:38', '57', 0);
INSERT INTO `cms_content` VALUES (1345971507544764417, 1329257757913718785, '<p style=\"width: 848px;\"><span style=\"background-color: rgb(255, 255, 255); color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; font-size: 20px; letter-spacing: 0.3px; orphans: 3; widows: 3;\"><span style=\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\">微信插件是最近后台系统更新上线的一个系统功能，微信插件可管理多个微信号，进行自定义菜单、编辑图文消息、群发功能和关注回复、被动回复、关键字回复功能。</span></span><br/></p><hr/><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; white-space: normal;\">当前版本</p><p style=\"width: 848px; white-space: normal;\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mweixin\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mweixin.svg?label=Maven%20Central\" width=\"134\" height=\"20\" title=\"\" alt=\"\"/></a></p><pre class=\"brush:xml;toolbar:false\">&lt;!--&nbsp;微信插件--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;ms-mweixin&lt;/artifactId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;\n&lt;!--&nbsp;微信公众号第三方插件&nbsp;--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;com.github.binarywang&lt;/groupId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;weixin-java-mp&lt;/artifactId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;3.6.0&lt;/version&gt;\n&lt;/dependency&gt;\n&lt;!--&nbsp;微信公众号公共包第三方插件&nbsp;--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;com.github.binarywang&lt;/groupId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;weixin-java-common&lt;/artifactId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;3.6.0&lt;/version&gt;\n&lt;/dependency&gt;\n&lt;!--&nbsp;微信公众号支付第三方插件&nbsp;--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;com.github.binarywang&lt;/groupId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;weixin-java-pay&lt;/artifactId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;3.6.0&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; white-space: normal;\"><span style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; white-space: normal;\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-weixin/hou-tai-shi-yong/gong-zhong-hao-guan-li.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-weixin/hou-tai-shi-yong/gong-zhong-hao-guan-li.html</a></p><p style=\"width: 848px; white-space: normal;\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-weixin/jie-kou/wei-xin-pei-zhi-ru-kou.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-weixin/jie-kou/wei-xin-pei-zhi-ru-kou.html</a></p><p style=\"width: 848px; white-space: normal;\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-weixin/chang-jian-wen-ti/zen-yao-pei-zhi-wei-xin.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-weixin/chang-jian-wen-ti/zen-yao-pei-zhi-wei-xin.html</a></p><p style=\"width: 848px; white-space: normal;\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-weixin/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-weixin/ban-ben-geng-xin-shuo-ming.html</a></p><p style=\"width: 848px; white-space: normal;\"><br/></p><p><br/></p>', '微信插件', '', '免费', '可管理多个微信号，微信的基本功能、关注回复、自定义菜单、图文消息、群发功能、自动回复等', '[{\"url\":\"/upload/1/cms/content/1609739587867.png\",\"name\":\"1531101341729.png\",\"path\":\"/upload/1/cms/content/1609739587867.png\",\"uid\":1609739590109,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:52:49', 0, NULL, '2021-10-20 23:31:38', '57', '2021-01-03 23:53:09', '57', 0);
INSERT INTO `cms_content` VALUES (1345972513561161729, 1329257757913718785, '<p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; font-size: 20px; letter-spacing: 0.3px; orphans: 3; widows: 3;\"><span style=\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\">关注插件可以满足常见的业务场景如收藏、赞、顶、踩、关注等。</span></span></p><hr style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"/><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mattention\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mattention.svg?label=Maven%20Central\" width=\"134\" height=\"20\" border=\"0\" vspace=\"0\" title=\"\" alt=\"\" style=\"width: 134px; height: 20px;\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--关注插件依赖--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mattention&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">源码</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\">https://github.com/ming-soft/ms-mattention</span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.ms.mingsoft.net/plugs-attention/chapter1.html\" target=\"_blank\">http://doc.ms.mingsoft.net/plugs-attention/chapter1.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-attention/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-attention/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-attention/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-attention/ban-ben-geng-xin-shuo-ming.html</a></p><p><br/></p>', '关注插件', NULL, '免费', '收藏、赞、顶、踩、关注等实现的通用功能，可以根据实际业务需求定义各种类型', '[{\"url\":\"blob:http://192.168.2.105:8080/b3eda44e-65a5-4e0a-be2a-b6d82d41022f\",\"name\":\"1531101476723.png\",\"path\":\"/upload/1/cms/content/1609739824520.png\",\"uid\":1609739826900,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:56:41', 0, NULL, '2021-10-20 23:31:38', '0', '2021-01-03 23:57:09', '57', 0);
INSERT INTO `cms_content` VALUES (1345972716284456962, 1329257757913718785, '<p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 20px;\"><span style=\"color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.3px; orphans: 3; widows: 3;\"><span style=\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\">包含自定义字典、自定义搜索、自定义模型、自定义表单、自定义页面等功能</span></span></span></p><hr style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"/><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mdiy\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mdiy.svg?label=Maven%20Central\" width=\"134\" height=\"20\" border=\"0\" vspace=\"0\" title=\"\" alt=\"\" style=\"width: 134px; height: 20px;\"/></a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--自定义插件--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mdiy&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">源码</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\">https://github.com/ming-soft/ms-mdiy</span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-diy/chapter1/zi-ding-yi-zi-dian.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-diy/chapter1/zi-ding-yi-zi-dian.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-diy/jie-kou/zi-dian-lie-biao.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-diy/jie-kou/zi-dian-lie-biao.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-diy/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-diy/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-diy/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-diy/ban-ben-geng-xin-shuo-ming.html</a></p><p><br/></p>', '自定义插件', NULL, '免费', '最基本到应用管理系统，包含菜单、权限、角色、栏目、内容、静态化、自定义等常用功能', '[{\"url\":\"blob:http://192.168.2.105:8080/4a5bcfce-4763-4f8b-9725-8e41b8b7642a\",\"name\":\"1531101439974.png\",\"path\":\"/upload/1/cms/content/1609739871146.png\",\"uid\":1609739873416,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:57:14', 0, NULL, '2021-10-20 23:31:38', '0', '2021-01-03 23:57:57', '57', 0);
INSERT INTO `cms_content` VALUES (1345972904663232513, 1329257757913718785, '<p style=\"width: 848px;\"><span style=\"background-color: rgb(255, 255, 255); color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; font-size: 20px; letter-spacing: 0.3px; orphans: 3; widows: 3;\"><span style=\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\">支持通过邮件、短信方式进行消息推送，也支持第三方平台sendcloud</span></span></p><hr style=\"white-space: normal;\"/><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; white-space: normal;\">当前版本</p><p style=\"width: 848px; white-space: normal;\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-msend\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-msend.svg?label=Maven%20Central\" width=\"134\" height=\"20\" border=\"0\" vspace=\"0\" title=\"\" alt=\"\" style=\"width: 134px; height: 20px;\"/></a></p><pre class=\"brush:xml;toolbar:false\">&lt;!--&nbsp;ms-msend发送模块源码&nbsp;--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;ms-msend&lt;/artifactId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; white-space: normal;\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; white-space: normal;\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-send/hou-tai-shi-yong/duan-xin-pei-zhi.html\" target=\"_blank\">http://doc.ms.mingsoft.net/plugs-send/hou-tai-shi-yong/duan-xin-pei-zhi.html</a></p><p style=\"width: 848px; white-space: normal;\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-send/qian-duan-shi-yong/sendutil.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-send/qian-duan-shi-yong/sendutil.html</a></p><p style=\"width: 848px; white-space: normal;\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-send/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-send/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; white-space: normal;\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-send/ban-ben.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-send/ban-ben.html</a></p><p style=\"width: 848px; white-space: normal;\"><br style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; background-color: rgb(255, 255, 255);\"/></p><p><br/></p>', '发送插件', NULL, '免费', '邮件发送、短信发送模块，用户只需要配置相关短信模板即可使用', '[{\"url\":\"blob:http://localhost:8080/87e42125-9221-425f-b911-549a060128c0\",\"name\":\"1.png\",\"path\":\"/upload/1/cms/content/1609742916205.png\",\"uid\":1609742916109,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:58:02', 0, NULL, '2021-01-04 00:48:38', '57', '2021-01-03 23:58:42', '57', 0);
INSERT INTO `cms_content` VALUES (1345973065812586497, 1329257757913718785, '<p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 20px;\"><span style=\"color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.3px; orphans: 3; widows: 3; background-color: rgb(255, 255, 255);\">通用的支付插件，目前支持微信、支付宝两种支付场景、支持交易日志记录查看</span></span></p><hr/><p style=\"width: 848px;\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px;\"><span style=\"font-size: 18px;\"></span></p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px;\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px;\"><br/></p><p style=\"width: 848px;\">当前版本</p><p style=\"width: 848px; white-space: normal;\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mpay\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mpay.svg?label=Maven%20Central\" width=\"134\" height=\"20\" border=\"0\" vspace=\"0\" title=\"\" alt=\"\" style=\"width: 134px; height: 20px;\"/></a></p><pre class=\"brush:xml;toolbar:false\">&lt;!--支付插件--&gt;\n&lt;dependency&gt;\n&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&lt;artifactId&gt;ms-mpay&lt;/artifactId&gt;\n&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px;\"><span data-key=\"154\" style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; white-space: normal;\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-pay/3cha-jian-de-hou-tai-shi-yong/wei-xin-zhi-fu-she-zhi.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-pay/3cha-jian-de-hou-tai-shi-yong/wei-xin-zhi-fu-she-zhi.html</a></p><p style=\"width: 848px; white-space: normal;\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-pay/4qian-duan-jie-kou-shi-yong/wang-guan-jie-kou.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-pay/4qian-duan-jie-kou-shi-yong/wang-guan-jie-kou.html</a></p><p style=\"width: 848px; white-space: normal;\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-pay/chang-jian-wen-ti.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-pay/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; white-space: normal;\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-pay/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-pay/ban-ben-geng-xin-shuo-ming.html</a></p><p style=\"width: 848px; white-space: normal;\"><br style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; background-color: rgb(255, 255, 255);\"/></p><p><br/></p>', '支付交易', NULL, '免费', '用户可以自由配置支付宝、微信支付的交易账号', '[{\"url\":\"blob:http://192.168.2.105:8080/eb51577a-c191-45b4-8519-e6c14fcf32f1\",\"name\":\"1531101172093.png\",\"path\":\"/upload/1/cms/content/1609739953632.png\",\"uid\":1609739955791,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:58:59', 0, NULL, '2021-10-20 23:31:38', '0', '2021-01-03 23:59:21', '57', 0);
INSERT INTO `cms_content` VALUES (1345973172616343553, 1329257757913718785, '<p style=\"width: 820px;\"><span style=\"font-size: 20px;\">最干净、最简单的内容管理插件，包含菜单、权限、角色、栏目、内容、静态化、等常用功能</span></p><hr/><blockquote style=\"box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\"></span></h2><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">源码</span></h2></blockquote><p style=\"width: 820px;\"><a href=\"https://gitee.com/mingSoft/MCMS\" target=\"_blank\">https://gitee.com/mingSoft/MCMS</a></p><p style=\"width: 820px;\"><a href=\"https://github.com/ming-soft/MCMS\" target=\"_blank\">https://github.com/ming-soft/MCMS</a></p><blockquote style=\"box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 820px;\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-cms/quan-xian-guan-li/guan-li-yuan-guan-li.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-cms/quan-xian-guan-li/guan-li-yuan-guan-li.html</a><br/></p><p style=\"width: 820px;\">标签手册：<a href=\"http://doc.mingsoft.net/plugs-cms/biao-qian/jie-shao.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-cms/biao-qian/jie-shao.html</a></p><p style=\"width: 820px;\">模版制作：<a href=\"http://doc.mingsoft.net/plugs-cms/mo-ban-zhi-zuo/pcduan-mo-ban-zhi-zuo.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-cms/mo-ban-zhi-zuo/pcduan-mo-ban-zhi-zuo.html</a></p><p style=\"width: 820px;\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-cms/jie-kou/wen-zhang-lie-biao-xin-xi.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-cms/jie-kou/wen-zhang-lie-biao-xin-xi.html</a></p><p style=\"width: 820px;\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-cms/chang-jian-wen-ti/biao-qian-shi-yong.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-cms/chang-jian-wen-ti/biao-qian-shi-yong.html</a></p><p style=\"width: 820px;\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-cms/ban-ben.html\" target=\"_blank\">http://doc.mingsoft.net/plugs-cms/ban-ben.html</a></p><p style=\"width: 820px;\">BUG提交：<a href=\"https://gitee.com/mingSoft/MCMS/issues\" target=\"_blank\">https://gitee.com/mingSoft/MCMS/issues</a></p><p style=\"width: 820px;\"><br/></p><p><br/></p>', '内容插件', NULL, '免费', '内容升级包补丁，修复功能权限控制', '[{\"url\":\"blob:http://localhost:8080/a7cec28a-a49b-437b-ba46-f8b4e62fa79c\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609837531913.png\",\"uid\":1609837531865,\"status\":\"success\"}]', '', '', '0', '', '2021-01-03 23:59:35', 0, NULL, '2021-01-05 03:05:33', '57', '2021-01-03 23:59:46', '57', 0);
INSERT INTO `cms_content` VALUES (1345973329424592897, 1329257757913718785, '<p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 20px;\">目前最完整的城市数据库，精确到乡镇村&nbsp;</span></p><hr style=\"white-space: normal;\"/><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\"></span></h2><h2 id=\"103-snapshot\"><span style=\"font-size: 18px;\">安装方式</span></h2></blockquote><p style=\"width: 848px;\">由于城市数据文件比较大，约90M，所以提供在线SQL文件下载，需要手动导入数据库，推荐使用source指令导入方式。</p><pre class=\"brush:sql;toolbar:false\">mysql&gt;use&nbsp;数据名称;\nmysql&gt;source&nbsp;路径/city.sql;</pre><p style=\"width: 848px;\">城市数据接口读取方式参考代码生成器中的城市组件，特别说明：商城插件、运费插件、会员插件等用以后用到城市数据的插件都必须导入城市数据，否则会因缺少城市数据导致业务流程失败。</p><p style=\"width: 848px;\"><br style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><br/></p>', '城市数据', NULL, '免费', '通用城市数据，不定期会更新', '[{\"url\":\"/upload/1/cms/content/1609740022739.png\",\"name\":\"1535532192568.png\",\"path\":\"/upload/1/cms/content/1609740022739.png\",\"uid\":1609740024570,\"status\":\"success\"}]', '', '', '0', '', '2021-01-04 00:00:11', 0, NULL, '2021-01-04 18:26:06', '57', '2021-01-04 00:00:23', '57', 0);
INSERT INTO `cms_content` VALUES (1346299650146922497, 1329258744783118337, '<p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">下面我们开始分享一下开源中国中最火的Java开源CMS建站系统（代码可以到gitee.com中下载 搜一下项目名称）</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\">　　（1）铭飞 / MCMS（开发人/项目名称）</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 1800 star 3400 fork 1800</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　完整开源！Java快速开发平台！基于Spring、SpringMVC、Mybatis架构，MStore提供更多好用的插件与模板（文章、商城、微信、论坛、会员、评论、支付、积分、工作流、任务调度等，同时提供上百套免费模板任意选择），价值源自分享！铭飞系统不仅一套简单好用的开源系统、更是一整套优质的开源生态内容体系。铭飞的使命就是降低开发成本提高开发效率，提供全方位的企业级开发解决方案。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　核心框架：Spring Framework 4</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　安全框架：Apache Shiro 1.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　视图框架：Spring MVC 4</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　任务调度：Spring Task 4</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　持久层框架：MyBatis 3</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　数据库连接池：Alibaba Druid 1.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　日志管理：SLF4J 1.7、Log4j</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　JS框架：jQuery 1.10</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　CSS框架：Twitter Bootstrap 2.3.1。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　富文本：Ueditor</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932423.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932622.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　<span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\">　（2）Fly的狐狸 / jfinal_cms</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 713 star 1417 fork 822</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　jfinal cms是一个java开发的功能强大的信息咨询网站，采用了简洁强大的JFinal作为web框架，模板引擎用的是beetl，数据库用mysql，前端bootstrap框架。 支持oauth2认证、帐号注册、密码加密、评论及回复，消息提示，网站访问量统计，文章评论数和浏览量统计，回复管理，支持权限管理。 后台模块包含：栏目管理，栏目公告，栏目滚动图片，文章管理，回复管理，意见反馈，我的相册，相册管理，图片管理，专辑管理、视频管理、缓存更新，友情链接，访问统计，联系人管理，模板管理，组织机构管理，用户管理，角色管理，菜单管理，数据字典管理。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　jfinal cms，采用了简洁强大的JFinal作为web框架，模板引擎用的是beetl，数据库用mysql，前端bootstrap框架。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　后台模块包含：栏目管理，栏目公告，栏目滚动图片，文章管理，回复管理，意见反馈，我的相册，相册管理，图片管理，专辑管理，视频管理，缓存更新，友情链接，访问统计，联系人管理，模板管理，组织机构管理，用户管理，角色管理，菜单管理，参数配置，数据字典管理。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　后端模板支持：bootstrap默认样式、bootstrap黑色样式和flat-ui样式</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　前端模板支持：默认内容发布、官网模板、图片模板和视频模板</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932670.gif\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932808.gif\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">　　（3）kerneler / PublicCMS</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 382 star 726 fork 370</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　PublicCMS是采用2018年最新主流技术开发的开源JAVACMS系统。架构科学，轻松支持上千万数据、千万PV；支持全站静态化，SSI，动态页面局部静态化等为您快速建站，建设大规模站点提供强大驱动，也是企业级项目产品原型的良好选择。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932910.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932970.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932989.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　<span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">（4）付苗 / 51opencms</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 181 star 370 fork 133</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　youngcms采用spring mvc ,mybatis,freemaker，mysql等技术开发完成,我们正在采用dubbo,activeMq消息队列，redis等技术进行全新的架构</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933017.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933033.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933052.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">　　（5）jeffxu / tianti天梯</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 156 star 345 fork 174</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　java轻量级的CMS系统-天梯。天梯是一个用java相关技术搭建的后台CMS解决方案，用户可以结合自身业务进行相应扩展，同时提供了针对dao、service等的代码生成工具。技术选型：Spring Data JPA、Hibernate、Shiro、 Spring MVC、Layer、Mysql等。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　核心框架：Spring Framework 4.2.5.RELEASE</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·安全框架：Apache Shiro 1.3.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·视图框架：Spring MVC 4.2.5.RELEASE</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·数据库连接池：Tomcat JDBC</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·缓存框架：Ehcache</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·ORM框架：Spring Data JPA、hibernate 4.3.5.Final</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·日志管理：SLF4J 1.7.21、Log4j</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·编辑器：ueditor</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·工具类：Apache Commons、Jackson 2.8.5、POI 3.15</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·view层：JSP</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·数据库：mysql、oracle等关系型数据库</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·dom : Jquery</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·分页 : jquery.pagination</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·UI管理 : common</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·UI集成 : uiExtend</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·滚动条 : jquery.nicescroll.min.js</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·图表 ： highcharts</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·3D图表 ：highcharts-more</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·轮播图 ： jquery-swipe</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·表单提交 ：jquery.form</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·文件上传 ：jquery.uploadify</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·表单验证 ：jquery.validator</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·展现树 ：jquery.ztree</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·html模版引擎 ：template</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933075.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933116.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933143.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">　　（6）SeeYoui / kensite_cms</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 197 star 320 fork 135</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　KenSite是基于多个优秀的开源项目，高度整合封装而成的高效，高性能，强安全性的开源Java EE快速开发平台。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　KenSite本身是以Spring Framework为核心容器，Spring MVC为模型视图控制器，MyBatis为数据访问层， Apache Shiro为权限授权层，Ehcahe对常用数据进行缓存，Quartz为定时任务计划管理。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　KenSite 提供了常用工具进行封装，包括日志工具、缓存工具、服务器端验证、数据字典、当前组织机构数据以及其它常用小工具等。另外还提供一个强大的在线&nbsp;代码生成&nbsp;工具，直接生成controller、service、domain、mapper、mybatis xml、jsp等文件， 前端显示基于easyui，一键生成就可以直接使用包括新增修改删除等常规操作。 如果你使用了KenSite基础框架，就可以很高效的快速开发出，优秀的信息管理系统。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　核心框架：Spring Framework 4.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　安全框架：Apache Shiro 1.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　视图框架：Spring MVC 4.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　服务端验证：Hibernate Validator 5.1</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　定时任务计划：Quartz</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　流程引擎：activiti 5.21.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　持久层框架：MyBatis 3.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　数据库连接池：Alibaba Druid 1.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　缓存框架：Ehcache 2.6、Redis</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　日志管理：SLF4J 1.7、Log4j</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　全文检索：lucene</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　验证码：patchca</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　WebService：CXF webservice</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　工具类：Apache Commons、Jackson 2.2、Xstream 1.4、Dozer 5.3、POI 3.9</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　JS框架：jQuery 1.9</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　CSS框架：Twitter Bootstrap 2.3.1</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　前端组件：easyui</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　客户端验证：JQuery Validation Plugin 1.11</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　富文本：Ueditor</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　对话框：layer、jquery-ui</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　上传空间：uploadify</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　树结构控件：jQuery zTree</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　日期控件： My97DatePicker</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　web excel插件：handsontable</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　统计图表：echarts</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933178.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933214.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933236.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p><br/></p>', '【网站】国内 前6名 Java开源CMS建站系统', NULL, '', '下面我们开始分享一下开源中国中最火的Java开源CMS建站系统', '[{\"url\":\"/upload/1/cms/content/1609835629433.jpeg\",\"name\":\"a.jpeg\",\"path\":\"/upload/1/cms/content/1609835629433.jpeg\",\"uid\":1609835629283,\"status\":\"success\"}]', '', '', '0', '', '2021-01-04 21:33:50', 0, 2, '2021-01-07 00:28:55', '57', '2021-01-04 21:37:04', '57', 0);
INSERT INTO `cms_content` VALUES (1346302136240926721, 1329258744783118337, '<h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\">特点</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>免费完整开源：基于MIT协议，源代码完全开源，无商业限制,MS开发团队承诺将MCMS内容系统永久完整开源；</p></li><li><p>标签化建站：不需要专业的后台开发技能，只要使用系统提供的标签，就能轻松建设网站；</p></li><li><p>html静态化：系统支持全站静态化；</p></li><li><p>跨终端：站点同时支持PC与移动端访问，同时会自动根据访问的终端切换到对应的界面，数据由系统统一管理；</p></li><li><p>海量模版：铭飞通过MStore（MS商城）分享更多免费、精美的企业网站模版，降低建站成本；</p></li><li><p>丰富插件：为了让MCms适应更多的业务场景，在MStore用户可以下载对应的插件，如：站群插件、微信插件、商城插件等；</p></li><li><p>每月更新：铭飞团队承诺每月28日为系统升级日，分享更多好用等模版与插件；</p></li><li><p>文档丰富：为了让用户更快速的使用MCms系统进行开发，铭飞团队持续更新开发相关文档，如标签文档、使用文档、视频教程等；</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"面向对象_3\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E9%9D%A2%E5%90%91%E5%AF%B9%E8%B1%A1_3\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>面向对象</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>铭飞MCMS是企业在创立初期很好的技术基础框架，加快公司项目开发进度，当然也可以对现有的系统进行升级；</p></li><li><p>个人开发者也可以使用MCMS承接外包项目；</p></li><li><p>初学JAVA的同学可以下载源代码来进行学习交流；</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"技术框架_4\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E6%8A%80%E6%9C%AF%E6%A1%86%E6%9E%B6_4\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>技术框架</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>核心框架：Spring Framework 4</p></li><li><p>安全框架：Apache Shiro 1.2</p></li><li><p>视图框架：Spring MVC 4</p></li><li><p>任务调度：Spring Task 4</p></li><li><p>持久层框架：MyBatis 3</p></li><li><p>数据库连接池：Alibaba Druid 1.0</p></li><li><p>日志管理：SLF4J 1.7、Log4j</p></li><li><p>JS框架：jQuery 1.10</p></li><li><p>CSS框架：Twitter Bootstrap 2.3.1。</p></li><li><p>富文本：Ueditor</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"系统结构_5\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E7%B3%BB%E7%BB%9F%E7%BB%93%E6%9E%84_5\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>系统结构</h1><p style=\"margin: 10px auto; padding: 0px; line-height: 1.5;\"><img class=\"md_relative_url\" title=\"在这里输入图片标题\" src=\"/ueditor/jsp/upload/image/20210105/1609818395900070630.jpg\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"开发环境_6\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E5%BC%80%E5%8F%91%E7%8E%AF%E5%A2%83_6\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>开发环境</h1><p style=\"margin: 10px auto; padding: 0px; line-height: 1.5;\">建议开发者使用以下环境，这样避免版本带来的问题</p><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>IDE:eclipse</p></li><li><p>DB:Mysql5.5</p></li><li><p>JDK:JAVA 7、J2EE6</p></li><li><p>WEB:Tomcat8</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"运行环境_7\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E8%BF%90%E8%A1%8C%E7%8E%AF%E5%A2%83_7\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>运行环境</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>WEB服务器：Weblogic、Tomcat、WebSphere、JBoss、Jetty 等</p></li><li><p>数据库服务器：Mysql5.5</p></li><li><p>操作系统：Windows、Linux、Unix 等</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"快速体验_8\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E5%BF%AB%E9%80%9F%E4%BD%93%E9%AA%8C_8\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>快速体验</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>将MCMS项目源码导入eclipse；</p></li><li><p>创建数据库db-mcms-open,注意：数据库使用utf-8编码，导入doc/db-mcms-open.sql备份文件；</p></li><li><p>修改src\\main\\resources\\ms.properties文件中的数据库设置参数；</p></li><li><p>第一次启动必须先访问后台，后台访问地址：http://+ip地址（或localhost）:tomcat端口/项目发布名/ms/login.do 必需先访问后台界面再访问前台界面</p></li><li><p>前台访问地址：<a href=\"http://xn--ip%28localhost%29-4v7w4gy75n:tomcat%E7%AB%AF%E5%8F%A3/%E9%A1%B9%E7%9B%AE%E5%8F%91%E5%B8%83%E5%90%8D\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ip地址（或localhost）:tomcat端口/项目发布名</a>,如果发布的地址不是<a href=\"http://localhost:8080/mcms\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://localhost:8080/mcms</a>，先在后台生成静态页面再进行访问</p></li><li><p>管理员账号，用户名：msopen 密码：msopen</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"文件说明_9\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E6%96%87%E4%BB%B6%E8%AF%B4%E6%98%8E_9\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>文件说明</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>.externalToolBuilders eclipse缓存文件</p></li><li><p>.settings eclipse配置缓存文件</p></li><li><p>doc 项目文档文件夹，里面有数据库文件</p></li><li><p>src/main maven结构的项目源代码</p></li><li><p>java/com/mingsoft java源代码文件</p></li><li><p>resources 项目的资源配置文件</p></li><li><p>webapp<br style=\"margin: 0px; padding: 0px;\"/>META-INF&nbsp;<br style=\"margin: 0px; padding: 0px;\"/>WEB-INF&nbsp;<br style=\"margin: 0px; padding: 0px;\"/>manager&nbsp;<br style=\"margin: 0px; padding: 0px;\"/>html/1 默认生成的静态代码，实际项目需要删除，只是提供给开发者快速预览生成后的静态页面<br style=\"margin: 0px; padding: 0px;\"/>templets/1/mooc 默认模版<br style=\"margin: 0px; padding: 0px;\"/>upload&nbsp;</p></li><li><p>target 临时文件，可以删除让maven自动生成</p></li><li><p>.classpath eclipse配置缓存文件</p></li><li><p>.project eclipse配置缓存文件</p></li><li><p>LICENSE 项目协议说明</p></li><li><p>README.md 项目说明文档</p></li><li><p>pom.xml maven的依赖配置文件</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"代码部署与常见问题_10\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E4%BB%A3%E7%A0%81%E9%83%A8%E7%BD%B2%E4%B8%8E%E5%B8%B8%E8%A7%81%E9%97%AE%E9%A2%98_10\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>代码部署与常见问题</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>铭飞MCms 部署视频&nbsp;<a href=\"http://ms.mingsoft.net/mbbs/13988/detail.do\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ms.mingsoft.net/mbbs/13988/detail.do</a></p></li><li><p>MCms环境配置常见问题&nbsp;<a href=\"http://ms.mingsoft.net/mbbs/13000/detail.do\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ms.mingsoft.net/mbbs/13000/detail.do</a></p></li><li><p>MStore使用方式：<a href=\"http://ms.mingsoft.net/mbbs/13008/detail.do\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ms.mingsoft.net/mbbs/13008/detail.do</a></p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"开源说明_11\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E5%BC%80%E6%BA%90%E8%AF%B4%E6%98%8E_11\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>开源说明</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>系统100%开源</p></li><li><p>铭飞MCms是铭飞MS平台的一个子模块，同时铭飞MCms所依赖的模块都是用maven方式提供了源码获取方式,具体看pom.xml文件的&lt;!-- MAVEN源码加载 --&gt;部分</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"系统美图_12\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E7%B3%BB%E7%BB%9F%E7%BE%8E%E5%9B%BE_12\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>系统美图</h1><p style=\"margin: 10px auto; padding: 0px; line-height: 1.5;\"><img class=\"md_relative_url\" title=\"铭飞模版商城，模版商城\" src=\"/ueditor/jsp/upload/image/20210105/1609818396224099515.jpg\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/><br style=\"margin: 0px; padding: 0px;\"/><img class=\"md_relative_url\" title=\"铭飞模版商城，插件商城\" src=\"/ueditor/jsp/upload/image/20210105/1609818396728044765.png\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/><br style=\"margin: 0px; padding: 0px;\"/><img class=\"md_relative_url\" title=\"铭飞内容管理系统后台演示\" src=\"/ueditor/jsp/upload/image/20210105/1609818396886062056.png\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p><br/></p>', '铭飞MCMS内容管理系统完整开源版J2EE代码', '', '', '官网同时提供一键运行版本下载，请步移官网....', '[{\"url\":\"/upload/1/cms/content/1609835614568.jpeg\",\"name\":\"a.jpeg\",\"path\":\"/upload/1/cms/content/1609835614568.jpeg\",\"uid\":1609835614464,\"status\":\"success\"}]', '', '', '0', '', '2021-01-04 21:46:14', 0, 7, '2021-03-26 08:36:09', '57', '2021-01-04 21:46:57', '57', 0);
COMMIT;

-- ----------------------------
-- Table structure for cms_history_log
-- ----------------------------
DROP TABLE IF EXISTS `cms_history_log`;
CREATE TABLE `cms_history_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` bigint(20) unsigned NOT NULL COMMENT '文章编号',
  `people_id` int(20) DEFAULT NULL COMMENT '用户id',
  `hl_ip` varchar(255) DEFAULT NULL COMMENT '浏览ip',
  `hl_is_mobile` varchar(255) DEFAULT NULL COMMENT '是否为移动端',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文章浏览记录';

-- ----------------------------
-- Records of cms_history_log
-- ----------------------------
BEGIN;
INSERT INTO `cms_history_log` VALUES (1, 1329374724146405378, NULL, '127.0.0.1', '0', NULL, NULL, '2021-05-28 16:32:32', NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for logger
-- ----------------------------
DROP TABLE IF EXISTS `logger`;
CREATE TABLE `logger` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log_error_msg` text COMMENT '错误消息',
  `log_result` text COMMENT '返回参数',
  `log_param` text COMMENT '请求参数',
  `log_location` varchar(255) DEFAULT NULL COMMENT '所在地区',
  `log_user` varchar(255) DEFAULT NULL COMMENT '操作人员',
  `log_user_type` varchar(255) DEFAULT NULL COMMENT '用户类型',
  `log_business_type` varchar(255) DEFAULT NULL COMMENT '业务类型',
  `log_status` varchar(255) DEFAULT NULL COMMENT '请求状态',
  `log_url` varchar(255) DEFAULT NULL COMMENT '请求地址',
  `log_request_method` varchar(255) DEFAULT NULL COMMENT '请求方式',
  `log_method` varchar(255) DEFAULT NULL COMMENT '请求方法',
  `log_ip` varchar(255) DEFAULT NULL COMMENT 'IP',
  `log_title` varchar(255) DEFAULT NULL COMMENT '标题',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统日志';

-- ----------------------------
-- Records of logger
-- ----------------------------
BEGIN;
INSERT INTO `logger` VALUES (1, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '127.0.0.1', '生成主页', NULL, NULL, '2021-09-27 21:50:16', NULL, 0);
INSERT INTO `logger` VALUES (2, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate/0/genernateColumn.do', 'GET', 'net.mingsoft.cms.action.GeneraterAction.genernateColumn()', '127.0.0.1', '生成栏目', NULL, NULL, '2021-09-27 21:50:41', NULL, 0);
INSERT INTO `logger` VALUES (3, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"dateTime\":[\"2019-09-15\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate/0/generateArticle.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateArticle()', '127.0.0.1', '生成文章', NULL, NULL, '2021-09-27 21:50:43', NULL, 0);
INSERT INTO `logger` VALUES (4, NULL, '{\n	\"result\":true,\n	\"code\":200,\n	\"data\":{\n		\"id\":\"1345971507544764417\"\n	}\n}', '{\n	\"createBy\":[\"57\"],\n	\"createDate\":[\"2021-01-03 23:53:09\"],\n	\"del\":[\"0\"],\n	\"id\":[\"1345971507544764417\"],\n	\"remarks\":[\"\"],\n	\"updateBy\":[\"0\"],\n	\"updateDate\":[\"\"],\n	\"order\":[\"\"],\n	\"contentTitle\":[\"微信插件\"],\n	\"categoryId\":[\"1329257757913718785\"],\n	\"contentType\":[\"\"],\n	\"contentDisplay\":[\"0\"],\n	\"contentAuthor\":[\"\"],\n	\"contentSource\":[\"\"],\n	\"contentDatetime\":[\"2021-01-03 23:52:49\"],\n	\"contentSort\":[\"0\"],\n	\"contentImg\":[\"[{\\\"url\\\":\\\"/upload/1/cms/content/1609739587867.png\\\",\\\"name\\\":\\\"1531101341729.png\\\",\\\"path\\\":\\\"/upload/1/cms/content/1609739587867.png\\\",\\\"uid\\\":1609739590109,\\\"status\\\":\\\"success\\\"}]\"],\n	\"contentDescription\":[\"可管理多个微信号，微信的基本功能、关注回复、自定义菜单、图文消息、群发功能、自动回复等\"],\n	\"contentKeyword\":[\"免费\"],\n	\"contentDetails\":[\"<p style=\\\"width: 848px;\\\"><span style=\\\"background-color: rgb(255, 255, 255); color: rgb(51, 51, 51); font-family: Roboto, &quot;helvetica neue&quot;, Helvetica, Arial, sans-serif; font-size: 20px; letter-spacing: 0.3px; orphans: 3; widows: 3;\\\"><span style=\\\"font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px;\\\">微信插件是最近后台系统更新上线的一个系统功能，微信插件可管理多个微信号，进行自定义菜单、编辑图文消息、群发功能和关注回复、被动回复、关键字回复功能。</span></span><br/></p><hr/><p style=\\\"width: 848px; white-space: normal;\\\"><span style=\\\"font-size: 18px;\\\"></span></p><p style=\\\"width: 848px; white-space: normal;\\\"><span style=\\\"font-size: 18px;\\\"></span></p><blockquote style=\\\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\\\"><h2><span style=\\\"font-size: 18px;\\\">安装方法</span></h2></blockquote><p style=\\\"width: 848px; white-space: normal;\\\"><span style=\\\"font-size: 18px;\\\"></span>Steup 1：pom.xml增加依赖，并重启系统</p><p style=\\\"width: 848px; white-space: normal;\\\">当前版本</p><p style=\\\"width: 848px; white-space: normal;\\\"><a target=\\\"_blank\\\" href=\\\"https://search.maven.org/search?q=ms-mweixin\\\"><img src=\\\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mweixin.svg?label=Maven%20Central\\\" width=\\\"134\\\" height=\\\"20\\\" title=\\\"\\\" alt=\\\"\\\"/></a></p><pre class=\\\"brush:xml;toolbar:false\\\">&lt;!--&nbsp;微信插件--&gt;\\n&lt;dependency&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;ms-mweixin&lt;/artifactId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\\n&lt;/dependency&gt;\\n&lt;!--&nbsp;微信公众号第三方插件&nbsp;--&gt;\\n&lt;dependency&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;com.github.binarywang&lt;/groupId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;weixin-java-mp&lt;/artifactId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;3.6.0&lt;/version&gt;\\n&lt;/dependency&gt;\\n&lt;!--&nbsp;微信公众号公共包第三方插件&nbsp;--&gt;\\n&lt;dependency&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;com.github.binarywang&lt;/groupId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;weixin-java-common&lt;/artifactId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;3.6.0&lt;/version&gt;\\n&lt;/dependency&gt;\\n&lt;!--&nbsp;微信公众号支付第三方插件&nbsp;--&gt;\\n&lt;dependency&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;com.github.binarywang&lt;/groupId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;weixin-java-pay&lt;/artifactId&gt;\\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;3.6.0&lt;/version&gt;\\n&lt;/dependency&gt;</pre><p style=\\\"width: 848px; white-space: normal;\\\"><span style=\\\"box-sizing: border-box;\\\"></span></p><p style=\\\"width: 848px; white-space: normal;\\\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\\\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, ', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/content/update.do', 'POST', 'net.mingsoft.cms.action.ContentAction.update()', '127.0.0.1', '更新文章', NULL, NULL, '2021-10-20 23:31:38', NULL, 0);
INSERT INTO `logger` VALUES (5, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"dateTime\":[\"2015-10-05\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate/1329257757913718785/generateArticle.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateArticle()', '127.0.0.1', '生成文章', NULL, NULL, '2021-10-20 23:32:11', NULL, 0);
INSERT INTO `logger` VALUES (6, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', 'XX XX', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '59.53.164.99', '生成主页', NULL, NULL, '2021-10-21 00:23:57', NULL, 0);
INSERT INTO `logger` VALUES (7, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', '江西 南昌', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '59.53.164.99', '生成主页', NULL, NULL, '2021-10-21 00:24:58', NULL, 0);
INSERT INTO `logger` VALUES (8, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '127.0.0.1', '生成主页', NULL, NULL, '2021-10-21 08:37:36', NULL, 0);
INSERT INTO `logger` VALUES (9, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '127.0.0.1', '生成主页', NULL, NULL, '2021-10-21 08:37:40', NULL, 0);
INSERT INTO `logger` VALUES (10, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '127.0.0.1', '生成主页', NULL, NULL, '2021-10-21 08:38:05', NULL, 0);
INSERT INTO `logger` VALUES (11, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '{\n	\"url\":[\"index.htm\"],\n	\"position\":[\"index\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/generate//generateIndex.do', 'POST', 'net.mingsoft.cms.action.GeneraterAction.generateIndex()', '127.0.0.1', '生成主页', NULL, NULL, '2021-10-21 08:38:47', NULL, 0);
INSERT INTO `logger` VALUES (12, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '[\n	{\n		\"categoryDescrip\":\"\",\n		\"categoryDiyUrl\":\"\",\n		\"categoryFlag\":\"nav\",\n		\"categoryImg\":\"[]\",\n		\"categoryKeyword\":\"\",\n		\"categoryListUrl\":\"product-list.htm\",\n		\"categoryPath\":\"/gongsichanpin\",\n		\"categoryPinyin\":\"gongsichanpin\",\n		\"categorySort\":0,\n		\"categoryTitle\":\"公司产品\",\n		\"categoryType\":\"1\",\n		\"categoryUrl\":\"product-detail.htm\",\n		\"createBy\":\"57\",\n		\"createDate\":\"2020-11-19 10:56:31\",\n		\"del\":1,\n		\"flag\":\"nav\",\n		\"id\":\"1397743931070242817\",\n		\"leaf\":false,\n		\"sqlWhereList\":[],\n		\"topId\":\"0\",\n		\"typedescrip\":\"\",\n		\"typeid\":\"1397743931070242817\",\n		\"typekeyword\":\"\",\n		\"typeleaf\":false,\n		\"typelink\":\"/gongsichanpin/index.html\",\n		\"typelitpic\":\"[]\",\n		\"typetitle\":\"公司产品\",\n		\"typeurl\":\"\",\n		\"updateBy\":\"57\",\n		\"updateDate\":\"2020-12-30 20:23:13\"\n	}\n]', '内网IP', 'msopen', 'manage', 'delete', 'success', '/ms/cms/category/delete.do', 'POST', 'net.mingsoft.cms.action.CategoryAction.delete()', '127.0.0.1', '删除分类', NULL, NULL, '2021-10-21 08:39:11', NULL, 0);
INSERT INTO `logger` VALUES (13, NULL, '{\n	\"result\":true,\n	\"code\":200\n}', '[\n	{\n		\"categoryDescrip\":\"\",\n		\"categoryDiyUrl\":\"\",\n		\"categoryFlag\":\"nav\",\n		\"categoryImg\":\"[]\",\n		\"categoryKeyword\":\"\",\n		\"categoryListUrl\":\"product-list.htm\",\n		\"categoryPath\":\"/gongsichanpin1397750109561053185\",\n		\"categoryPinyin\":\"gongsichanpin1397750109561053185\",\n		\"categorySort\":0,\n		\"categoryTitle\":\"公司产品\",\n		\"categoryType\":\"1\",\n		\"categoryUrl\":\"product-detail.htm\",\n		\"createBy\":\"57\",\n		\"createDate\":\"2020-11-19 10:56:31\",\n		\"del\":1,\n		\"flag\":\"nav\",\n		\"id\":\"1397750109561053185\",\n		\"leaf\":false,\n		\"sqlWhereList\":[],\n		\"topId\":\"0\",\n		\"typedescrip\":\"\",\n		\"typeid\":\"1397750109561053185\",\n		\"typekeyword\":\"\",\n		\"typeleaf\":false,\n		\"typelink\":\"/gongsichanpin1397750109561053185/index.html\",\n		\"typelitpic\":\"[]\",\n		\"typetitle\":\"公司产品\",\n		\"typeurl\":\"\",\n		\"updateBy\":\"57\",\n		\"updateDate\":\"2020-12-30 20:23:13\"\n	}\n]', '内网IP', 'msopen', 'manage', 'delete', 'success', '/ms/cms/category/delete.do', 'POST', 'net.mingsoft.cms.action.CategoryAction.delete()', '127.0.0.1', '删除分类', NULL, NULL, '2021-10-21 08:39:16', NULL, 0);
INSERT INTO `logger` VALUES (14, NULL, '{\n	\"result\":true,\n	\"code\":200,\n	\"data\":{\n		\"id\":\"1329257213283344385\"\n	}\n}', '{\n	\"createBy\":[\"57\"],\n	\"createDate\":[\"2020-11-19 10:56:31\"],\n	\"del\":[\"0\"],\n	\"id\":[\"1329257213283344385\"],\n	\"remarks\":[\"\"],\n	\"updateBy\":[\"57\"],\n	\"updateDate\":[\"2020-12-30 20:23:13\"],\n	\"order\":[\"\"],\n	\"categoryTitle\":[\"公司产品\"],\n	\"categoryPinyin\":[\"product\"],\n	\"categoryId\":[\"\"],\n	\"categoryType\":[\"1\"],\n	\"categorySort\":[\"0\"],\n	\"categoryListUrl\":[\"product-list.htm\"],\n	\"categoryUrl\":[\"product-detail.htm\"],\n	\"categoryKeyword\":[\"\"],\n	\"categoryDescrip\":[\"\"],\n	\"categoryImg\":[\"[]\"],\n	\"categoryDiyUrl\":[\"\"],\n	\"mdiyModelId\":[\"\"],\n	\"categoryDatetime\":[\"\"],\n	\"dictId\":[\"\"],\n	\"categoryFlag\":[\"nav\"],\n	\"categoryPath\":[\"/product\"],\n	\"categoryParentIds\":[\"\"],\n	\"leaf\":[\"false\"],\n	\"topId\":[\"0\"],\n	\"flag\":[\"nav\"],\n	\"typetitle\":[\"公司产品\"],\n	\"typelink\":[\"/product/index.html\"],\n	\"typekeyword\":[\"\"],\n	\"typeurl\":[\"\"],\n	\"parentids\":[\"\"],\n	\"typedescrip\":[\"\"],\n	\"typeid\":[\"1329257213283344385\"],\n	\"typeleaf\":[\"false\"],\n	\"typelitpic\":[\"[]\"]\n}', '内网IP', 'msopen', 'manage', 'update', 'success', '/ms/cms/category/update.do', 'POST', 'net.mingsoft.cms.action.CategoryAction.update()', '127.0.0.1', '更新分类', NULL, NULL, '2021-10-21 08:39:25', NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for manager
-- ----------------------------
DROP TABLE IF EXISTS `manager`;
CREATE TABLE `manager` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `role_id` int(11) DEFAULT NULL COMMENT '角色编号',
  `people_id` int(11) DEFAULT '0' COMMENT '用户编号即商家编号',
  `manager_admin` varchar(255) DEFAULT NULL COMMENT '管理员标识，超级管理员：super，子管理员：open',
  `manager_name` varchar(15) DEFAULT NULL COMMENT '管理员用户名',
  `manager_nickname` varchar(15) DEFAULT NULL COMMENT '管理员昵称',
  `manager_password` varchar(45) DEFAULT NULL COMMENT '管理员密码',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_manager_role_id` (`role_id`) USING BTREE,
  CONSTRAINT `fk_role_id` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COMMENT='管理员表';

-- ----------------------------
-- Records of manager
-- ----------------------------
BEGIN;
INSERT INTO `manager` VALUES (57, 48, 0, 'super', 'msopen', 'msopen', '9d8622060de5f24937b60585c3f4d66b', NULL, NULL, NULL, NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for mdiy_config
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_config`;
CREATE TABLE `mdiy_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `config_name` varchar(255) DEFAULT NULL COMMENT '模型名称',
  `config_data` varchar(4000) DEFAULT NULL COMMENT '模型数据',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` int(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` int(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_config_name` (`config_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义配置';

-- ----------------------------
-- Records of mdiy_config
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_dict
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_dict`;
CREATE TABLE `mdiy_dict` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `dict_value` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '数据值',
  `dict_label` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '标签名',
  `dict_type` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '类型',
  `dict_description` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '描述',
  `is_child` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '扩展业务标记',
  `dict_enable` varchar(11) COLLATE utf8_bin DEFAULT '1' COMMENT '启用状态',
  `dict_remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `dict_sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序（升序）',
  `UPDATE_BY` varchar(11) COLLATE utf8_bin DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) COLLATE utf8_bin DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `inx_unique` (`dict_value`,`dict_label`,`dict_type`),
  KEY `inx_dict_value` (`dict_value`) USING BTREE,
  KEY `inx_dict_label` (`dict_label`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=645 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='字典表';

-- ----------------------------
-- Records of mdiy_dict
-- ----------------------------
BEGIN;
INSERT INTO `mdiy_dict` VALUES (1, 'f', '幻灯', '文章属性', NULL, NULL, '1', NULL, 3, NULL, NULL, NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (2, 'p', '图片', '文章属性', NULL, NULL, '1', NULL, 1, NULL, NULL, NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (3, 'c', '推荐', '文章属性', NULL, NULL, '1', NULL, 4, '57', '2021-03-26 08:39:05', NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (4, 'h', '头条', '文章属性', NULL, NULL, '1', NULL, 2, NULL, NULL, NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (621, 'cms', '文章', '自定义模型类型', NULL, '0', '1', NULL, 0, NULL, NULL, NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (642, 'cms', '文章', '自定义页面类型', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (643, 'c', '推荐', '栏目属性', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 3);
INSERT INTO `mdiy_dict` VALUES (644, 'nav', '导航', '栏目属性', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 3);
COMMIT;

-- ----------------------------
-- Table structure for mdiy_form
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_form`;
CREATE TABLE `mdiy_form` (
  `form_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长id',
  `form_tips_name` varchar(30) NOT NULL COMMENT '自定义表单提示文字',
  `form_table_name` varchar(30) NOT NULL COMMENT '自定义表单表名',
  `form_app_id` int(11) NOT NULL COMMENT '自定义表单关联的应用编号',
  `create_by` int(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  PRIMARY KEY (`form_id`) USING BTREE,
  KEY `fk_mdiy_form` (`form_app_id`) USING BTREE,
  CONSTRAINT `mdiy_form_ibfk_1` FOREIGN KEY (`form_app_id`) REFERENCES `app` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自定义表单表';

-- ----------------------------
-- Records of mdiy_form
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_model
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_model`;
CREATE TABLE `mdiy_model` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `model_json` text COMMENT 'json',
  `model_table_name` varchar(255) DEFAULT NULL COMMENT '模型表名',
  `model_name` varchar(30) DEFAULT NULL COMMENT '模型名称',
  `model_type` varchar(255) DEFAULT NULL COMMENT '自定义模型类型，自定义表单不用该字段',
  `model_field` text COMMENT '模型字段',
  `model_custom_type` varchar(255) DEFAULT NULL COMMENT '类型，自定义表单：post，自定义模型：model',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `indx_model_name` (`model_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自定义模型';

-- ----------------------------
-- Records of mdiy_model
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_model_people_extend
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_model_people_extend`;
CREATE TABLE `mdiy_model_people_extend` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `input_1628493847000_5845` varchar(255) DEFAULT NULL COMMENT '扩展字段1',
  `link_id` bigint(20) DEFAULT NULL,
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='扩展会员信息';

-- ----------------------------
-- Records of mdiy_model_people_extend
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_page
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_page`;
CREATE TABLE `mdiy_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `page_key` varchar(255) NOT NULL COMMENT '自定义页面访问路径',
  `page_path` varchar(255) NOT NULL COMMENT '自定义页面绑定模板的路径',
  `page_title` varchar(255) NOT NULL COMMENT '自定义页面标题',
  `page_type` varchar(255) DEFAULT NULL COMMENT '字典分类字段',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `page_model_id` int(11) DEFAULT NULL COMMENT '模块id',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_page_key` (`page_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自定义页面表';

-- ----------------------------
-- Records of mdiy_page
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_tag
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_tag`;
CREATE TABLE `mdiy_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) DEFAULT NULL COMMENT '标签名称',
  `tag_type` varchar(255) DEFAULT NULL COMMENT '标签类型',
  `tag_sql` text COMMENT '标签sql',
  `tag_class` varchar(255) DEFAULT NULL COMMENT '标签类',
  `tag_description` varchar(255) DEFAULT NULL COMMENT '描述',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='标签';

-- ----------------------------
-- Records of mdiy_tag
-- ----------------------------
BEGIN;
INSERT INTO `mdiy_tag` VALUES (3, 'arclist', 'list', ' <#assign _typeid=\'\'/>\n<#assign _typetitle=\'\'/>\n<#assign _size=\'20\'/>\n\n<#if column?? && column.id?? && column.id?number gt 0>\n  <#assign  _typeid=\'${column.id}\'>\n</#if>\n\n<#if typeid??>\n  <#assign  _typeid=\'${typeid}\'>\n</#if>\n\n<#if typetitle??>\n  <#assign  _typetitle=\'${typetitle}\'>\n</#if>\n\n<#if size??>\n  <#assign  _size=\'${size}\'>\n</#if>\n\n<#if orderby?? >\n    <#if orderby==\'date\'>\n      <#assign  _orderby=\'content_datetime\'>\n  <#elseif orderby==\'updatedate\'>\n    <#assign  _orderby=\'content_updatetime\'>\n    <#elseif orderby==\'hit\'>\n      <#assign  _orderby=\'content_hit\'>\n    <#elseif orderby==\'sort\'>\n      <#assign  _orderby=\'content_sort\'>\n    <#else>\n        <#assign  _orderby=\'cms_content.id\'>\n     </#if>\n<#else>\n    <#assign  _orderby=\'cms_content.id\'>\n</#if>\n\nSELECT\n  cms_content.id AS id,\n  content_title AS title,\n  content_title AS fulltitle,\n  content_author AS author,\n  content_source AS source,\n  content_details AS content,\n  category.category_title AS typetitle,\n  category.id AS typeid,\ncategory.category_path AS typepath,\n  category.category_img AS typelitpic,\n  category.category_keyword as typekeyword,\n  category.top_id as topId,\n  category.category_parent_ids as parentids,\n  category.category_type AS \"type\",\n\n  <#--列表页动态链接-->\n  <#if isDo?? && isDo>\n    CONCAT(\'/${modelName}/list.do?typeid=\', category.category_id) as typelink,\n  <#else>\n    (SELECT \'index.html\') AS typelink,\n  </#if>\n    content_description AS descrip,\n    content_hit AS hit,\n    content_type AS flag,\n    cms_content.content_keyword AS keyword,\n    content_img AS litpic,\n  \n  <#--内容页动态链接-->\n  <#if isDo?? && isDo>\n    CONCAT(\'/${modelName}/view.do?id=\', cms_content.id,\'&orderby=${_orderby}\',\'&order=${order!\'ASC\'}\',\'&typeid=${typeid}\') as \"link\",\n  <#else>\n    CONCAT(category.category_path,\'/\',if(category_type=2,\"index\",cms_content.id),\'.html\') AS \"link\",\n  </#if>\n\n  <#if tableName??>${tableName}.*,</#if>\n  content_datetime AS \"date\"\nFROM\n  cms_content LEFT JOIN cms_category as category\n  ON cms_content.category_id = category.id\n\n  <#--判断是否有自定义模型表-->\n  <#if tableName??>\n    LEFT JOIN ${tableName} ON ${tableName}.link_id=cms_content.id\n  </#if>\n  WHERE  \n    content_display=0\n    and cms_content.del=0\n    <#--根据站点编号查询-->\n    <#if appId?? >\n      and cms_content.app_id=${appId}\n      and cms_content.id>0\n    </#if>\n    <#--判断是否有搜索分类集合-->\n    <#if search?? && _typeid==\"\">\n      <#if search.categoryIds?has_content>and FIND_IN_SET(category.id,\'${search.categoryIds}\')</#if>\n        <#--标题-->\n        <#if search.content_title??> and content_title like CONCAT(\'%\',\'${search.content_title}\',\'%\')</#if>\n        <#--作者-->\n        <#if search.content_author??> and content_author like CONCAT(\'%\',\'${search.content_author}\',\'%\')</#if>\n        <#--来源-->\n        <#if search.content_source??> and content_source like CONCAT(\'%\',\'${search.content_source}\',\'%\')</#if>\n        <#--属性-->\n        <#if search.content_type??> and  (\n          <#list search.content_type?split(\',\') as item>\n            <#if item?index gt 0> or</#if>\n            FIND_IN_SET(\'${item}\',cms_content.content_type)\n          </#list>)\n        </#if>\n\n        <#--描述-->\n        <#if search.content_description??>\n        and content_description like CONCAT(\'%\',\'${search.content_description}\',\'%\')\n        </#if>\n\n        <#--关键字-->\n        <#if search.content_keyword??> and content_keyword like CONCAT(\'%\',\'${search.content_keyword}\',\'%\')</#if>\n\n        <#--内容-->\n        <#if search.content_details??> and content_details like CONCAT(\'%\',\'${search.content_details}\',\'%\')</#if>\n\n    <#--自定义顺序-->\n        <#if search.content_sort??> and content_sort=${search.content_sort}</#if>\n    <#--时间范围-->\n        <#if search.content_datetime_start??&&search.content_datetime_end??>\n          and content_datetime between \'${search.content_datetime_start}\' and \'${search.content_datetime_end}\'\n        </#if>\n    <#else>\n      <#--查询栏目-->\n      <#if _typeid?has_content> \n        and (cms_content.category_id=${_typeid} or cms_content.category_id in (select id FROM cms_category where cms_category.del=0 \n        <#if _typetitle?has_content>\n        and cms_category.category_title=\'${_typetitle}\'</#if> and FIND_IN_SET(${_typeid},CATEGORY_PARENT_IDS))) \n        </#if>\n    </#if>\n      <#--标题-->\n      <#if content_title??> and content_title like CONCAT(\'%\',\'${content_title}\',\'%\')</#if>\n      <#--作者-->\n      <#if content_author??> and content_author like CONCAT(\'%\',\'${content_author}\',\'%\')</#if>\n      <#--来源-->\n      <#if content_source??> and content_source like CONCAT(\'%\',\'${content_source}\',\'%\')</#if>\n      <#--属性-->\n      <#if content_type??> and content_type like CONCAT(\'%\',\'${content_type}\',\'%\')</#if>\n      <#--描述-->\n      <#if content_description??> and content_description like CONCAT(\'%\',\'${content_description}\',\'%\')</#if>\n      <#--关键字-->\n      <#if content_keyword??> and content_keyword like CONCAT(\'%\',\'${content_keyword}\',\'%\')</#if>\n      <#--内容-->\n      <#if content_details??> and content_details like CONCAT(\'%\',\'${content_details}\',\'%\')</#if>\n      <#--自定义顺序-->\n      <#if content_sort??> and content_sort=${content_sort}</#if>\n      <#--自定义模型-->\n      <#if diyModel??>\n        <#list diyModel as dm>\n          and ${tableName}.${dm.key} like CONCAT(\'%\',\'${dm.value}\',\'%\') \n        </#list>\n      </#if>\n      <#--文章属性-->\n      <#if flag?? >\n        and(\n          <#list flag?split(\',\') as item>\n          <#if item?index gt 0> or</#if>\n          FIND_IN_SET(\'${item}\',cms_content.content_type)\n          </#list>)\n      </#if>\n      <#if noflag??>\n          and(\n          <#list noflag?split(\',\') as item>\n          <#if item?index gt 0> and</#if>\n          FIND_IN_SET(\'${item}\',cms_content.content_type)=0\n          </#list> or cms_content.content_type is null)\n      </#if>\n\n      <#--字段排序-->\n      <#if orderby?? >\n      ORDER BY\n          <#if orderby==\'date\'> content_datetime\n          <#elseif orderby==\'updatedate\'> content_updatetime\n          <#elseif orderby==\'hit\'> content_hit\n          <#elseif orderby==\'sort\'> content_sort\n        <#else>\n          cms_content.id\n        </#if>\n  <#else>\n      ORDER BY   cms_content.id\n  </#if>\n\n  <#if order?? >\n    <#if order==\'desc\'> desc</#if>\n    <#if order==\'asc\'> asc</#if>\n  <#else>\n    desc\n  </#if>\n    LIMIT \n  <#--判断是否分页-->\n  <#if ispaging?? && (pageTag.pageNo)??>\n      ${((pageTag.pageNo-1)*_size?eval)?c},${_size?default(20)}\n    <#else>\n      ${_size?default(20)}\n    </#if>', NULL, '文章列表', NULL, NULL, NULL, NULL, 0);
INSERT INTO `mdiy_tag` VALUES (4, 'channel', 'list', '<#assign _typeid=\'0\'/>\n<#if column?? && column.id?? && column.id?number gt 0>\n  <#assign  _typeid=\'${column.id}\'>\n  <#assign  selfid=\'${column.id}\'>\n</#if>\n\n<#if typeid??>\n  <#assign  _typeid=\'${typeid}\'>\n</#if>\n\nselect\n  id,\n  id as typeid,\n  category_title as typetitle,\n  <#--动态链接-->\n  <#if isDo?? && isDo>\n  CONCAT(\'/${modelName}/list.do?typeid=\', id) as typelink,\n  <#else>\n    <#--栏目类型为链接-->\n    CONCAT(category_path,\'/index.html\') as typelink,\n  </#if>\n  category_keyword as typekeyword,\n  category_diy_url as typeurl,\n  category_flag as flag,\n  category_parent_ids as parentids,\n  category_descrip as typedescrip,\n  category_type as type,\n  category_path as typepath,\n  leaf as typeleaf,\n  category_img as typelitpic ,\n  ( SELECT count(*) FROM cms_category cc WHERE cc.category_id = cms_category.id AND cc.del = 0 ) AS childsize \n  from cms_category\n  where\n  cms_category.del=0\n  <#--根据站点编号查询-->\n  <#if appId?? >\n    and cms_category.app_id=${appId}\n  </#if>\n\n  <#--栏目属性-->\n  <#if flag?? >\n  and\n    (<#list flag?split(\',\') as item>\n      <#if item?index gt 0> or</#if>\n    FIND_IN_SET(\'${item}\',category_flag)\n    </#list>)\n  </#if>\n\n  <#if noflag?? >\n    and\n    (<#list noflag?split(\',\') as item>\n      <#if item?index gt 0> and</#if>\n      FIND_IN_SET(\'${item}\',category_flag)=0\n    </#list> or category_flag is null)\n  </#if>\n\n  <#--type默认son-->\n  <#if !type??||!type?has_content>\n    <#assign type=\'son\'/>\n  </#if>\n\n  <#if type?has_content>\n  <#--顶级栏目（单个）-->\n    <#if type==\'top\'>\n      <#if _typeid != \'0\'>\n        and (id = top_id or top_id = 0)\n      </#if>\n\n    <#elseif type==\'nav\'>\n      and(category_id=0 or category_id is null)\n\n    <#--同级栏目（多个）-->\n    <#elseif type==\'level\'>\n      and\n      <#if _typeid != \'0\'>\n        category_id=(select category_id from cms_category where id=${_typeid})\n      <#else>\n        1=1\n      </#if>\n\n    <#--当前栏目（单个）-->\n  <#elseif type==\'self\'>\n     and\n     <#if _typeid != \'0\'>\n      id=${_typeid}\n     <#else>\n     1=1\n     </#if>\n\n    <#--当前栏目的所属栏目（多个）-->\n  <#elseif type==\'path\'>\n      and\n     <#if _typeid != \'0\'>\n       id in (<#if column?? && column.categoryParentIds??>${column.categoryParentIds},</#if>${_typeid})\n     <#else>\n      1=1\n     </#if>\n    <#--子栏目（多个）-->\n\n  <#elseif type==\'son\'>\n      and\n     <#if _typeid != \'0\'>\n      category_id=${_typeid}\n     <#else>\n      1=1\n     </#if>\n\n  <#--上一级栏目没有则取当前栏目（单个）-->\n  <#elseif type==\'parent\'>\n      and\n     <#if _typeid != \'0\'>\n       <#if column?? && column.categoryId??>\n        id=${column.categoryId}\n       <#else>\n        id=${_typeid}\n       </#if>\n     <#else>\n        1=1\n      </#if>\n  </#if>\n\n<#else> <#--默认顶级栏目-->\n   and\n  <#if _typeid != \'0\'>\n   id=${_typeid}\n  <#else>\n   (category_id=0 or category_id is null)\n  </#if>\n\n</#if>\n\n<#--字段排序-->\n<#if orderby?? >\n  ORDER BY\n  <#if orderby==\'date\'> category_datetime\n  <#elseif orderby==\'sort\'> category_sort\n  <#else>id</#if>\n</#if>\n\n<#if order?? >\n  <#if order==\'desc\'> desc</#if>\n  <#if order==\'asc\'> asc</#if>\n</#if>', NULL, '通用栏目', NULL, NULL, NULL, NULL, 0);
INSERT INTO `mdiy_tag` VALUES (5, 'global', 'single', 'select\nAPP_NAME as name,\napp_logo as logo,\napp_keyword as keyword,\napp_description as descrip,\napp_copyright as copyright,\n<#--动态解析 -->\n<#if isDo?? && isDo>\nCONCAT(\'${url}\',\'${html}/\',app_dir) as url,\n\'${url}\' as host,\n<#--使用地址栏的域名 -->\n<#elseif url??>\nCONCAT(\'${url}\',\'${html}/\',app_dir) as url,\n\'${url}\' as host,\n<#else>\nCONCAT(REPLACE(REPLACE(TRIM(substring_index(app_url,\'\\n\',1)), CHAR(10),\'\'), CHAR(13),\'\'),\'/html/\',app_dir) as url,\nREPLACE(REPLACE(TRIM(substring_index(app_url,\'\\n\',1)), CHAR(10),\'\'), CHAR(13),\'\') as host,\n</#if>\nCONCAT(\'template/\',id,\'/\',app_style) as \"style\" <#-- 判断是否为手机端 -->\nfrom app\n<#--根据站点编号查询-->\n<#if appId?? >\n  where id = ${appId}\n</#if>', NULL, '全局', NULL, NULL, NULL, NULL, 0);
INSERT INTO `mdiy_tag` VALUES (7, 'field', 'single', 'SELECT\ncms_content.id as id,\ncontent_title as title,\ncontent_author as author, \ncontent_source as source, \ncontent_details as content,\ncms_category.id as typeid,\ncms_category.leaf as typeleaf,\ncms_category.category_title as typetitle,\ncms_category.category_img AS typelitpic,\ncms_category.top_id as topId,\ncms_category.category_flag as typeflag,\ncms_category.category_parent_ids as parentids,\ncms_category.category_keyword as typekeyword,\ncms_category.category_descrip as typedescrip,\ncms_category.category_diy_url as typeurl,\n<#--动态链接-->\n<#if isDo?? && isDo>\nCONCAT(\'/${modelName}/list.do?typeid=\', cms_category.id) as typelink,\n<#else>\n	<#--栏目类型为链接-->\n	CONCAT(cms_category.category_path,\'/index.html\') as typelink,\n</#if>\ncms_content.content_img AS litpic,\n<#--内容页动态链接-->\n<#if isDo?? && isDo>\nCONCAT(\'/mcms/view.do?id=\', cms_content.id) as \"link\",\n<#else>\nCONCAT(cms_category.category_path,\'/\',cms_content.id,\'.html\') AS \"link\",\n</#if>\ncontent_datetime as \"date\",\ncontent_description as descrip,\nCONCAT(\'<script type=\"text/javascript\" src=\"${url}/cms/content/\',cms_content.id,\'/hit.do\"></script>\') as hit,\ncontent_type as flag,\ncategory_title as typetitle,\n<#if tableName??>${tableName}.*,</#if>\ncontent_keyword as keyword\nFROM cms_content\nLEFT JOIN cms_category  ON\ncms_category.id = cms_content.category_id\n<#--判断是否有自定义模型表-->\n<#if tableName??>left join ${tableName} on ${tableName}.link_id=cms_content.id</#if>\nWHERE\n<#--如果是栏目列表页没有文章id所以只取栏目id-->\n<#if column??&&column.id??&&!id??>\ncms_category.id=${column.id} and\n</#if>\n cms_content.del=0\n<#if id??> and cms_content.id=${id}</#if>', NULL, '文章内容', NULL, NULL, NULL, NULL, 0);
INSERT INTO `mdiy_tag` VALUES (8, 'pre', 'single', '<#assign select=\"(SELECT \'\')\"/>\n<#if orderby?? >\n      <#if orderby==\"date\">\n	   <#assign  _orderby=\"content_datetime\">\n      <#elseif orderby==\"updatedate\">\n <#assign  _orderby=\"content_updatetime\">\n      <#elseif orderby==\"hit\">\n	  <#assign  _orderby=\"content_hit\">\n      <#elseif orderby==\"sort\">\n	   <#assign  _orderby=\"content_sort\">\n      <#else><#assign  _orderby=\"cms_content.id\"></#if>\n   <#else>\n   <#assign  _orderby=\"cms_content.id\">\n  </#if>\n<#if pageTag.preId??>\nSELECT\ncms_content.id as id,\ncontent_title as title,\ncontent_author as author, \ncontent_source as source, \ncontent_details as content,\ncategory.category_title as typename,\ncategory.category_id as typeid,\n(SELECT \'index.html\') as typelink,\ncontent_img as litpic,\n<#--内容页动态链接-->\n  <#if isDo?? && isDo>\n   CONCAT(\'/${modelName}/view.do?id=\', cms_content.id,\'&orderby=${_orderby}\',\'&order=${order!\'ASC\'}\',\'&typeid=${typeid}\') as \"link\",\n  <#else>\n  CONCAT(category_path,\'/\',cms_content.id,\'.html\') AS \"link\",\n  </#if>\ncontent_datetime as \"date\",\ncontent_description as descrip,\ncontent_hit as hit,\ncontent_type as flag,\ncontent_keyword as keyword \nFROM cms_content\nLEFT JOIN cms_category as category ON cms_content.category_id=category.id\nWHERE cms_content.id=${pageTag.preId}\n<#else>\nSELECT\n${select} as id,\n${select} as title,\n${select} as fulltitle,\n${select} as author, \n${select} as source, \n${select} as content,\n${select} as typename,\n${select} as typeid,\n${select} as typelink,\n${select} as litpic,\n${select} as \"link\",\n${select} as \"date\",\n${select} as descrip,\n${select} as hit,\n${select} as flag,\n${select} as keyword\n</#if>', NULL, '文章上一篇', NULL, NULL, NULL, NULL, 0);
INSERT INTO `mdiy_tag` VALUES (9, 'page', 'single', 'select\n<#if !(pageTag.indexUrl??)>\n  <#--判断是否有栏目对象，用于搜索不传栏目-->\n  <#if column??>\n    <#assign path=column.categoryPath/>\n  <#else>\n    <#assign path=\"\"/>\n  </#if>\n  <#--总记录数、总页数-->\n  (SELECT ${pageTag.total}) as \"total\",\n  (SELECT ${pageTag.size}) as \"size\",\n\n  <#--记录总数-->\n  (SELECT ${pageTag.rcount}) as \"rcount\",\n  <#--当前页码-->\n  (SELECT ${pageTag.pageNo}) as \"cur\",\n  <#--首页-->\n  CONCAT(\'${path}\', \'/index.html\') as \"index\",\n  <#--上一页-->\n  <#if (pageTag.pageNo?eval-1) gt 1>\n    CONCAT(\'${path}\',\'/list-${pageTag.pageNo?eval-1}.html\') as \"pre\",\n  <#else>\n    CONCAT(\'${path}\',\'/index.html\') as \"pre\",\n  </#if>\n\n  <#--下一页-->\n  <#if pageTag.total==1>\n  CONCAT(\'${path}\', \'/index.html\') as \"next\",\n  CONCAT(\'${path}\', \'/index.html\') as \"last\"\n  <#else>\n    <#if pageTag.pageNo?eval gte pageTag.total>\n    CONCAT(\'${path}\',\'/list-${pageTag.total}.html\') as \"next\",\n    <#else>\n    CONCAT(\'${path}\',\'/list-${pageTag.pageNo?eval+1}.html\') as \"next\",\n    </#if>\n  <#--最后一页-->\n  CONCAT(\'${path}\',\'/list-${pageTag.total}.html\') as \"last\"\n  </#if>\n\n<#else>\n  <#--判断是否是搜索页面-->\n  \'${pageTag.indexUrl}\' as \"index\",\n  \'${pageTag.lastUrl}\' as \"last\",\n  \'${pageTag.preUrl}\' as \"pre\",\n  \'${pageTag.nextUrl}\' as \"next\",\n  (select ${pageTag.total}) as \"total\",\n  (select ${pageTag.size}) as \"size\",\n  (select ${pageTag.rcount}) as \"rcount\",\n  (select ${pageTag.pageNo}) as \"cur\"\n</#if>', NULL, '通用分页', NULL, NULL, NULL, NULL, 0);
INSERT INTO `mdiy_tag` VALUES (10, 'next', 'single', '<#assign select=\"(SELECT \'\')\"/>\n<#if orderby?? >\n      <#if orderby==\"date\">\n	   <#assign  _orderby=\"content_datetime\">\n      <#elseif orderby==\"updatedate\">\n <#assign  _orderby=\"content_updatetime\">\n      <#elseif orderby==\"hit\">\n	  <#assign  _orderby=\"content_hit\">\n      <#elseif orderby==\"sort\">\n	   <#assign  _orderby=\"content_sort\">\n      <#else><#assign  _orderby=\"cms_content.id\"></#if>\n   <#else>\n   <#assign  _orderby=\"cms_content.id\">\n  </#if>\n<#if pageTag.nextId??>\nSELECT\ncms_content.id as id,\ncontent_title as title,\ncontent_author as author, \ncontent_source as source, \ncontent_details as content,\ncategory.category_title as typename,\ncategory.category_id as typeid,\n(SELECT \'index.html\') as typelink,\ncontent_img as litpic,\n<#--内容页动态链接-->\n  <#if isDo?? && isDo>\n   CONCAT(\'/${modelName}/view.do?id=\', cms_content.id,\'&orderby=${_orderby}\',\'&order=${order!\'ASC\'}\',\'&typeid=${typeid}\') as \"link\",\n  <#else>\n  CONCAT(category_path,\'/\',cms_content.id,\'.html\') AS \"link\",\n  </#if>\ncontent_datetime as \"date\",\ncontent_description as descrip,\ncontent_hit as hit,\ncontent_type as flag,\ncontent_keyword as keyword \nFROM cms_content\nLEFT JOIN cms_category as category ON cms_content.category_id=category.id\nWHERE cms_content.id=${pageTag.nextId}\n<#else>\nSELECT\n${select} as id,\n${select} as title,\n${select} as fulltitle,\n${select} as author, \n${select} as source, \n${select} as content,\n${select} as typename,\n${select} as typeid,\n${select} as typelink,\n${select} as litpic,\n${select} as \"link\",\n${select} as \"date\",\n${select} as descrip,\n${select} as hit,\n${select} as flag,\n${select} as keyword \n</#if>', NULL, '文章下一篇', NULL, NULL, NULL, NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for model
-- ----------------------------
DROP TABLE IF EXISTS `model`;
CREATE TABLE `model` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `model_id` int(22) DEFAULT NULL COMMENT '模块的父模块id',
  `manager_id` int(11) DEFAULT NULL COMMENT '模块关联的关联员id',
  `model_parent_ids` varchar(300) DEFAULT NULL COMMENT '父级编号集合，从小到大排序',
  `model_code` varchar(255) DEFAULT NULL COMMENT '模块编码',
  `model_title` varchar(150) DEFAULT NULL COMMENT '模块标题',
  `model_url` varchar(255) DEFAULT NULL COMMENT '模块连接地址',
  `model_icon` varchar(120) DEFAULT NULL COMMENT '模块图标',
  `model_sort` int(11) DEFAULT NULL COMMENT '模块的排序',
  `model_ismenu` int(1) DEFAULT '0' COMMENT '模块是否是菜单',
  `IS_CHILD` varchar(300) DEFAULT NULL COMMENT '扩展字段',
  `model_datetime` datetime DEFAULT NULL,
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_model_id` (`model_id`) USING BTREE,
  KEY `idx_model_title` (`model_title`,`model_url`),
  CONSTRAINT `fk_model_id` FOREIGN KEY (`model_id`) REFERENCES `model` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1733 DEFAULT CHARSET=utf8 COMMENT='模块表';

-- ----------------------------
-- Records of model
-- ----------------------------
BEGIN;
INSERT INTO `model` VALUES (23, NULL, 0, NULL, '01000000', '权限管理', '', 'icon-quanxianguanli', 5, 1, NULL, '2014-09-09 10:12:22', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (84, NULL, 0, NULL, '12000000', '系统设置', '', 'icon-xitongguanli', 3, 1, NULL, '2014-12-19 22:30:24', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (86, 84, 0, '84', '12010000', '应用设置', 'app/-1/edit.do', '', 2, 1, NULL, '2014-12-19 22:31:59', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (87, 84, 0, '84', '12020000', '模版管理', 'template/index.do', '', 1, 1, NULL, '2014-12-19 22:32:50', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (182, 86, 0, '84,86', '12010004', '修改', 'app:update', '', 0, 0, NULL, '2017-09-05 16:14:42', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (183, 23, 0, '23', '01030000', '菜单管理', 'model/index.do', '', 0, 1, NULL, '2017-09-05 13:09:26', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (184, 183, 0, '23,183', '01030001', '查看', 'model:view', '', 0, 0, NULL, '2017-09-05 13:10:43', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (201, 183, 0, '23,183', '01030002', '新增', 'model:save', NULL, 0, 0, NULL, '2019-12-28 14:26:29', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (202, 183, 0, '23,183', '01030004', '修改', 'model:update', NULL, 0, 0, NULL, '2019-12-28 14:26:33', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (204, 87, 0, '84,87', '12020002', '上传', 'template:upload', '', 0, 0, NULL, '2019-12-28 14:26:37', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (406, 23, 0, '23', '406', '角色管理', 'basic/role/index.do', '', 0, 1, NULL, '2019-08-03 19:18:47', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (407, 406, 0, '23,406', '407', '新增', 'role:save', '', 0, 0, NULL, '2019-08-03 19:19:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (408, 406, 0, '23,406', '408', '修改', 'role:update', '', 0, 0, NULL, '2019-08-03 19:19:34', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (409, 406, 0, '23,406', '409', '删除', 'role:del', '', 0, 0, NULL, '2019-08-03 19:19:59', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (411, 23, 0, '23', '411', '管理员管理', 'basic/manager/index.do', '', 0, 1, NULL, '2019-08-04 12:54:38', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (412, 411, 0, '23,411', '412', '查看', 'manager:view', '', 0, 0, NULL, '2019-08-04 12:56:13', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (663, 411, 0, '23,411', '15737980803547570', '删除', 'manager:del', '', 0, 0, NULL, '2019-11-19 18:19:35', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (664, 411, 0, '23,411', '15737980853527702', '更新', 'manager:update', '', 0, 0, NULL, '2019-11-19 18:21:08', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (665, 411, 0, '23,411', '15735981803267702', '新增', 'manager:save', '', 0, 0, NULL, '2019-11-19 18:21:42', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (668, 183, 0, '23,183', '668', '删除', 'model:del', '', 0, 0, NULL, '2019-11-19 18:35:49', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (672, 87, 0, '84,87', '5434345', '删除', 'template:del', '', 0, 0, NULL, '2019-11-19 19:05:09', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (673, 87, 0, '84,87', '452435345', '更新', 'template:update', '', 0, 0, NULL, '2019-11-19 19:05:35', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (685, 84, 0, '84', '65123656532', '系统日志', 'basic/log/index.do', '', 0, 1, NULL, '2019-11-22 21:13:50', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (686, 685, 0, '84,685', '351463145634', '查看', 'basic:log:view', '', 0, 0, NULL, '2019-11-22 21:14:24', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (706, NULL, 0, NULL, '02000000', '内容管理', '', 'icon-neirongguanli', 5, 1, NULL, '2019-11-23 20:14:59', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (707, 706, 0, '706', '02980000', '文章管理', 'cms/content/index.do', '', 3, 1, NULL, '2019-11-23 20:16:25', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (708, 706, 0, '706', '02990000', '栏目管理', 'cms/category/index.do', '', 2, 1, NULL, '2019-11-23 20:16:50', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (709, 706, 0, '706', '02020000', '静态化', 'cms/generate/index.do', '', 1, 1, NULL, '2019-11-23 20:17:15', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (710, 709, 0, '706,709', '02020004', '生成文章', 'cms:generate:article', '', 0, 0, NULL, '2019-11-23 20:17:39', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (711, 709, 0, '706,709', '02020003', '生成栏目', 'cms:generate:column', '', 0, 0, NULL, '2019-11-23 20:18:05', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (713, 709, 0, '706,709', '02020001', '查看', 'cms:generate:view', '', 0, 0, NULL, '2019-11-23 20:18:48', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (714, 709, 0, '706,709', '56454656', '生成主页', 'cms:generate:index', '', 0, 0, NULL, '2019-11-23 20:20:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (715, 708, 0, '706,708', '02990004', '新增', 'cms:category:save', '', 0, 0, NULL, '2019-11-23 20:20:42', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (716, 708, 0, '706,708', '02990003', '修改', 'cms:category:update', '', 0, 0, NULL, '2019-11-23 20:21:36', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (717, 708, 0, '706,708', '02990001', '查看', 'cms:category:view', '', 0, 0, NULL, '2019-11-23 20:22:05', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (718, 707, 0, '706,707', '02980002', '新增', 'cms:content:save', '', 0, 0, NULL, '2019-11-23 20:22:35', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (719, 707, 0, '706,707', '02980004', '修改', 'cms:content:update', '', 0, 0, NULL, '2019-11-23 20:22:57', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (720, 707, 0, '706,707', '02980001', '查看', 'cms:content:view', '', 0, 0, NULL, '2019-11-23 20:23:15', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (721, 707, 0, '706,707', '721', '删除', 'cms:content:del', '', 0, 0, NULL, '2019-11-23 21:02:28', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1653, 708, 0, '706,708', '1320', '删除', 'cms:category:del', '', 0, 0, NULL, '2020-09-22 07:41:21', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1700, NULL, 0, NULL, '16197622071887865', '自定义模块', NULL, 'icon-zhanqun', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1701, 1700, 0, '1700', '16197622071885990', '自定义页面', 'mdiy/page/index.do', '', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1702, 1701, 0, '1700,1701', '16197622071882306', '新增', 'mdiy:page:save', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1703, 1701, 0, '1700,1701', '16197622071889774', '删除', 'mdiy:page:del', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1704, 1701, 0, '1700,1701', '16197622071883980', '更新', 'mdiy:page:update', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1705, 1701, 0, '1700,1701', '16197622071888834', '查看', 'mdiy:page:view', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1706, 1701, 0, '1700,1701', '161976235700096088', '导入', 'mdiy:form:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1707, 1700, 0, '1700', '16197622071880623', '自定义模型', 'mdiy/model/index.do', '', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1708, 1707, 0, '1700,1707', '16197622071887303', '新增', 'mdiy:model:save', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1709, 1707, 0, '1700,1707', '16197622071881168', '删除', 'mdiy:model:del', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1710, 1707, 0, '1700,1707', '16197622071881215', '更新', 'mdiy:model:update', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1711, 1707, 0, '1700,1707', '16197622071884291', '查看', 'mdiy:model:view', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1712, 1707, 0, '1700,1707', '161976234500028132', '导入', 'mdiy:model:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1713, 1700, 0, '1700', '16197622071884456', '自定义配置', 'mdiy/config/index.do', '', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1714, 1713, 0, '1700,1713', '16197622071881449', '新增', 'mdiy:config:save', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1715, 1713, 0, '1700,1713', '16197622071889126', '删除', 'mdiy:config:del', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1716, 1713, 0, '1700,1713', '16197622071888369', '更新', 'mdiy:config:update', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1717, 1713, 0, '1700,1713', '16197622071882134', '查看', 'mdiy:config:view', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1718, 1713, 0, '1700,1713', '161976231700026503', '导入', 'mdiy:config:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1719, 1700, 0, '1700', '15725929177747726', '自定义字典', 'mdiy/dict/index.do', '', 0, 1, NULL, '2021-05-25 22:07:10', '0', NULL, '0', NULL, 0);
INSERT INTO `model` VALUES (1720, 1719, 0, '1700,1719', '15725929177745034', '查看', 'mdiy:dict:view', NULL, 0, 0, NULL, '2021-05-25 22:07:10', '0', NULL, '0', NULL, 0);
INSERT INTO `model` VALUES (1721, 1719, 0, '1700,1719', '15725929177742474', '新增', 'mdiy:dict:save', NULL, 0, 0, NULL, '2021-05-25 22:07:10', '0', NULL, '0', NULL, 0);
INSERT INTO `model` VALUES (1722, 1719, 0, '1700,1719', '15725929177744138', '修改', 'mdiy:dict:update', NULL, 0, 0, NULL, '2021-05-25 22:07:10', '0', NULL, '0', NULL, 0);
INSERT INTO `model` VALUES (1723, 1719, 0, '1700,1719', '15725929177748034', '删除', 'mdiy:dict:del', NULL, 0, 0, NULL, '2021-05-25 22:07:10', '0', NULL, '0', NULL, 0);
INSERT INTO `model` VALUES (1724, 1700, 0, '1700', '162034834200049578', '自定义业务', 'mdiy/form/index.do', 'icon-caidan', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1725, 1724, 0, '1700,1724', '162034839300098062', '导入', 'mdiy:form:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1726, 1724, 0, '1700,1724', '162034842600047746', '删除', 'mdiy:form:del', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1727, 1724, 0, '1700,1724', '16203484400006602', '查看', 'mdiy:form:view', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1728, 1724, 0, '1700,1724', '162034845600099530', '保存', 'mdiy:form:save', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1729, 1724, 0, '1700,1724', '162034847100023820', '更新', 'mdiy:form:update', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1730, 1724, 0, '1700,1724', '162143180100032708', '新增业务数据', 'mdiy:formData:save', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1731, 1724, 0, '1700,1724', '162143181700031623', '删除业务数据', 'mdiy:formData:del', 'icon-caidan', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` VALUES (1732, 1724, 0, '1700,1724', '162143576500025187', '更新业务数据', 'mdiy:formData:update', 'icon-caidan', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for msend_log
-- ----------------------------
DROP TABLE IF EXISTS `msend_log`;
CREATE TABLE `msend_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) NOT NULL COMMENT '消息模版id',
  `log_datetime` datetime DEFAULT NULL COMMENT '时间',
  `log_content` varchar(1000) DEFAULT NULL COMMENT '接收内容',
  `log_receive` varchar(100) DEFAULT NULL COMMENT '接收人',
  `log_type` varchar(50) DEFAULT NULL COMMENT '日志类型0邮件1短信',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '修改时间',
  `update_by` varchar(30) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(30) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '0：正常，1：删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='发送日志';

-- ----------------------------
-- Records of msend_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for msend_template
-- ----------------------------
DROP TABLE IF EXISTS `msend_template`;
CREATE TABLE `msend_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `model_id` int(11) DEFAULT '0' COMMENT '模块编号',
  `template_title` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `template_mail` varchar(5000) COLLATE utf8_bin DEFAULT NULL,
  `template_sms` varchar(5000) COLLATE utf8_bin DEFAULT NULL,
  `template_code` varchar(50) COLLATE utf8_bin NOT NULL COMMENT '邮件模块代码',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '修改时间',
  `update_by` varchar(30) COLLATE utf8_bin DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(30) COLLATE utf8_bin DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '0：正常，1：删除',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_templage_title` (`template_title`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='发送消息模板表';

-- ----------------------------
-- Records of msend_template
-- ----------------------------
BEGIN;
INSERT INTO `msend_template` VALUES (32, 0, '验证码', '<p>验证码${code}</p>', '验证码${code}', 'code', '2021-09-07 14:07:02', NULL, '2021-09-07 14:07:02', NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for people
-- ----------------------------
DROP TABLE IF EXISTS `people`;
CREATE TABLE `people` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `people_name` varchar(30) DEFAULT NULL COMMENT '账号',
  `people_password` varchar(50) DEFAULT NULL COMMENT '密码',
  `people_ip` varchar(100) DEFAULT NULL COMMENT '用户登录ip',
  `people_phone` varchar(30) DEFAULT NULL COMMENT '手机号码',
  `people_phonecheck` int(1) DEFAULT '0' COMMENT '1手机验证通过',
  `people_mail` varchar(120) DEFAULT NULL COMMENT '用户邮箱',
  `people_maillcheck` int(1) DEFAULT '0' COMMENT '1邮箱验证通过',
  `people_state` int(2) DEFAULT '0' COMMENT '用户状态',
  `people_code` varchar(15) DEFAULT NULL COMMENT '随机验证码',
  `people_codesenddate` datetime DEFAULT NULL COMMENT '发送验证码时间',
  `people_datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '注册时间',
  `UPDATE_BY` int(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` int(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='户用基础表';

-- ----------------------------
-- Records of people
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for people_address
-- ----------------------------
DROP TABLE IF EXISTS `people_address`;
CREATE TABLE `people_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `PEOPLE_ID` int(11) NOT NULL COMMENT '对应用户基础信息拓展表的id',
  `PA_CONSIGNEE_NAME` varchar(30) DEFAULT NULL COMMENT '用户收货人姓名',
  `PA_PHONE` varchar(40) DEFAULT NULL COMMENT '收货人手机',
  `PA_MAIL` varchar(40) DEFAULT NULL COMMENT '收货人邮箱',
  `PA_ADDRESS` varchar(200) DEFAULT NULL COMMENT '收货人的详细收货地址',
  `PA_PROVINCE` varchar(10) DEFAULT NULL COMMENT '收货人所在的省',
  `PA_PROVINCE_ID` bigint(11) DEFAULT '0' COMMENT '省份编号',
  `PA_CITY` varchar(10) DEFAULT NULL COMMENT '收货人所在的市',
  `PA_CITY_ID` bigint(11) DEFAULT '0' COMMENT '城市编号',
  `PA_DISTRICT` varchar(10) DEFAULT NULL COMMENT '收货人所在区(县)',
  `PA_DISTRICT_ID` bigint(11) DEFAULT '0' COMMENT '区编号',
  `PA_STREET` varchar(255) DEFAULT NULL COMMENT '街道',
  `PA_STREET_ID` bigint(11) DEFAULT '0' COMMENT '街道编号',
  `PA_DEFAULT` int(1) DEFAULT '0' COMMENT '是否是收货人最终收货地址。1代表是，0代表不是，默认为0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `PA_PEOPLE_ID` (`PEOPLE_ID`) USING BTREE,
  CONSTRAINT `people_address_ibfk_1` FOREIGN KEY (`PEOPLE_ID`) REFERENCES `people` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户地址';

-- ----------------------------
-- Records of people_address
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for people_user
-- ----------------------------
DROP TABLE IF EXISTS `people_user`;
CREATE TABLE `people_user` (
  `people_id` int(11) NOT NULL COMMENT '用户id关联people表的（people_id）',
  `pu_real_name` varchar(50) DEFAULT NULL COMMENT '用户真实名称',
  `pu_address` varchar(200) DEFAULT NULL COMMENT '用户地址',
  `pu_level` varchar(200) DEFAULT NULL COMMENT '用户等级',
  `pu_level_name` varchar(200) DEFAULT NULL COMMENT '用户等级名称',
  `pu_icon` varchar(200) DEFAULT NULL COMMENT '用户头像图标地址',
  `pu_nickname` varchar(50) DEFAULT NULL COMMENT '用户昵称',
  `pu_sex` int(2) DEFAULT NULL COMMENT '用户性别(0.未知、1.男、2.女)',
  `pu_birthday` date DEFAULT NULL COMMENT '用户出生年月日',
  `pu_card` varchar(255) DEFAULT NULL COMMENT '身份证',
  `province_id` bigint(20) DEFAULT NULL COMMENT '省编号',
  `province_name` varchar(255) DEFAULT NULL COMMENT '省',
  `city_id` bigint(20) DEFAULT NULL COMMENT '城市编号',
  `city_name` varchar(255) DEFAULT NULL COMMENT '城市',
  `county_id` bigint(20) DEFAULT NULL COMMENT '县编号',
  `county_name` varchar(255) DEFAULT NULL COMMENT '县',
  PRIMARY KEY (`people_id`) USING BTREE,
  CONSTRAINT `people_user_ibfk_1` FOREIGN KEY (`people_id`) REFERENCES `people` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户基础信息表';

-- ----------------------------
-- Records of people_user
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for role
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `manager_id` int(11) DEFAULT '0' COMMENT '角色管理员编号',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `inx_role_manage_id` (`manager_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of role
-- ----------------------------
BEGIN;
INSERT INTO `role` VALUES (48, 57, 'msopen', NULL, NULL, NULL, NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for role_model
-- ----------------------------
DROP TABLE IF EXISTS `role_model`;
CREATE TABLE `role_model` (
  `model_id` int(22) DEFAULT NULL COMMENT '模块编号',
  `role_id` int(22) DEFAULT NULL COMMENT '角色编号',
  KEY `fk_model_id` (`model_id`) USING BTREE,
  KEY `fk_role_id` (`role_id`) USING BTREE,
  CONSTRAINT `fk_rm_model_id` FOREIGN KEY (`model_id`) REFERENCES `model` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_rm_role_id` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色模块关联表';

-- ----------------------------
-- Records of role_model
-- ----------------------------
BEGIN;
INSERT INTO `role_model` VALUES (23, 48);
INSERT INTO `role_model` VALUES (84, 48);
INSERT INTO `role_model` VALUES (86, 48);
INSERT INTO `role_model` VALUES (87, 48);
INSERT INTO `role_model` VALUES (182, 48);
INSERT INTO `role_model` VALUES (183, 48);
INSERT INTO `role_model` VALUES (184, 48);
INSERT INTO `role_model` VALUES (201, 48);
INSERT INTO `role_model` VALUES (202, 48);
INSERT INTO `role_model` VALUES (204, 48);
INSERT INTO `role_model` VALUES (406, 48);
INSERT INTO `role_model` VALUES (407, 48);
INSERT INTO `role_model` VALUES (408, 48);
INSERT INTO `role_model` VALUES (409, 48);
INSERT INTO `role_model` VALUES (411, 48);
INSERT INTO `role_model` VALUES (412, 48);
INSERT INTO `role_model` VALUES (663, 48);
INSERT INTO `role_model` VALUES (664, 48);
INSERT INTO `role_model` VALUES (665, 48);
INSERT INTO `role_model` VALUES (668, 48);
INSERT INTO `role_model` VALUES (672, 48);
INSERT INTO `role_model` VALUES (673, 48);
INSERT INTO `role_model` VALUES (685, 48);
INSERT INTO `role_model` VALUES (686, 48);
INSERT INTO `role_model` VALUES (706, 48);
INSERT INTO `role_model` VALUES (707, 48);
INSERT INTO `role_model` VALUES (708, 48);
INSERT INTO `role_model` VALUES (709, 48);
INSERT INTO `role_model` VALUES (710, 48);
INSERT INTO `role_model` VALUES (711, 48);
INSERT INTO `role_model` VALUES (713, 48);
INSERT INTO `role_model` VALUES (714, 48);
INSERT INTO `role_model` VALUES (715, 48);
INSERT INTO `role_model` VALUES (716, 48);
INSERT INTO `role_model` VALUES (717, 48);
INSERT INTO `role_model` VALUES (718, 48);
INSERT INTO `role_model` VALUES (719, 48);
INSERT INTO `role_model` VALUES (720, 48);
INSERT INTO `role_model` VALUES (721, 48);
INSERT INTO `role_model` VALUES (1653, 48);
INSERT INTO `role_model` VALUES (1700, 48);
INSERT INTO `role_model` VALUES (1701, 48);
INSERT INTO `role_model` VALUES (1702, 48);
INSERT INTO `role_model` VALUES (1703, 48);
INSERT INTO `role_model` VALUES (1704, 48);
INSERT INTO `role_model` VALUES (1705, 48);
INSERT INTO `role_model` VALUES (1706, 48);
INSERT INTO `role_model` VALUES (1707, 48);
INSERT INTO `role_model` VALUES (1708, 48);
INSERT INTO `role_model` VALUES (1709, 48);
INSERT INTO `role_model` VALUES (1710, 48);
INSERT INTO `role_model` VALUES (1711, 48);
INSERT INTO `role_model` VALUES (1712, 48);
INSERT INTO `role_model` VALUES (1713, 48);
INSERT INTO `role_model` VALUES (1714, 48);
INSERT INTO `role_model` VALUES (1715, 48);
INSERT INTO `role_model` VALUES (1716, 48);
INSERT INTO `role_model` VALUES (1717, 48);
INSERT INTO `role_model` VALUES (1718, 48);
INSERT INTO `role_model` VALUES (1719, 48);
INSERT INTO `role_model` VALUES (1720, 48);
INSERT INTO `role_model` VALUES (1721, 48);
INSERT INTO `role_model` VALUES (1722, 48);
INSERT INTO `role_model` VALUES (1723, 48);
INSERT INTO `role_model` VALUES (1724, 48);
INSERT INTO `role_model` VALUES (1725, 48);
INSERT INTO `role_model` VALUES (1726, 48);
INSERT INTO `role_model` VALUES (1727, 48);
INSERT INTO `role_model` VALUES (1728, 48);
INSERT INTO `role_model` VALUES (1729, 48);
INSERT INTO `role_model` VALUES (1730, 48);
INSERT INTO `role_model` VALUES (1731, 48);
INSERT INTO `role_model` VALUES (1732, 48);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
