const {resolve} = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const copyWebpackPlugin = require('copy-webpack-plugin');
const { CleanWebpackPlugin } = require('clean-webpack-plugin');

module.exports = {
    entry: './src/main.js',
    output: {
        filename: "index.[contenthash:6].js",
        path: resolve(__dirname, 'dist')
    },
    devServer:{   // 开发服务器配置
        port:3000,
        open:true,
        proxy: {
            // detail: https://cli.vuejs.org/config/#devserver-proxy
            ['/']: {
              target: `http://192.168.200.58:48078`,
              changeOrigin: true,
              secure:false,
              pathRewrite: {
                '^/': ''
              }
            }
        },
    },
   
    plugins: [
        new CleanWebpackPlugin(),
        new HtmlWebpackPlugin({
            template: "./src/index.html"
        }),
        new copyWebpackPlugin({
            patterns: [{
                from:__dirname+'/src/assets/images/',
                to: resolve(__dirname, './dist/assets/images/')
            }, {
                from:__dirname+'/src/assets/style.css',
                to: resolve(__dirname, './dist/assets/style.css')
            },
            {
                from:__dirname+'/src/libs/',
                to: resolve(__dirname, './dist/libs')
            }]
        }),
    ],
    mode: "production"
}