
const firstScreenEl = document.querySelector('.first-screen');
const gradientEl = document.querySelector('.gradient');
const maskContainerEl = document.querySelector('.mask-container');
const videoEl = document.getElementById('maskedVideo');
const desc1El = document.querySelector('.desc-1');
const desc2El = document.querySelector('.desc-2');
const maskVideoEl = document.querySelector('.mask-video');
const videoWrapperEl = document.querySelector('.video-wrapper');
const scrollIndicatorEl = document.querySelector('.scroll-indicator-wrapper');
const bottomContentEl = document.querySelector('.bottom-content-wrapper');
const scrollNum =  window.innerHeight / 3 * 2;
const desc1MinScroll = window.innerHeight / 3 * 2;
const desc1MaxScroll = window.innerHeight * 2 - 200;
const desc2MinScroll = window.innerHeight * 2 - 200;
const desc2MaxScroll = window.innerHeight * 2;
const desc2MinScroll2 = window.innerHeight * 2;
const desc2MaxScroll2 = window.innerHeight * 3;
const videoMinScroll = window.innerHeight * 2 + window.innerHeight / 2;
const videoMaxScroll = window.innerHeight * 3 + 80;
const videoMaxScroll2 = 2 * videoMaxScroll - videoMinScroll;
const completeScroll = firstScreenEl.offsetHeight + 80 - window.innerHeight;
let initTop = 0;
let playing = false;

setTimeout(() => {
    if (document.compatMode && document.compatMode != 'BackCompat'){
        document.documentElement.scrollTop = 0;
    }

    if (document.body) {
        document.body.scrollTop = 0;
    }
}, 600)

// 视频播放结束
videoEl.addEventListener('ended', function() {
    playing = false;
}, false);

// 获取滚动条位置
function getScrollTop() {
    let scrollPos;
    if (window.pageYOffset) {
        scrollPos = window.pageYOffset;
    } else if (document.compatMode && document.compatMode != 'BackCompat'){
        scrollPos = document.documentElement.scrollTop;
    } else if (document.body) {
        scrollPos = document.body.scrollTop;
    }
    return scrollPos;
}

// 透明度转换
function handleOpacity(scrollPos, max, min, type = 1) {
    if (type === 1) {
        // 区间1～0
        return ((max - scrollPos) / (max - min)).toFixed(3);
    } else {
        // 区间0～1
        return ((scrollPos - min) / (max - min)).toFixed(3)
    }
}

// 缩放大小转换
function handleScale(scrollPos, max, scale) {
    const newMax = max * scale;

    return (newMax / (newMax - (scrollPos * (scale - 1)))).toFixed(3)
}

// 缩放translateY&filter
function handleTranslateYAndFilter(scrollPos, max, min, range) {
    return ((scrollPos - min) / ((max - min) / range)).toFixed(4);
}

function handleResize() {
    const h = bottomContentEl.offsetHeight - 300;

    bottomContentEl.style.marginBottom = `${225 - h}px`;
}

// 兼容微信自动播放问题
if (typeof WeixinJSBrdgeReady == "object" && typeof WeixinJSBridge.invoke == "function") {
    videoEl.play();
    videoEl.pause();
} else {
    if (document.addEventListener) {
        document.addEventListener("WeixinJSBridgeReady", function () {
            videoEl.play();
            videoEl.pause();
        }, false);
    } else if (document.attachEvent) {
        document.attachEvent("WeixinJSBridgeReady", function () {
            videoEl.play();
            videoEl.pause();
        });
        document.attachEvent("onWeixinJSBridgeReady", function () {
            videoEl.play();
            videoEl.pause();
        });
    }
}

window.onscroll = function() {
    const scrollPos = getScrollTop();
    const scroll = scrollPos - initTop;
    let dir = 'down';

    initTop = scrollPos;
    dir = scroll <= 0 ? 'up' : 'down';

    if (scrollPos === 0) {
        maskContainerEl.style.opacity = gradientEl.style.opacity = 1;
    }

    // 基数1000
    if (scrollPos > 0 && scrollPos <= scrollNum) {
        // 区间1～0
        const opacity = handleOpacity(scrollPos, scrollNum, 0);
        // 区间1～1.3
        const gradientScale = handleScale(scrollPos, scrollNum, 1.3);
        // 区间1～3
        const maskContainerScale = handleScale(scrollPos, scrollNum, 3);

        gradientEl.style.opacity = opacity;
        gradientEl.style.transform = `scale(${gradientScale}) translateZ(0px)`
        maskContainerEl.style.opacity = opacity;
        maskContainerEl.style.transform = `scale(${maskContainerScale}) translateZ(0px)`;

        if (dir === 'up') {
            //向上滚动
            gradientEl.style.opacity = opacity;
        } else {
            // 向下滚动
            if (scrollPos > 0 && scrollPos < 100) {
                // 判断滚动距离大于0，小于100px
                if (videoEl && !playing) {
                    videoEl.play()
                    playing = true;
                }
            }
        }
    } else {
        maskContainerEl.style.transform = gradientEl.style.transform = 'none';
    }

    if (scrollPos > scrollNum) {
        maskContainerEl.style.opacity = gradientEl.style.opacity = 0;
    }

    // desc1 动画
    if (scrollPos <= desc1MinScroll) {
        desc1El.style.opacity = 1;
        desc1El.style.transform = 'none';
    }

    if (scrollPos > desc1MinScroll && scrollPos <= desc1MaxScroll) {
        // 区间1～0
        const opacity = handleOpacity(scrollPos, desc1MaxScroll, desc1MinScroll);
        // 区间0～80
        const desc1Transform = handleTranslateYAndFilter(scrollPos, desc1MaxScroll, desc1MinScroll, 80);

        desc1El.style.opacity = opacity;
        desc1El.style.transform = `translateY(${desc1Transform}px) translateZ(0px)`
    }

    // 隐藏desc1
    if (scrollPos > desc1MaxScroll) {
        if (!desc1El.classList.contains('halfway')) {
            desc1El.classList.add('halfway');
        }
    } else {
        desc1El.classList.remove('halfway');
    }

    // desc2恢复初始状态 || desc2超出最大范围opacity置为0
    if (scrollPos <= desc2MinScroll || scrollPos > desc2MaxScroll2) {
        desc2El.style.opacity = 0;
        desc2El.style.transform = 'none';
    }

    // desc2动画展示
    if (scrollPos > desc2MinScroll && scrollPos <= desc2MaxScroll) {
        // 区间0～1
        const opacity = handleOpacity(scrollPos, desc2MaxScroll, desc2MinScroll, 0);
        // 区间-100～0
        const desc2Transform = ((scrollPos - desc2MaxScroll ) / (desc2MaxScroll - desc2MinScroll) * 100).toFixed(3);

        desc2El.style.opacity = opacity;
        desc2El.style.transform = `translateY(${desc2Transform}px) translateZ(0px)`;
    }

    // desc2动画隐藏
    if (scrollPos > desc2MinScroll2 && scrollPos <= desc2MaxScroll2) {
        // 区间1~0
        const opacity = handleOpacity(scrollPos, desc2MaxScroll2, desc2MinScroll2);
        // 区间0~-80
        const desc2Transform = -handleTranslateYAndFilter(scrollPos, desc2MaxScroll2, desc2MinScroll2, 80);

        desc2El.style.opacity = opacity;
        desc2El.style.transform = `translateY(${desc2Transform}px) translateZ(0px)`;
    }

    // 视频背景恢复初始状态
    if (scrollPos <= videoMinScroll) {
        maskVideoEl.style.filter = `blur(0px)`;
        maskVideoEl.style.opacity = 1;
        maskVideoEl.style.transform = 'none';
        videoWrapperEl.style.transform = `none`;
    }

    // 视频背景缩放
    if (scrollPos > videoMinScroll && scrollPos <= videoMaxScroll) {
        // 区间0～30
        const filter = handleTranslateYAndFilter(scrollPos, videoMaxScroll, videoMinScroll, 30);
        // 区间1～0.5
        const opacity = handleOpacity(scrollPos, videoMaxScroll2, videoMinScroll);
        // 区间0～-40
        const rotateX = -handleTranslateYAndFilter(scrollPos, videoMaxScroll, videoMinScroll, 40);

        maskVideoEl.style.filter = `blur(${filter}px)`;
        maskVideoEl.style.opacity = opacity;
        maskVideoEl.style.transform = `scale(${opacity}) translateZ(0px)`;
        videoWrapperEl.style.transform = `rotateX(${rotateX}deg) translateZ(0px)`;
    }

    // 隐藏竖线动画
    if (scrollPos > videoMinScroll) {
        if (!scrollIndicatorEl.classList.contains('hide')) {
            scrollIndicatorEl.classList.add('hide');
        }
    } else {
        scrollIndicatorEl.classList.remove('hide')
    }

    if (scrollPos > completeScroll) {
        if (!firstScreenEl.classList.contains('isComplete')) {
            firstScreenEl.classList.add('isComplete');
        }
    } else {
        firstScreenEl.classList.remove('isComplete');
    }
}

window.addEventListener('resize', handleResize);

handleResize();