package org.springblade.modules.earth.requestEntity;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class PublishRasterRequest {
	@ApiModelProperty(value = "发布的栅格的名称", required = true)
	private final String gridName;

	@ApiModelProperty(value = "栅格文件类型，可选值为 'tiff' 或 'img'", required = true)
	private final String gridType;

	@ApiModelProperty(value = "发布栅格的可下载链接", required = true)
	private final String gridUrl;

	@ApiModelProperty(value = "数据采集时间，格式为字符串", required = false)
	private final String captureDate;

	@ApiModelProperty(value = "附属文件类型。对于 tiff 格式，可选值为 'rpb'、'rpc' 或 'tfw'；对于 img 格式，可选值为 'ige'", required = false)
	private final String attachmentType;

	@ApiModelProperty(value = "发布栅格的附属文件的可下载链接", required = false)
	private final String attachmentUrl;


}

