package org.springblade.modules.desk.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author Zhangjinxing
 * @Description
 * @date 2023 2023/3/29 15:32
 */
@Data
public class MessageVO {

	@JsonSerialize(using = ToStringSerializer.class)
	private Long id;

	@ApiModelProperty(value = "报告id")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long reportId;

	@ApiModelProperty(value = "报告推送id")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long reportPushId;

	@ApiModelProperty(value = "点位名称")
	private String pointName;

	@ApiModelProperty(value = "点位经纬度")
	private String point;

	@ApiModelProperty(value = "消息推送人")
	private String pushUser;

	@ApiModelProperty(value = "消息推送时间")
	private Date pushTime;

	@ApiModelProperty(value = "消息状态（0：未读、1：已读）")
	private Integer messageStatus;

	@ApiModelProperty(value = "林火强度")
	private String forestFireIntensity;

	@ApiModelProperty(value = "高风险点位个数")
	private Integer highRiskCount;

	@ApiModelProperty(value = "复燃率")
	private Float fireRate;

	@ApiModelProperty(value = "报告ossURL")
	private String reportURL;

	@ApiModelProperty(value = "报告类型")
	private Integer reportType;
}
