package org.springblade.common.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class KeyGenerate {

	public static String generateApiKey() throws NoSuchAlgorithmException {
		SecureRandom random = new SecureRandom();
		byte[] apiKeyBytes = new byte[16];
		random.nextBytes(apiKeyBytes);
		return bytesToHex(apiKeyBytes);
	}

	public static String generateApiSecret() throws NoSuchAlgorithmException {
		SecureRandom random = new SecureRandom();
		byte[] apiSecretBytes = new byte[16];
		random.nextBytes(apiSecretBytes);
		MessageDigest md = MessageDigest.getInstance("SHA-256");
		byte[] hashedBytes = md.digest(apiSecretBytes);
		return bytesToHex(hashedBytes);
	}

	private static String bytesToHex(byte[] bytes) {
		StringBuilder sb = new StringBuilder();
		for (byte b : bytes) {
			sb.append(String.format("%02x", b));
		}
		return sb.toString();
	}
}
