package com.takedata.resume.service;

import com.alibaba.fastjson.JSON;
import com.takedata.resume.api.TestParseService;
import com.takedata.resume.common.Paging;
import com.takedata.resume.common.Response;
import com.takedata.resume.dao.ZcResumeMapper;
import com.takedata.resume.dao.ZcSynchronizeMapper;
import com.takedata.resume.model.ResumeResult;
import com.takedata.resume.common.utils.OssFileUtils;
import com.takedata.resume.model.ZcResume;
import com.takedata.resume.model.ZcSynchronize;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.IOException;
import java.util.*;

/**
 * @Author: wy
 * @Date: Created in 13:48 2019/12/10
 * @Description:
 * @Modified: By：
 */
@Service
public class ResumeService {


    @Autowired
    private RestHighLevelClient restHighLevelClient;

    @Autowired
    private ZcResumeMapper zcResumeMapper;

    @Autowired
    private ZcSynchronizeMapper zcSynchronizeMapper;

    /**
     * 简历解析
     *
     * @param objectName 对象名称
     * @param fileName   文件名
     * @return
     */
    public Object resumeAnalysis(String objectName, String fileName, Long createBy) {
        byte[] bytes = OssFileUtils.ossDownload(objectName);
        //简历解析
        Response<ResumeResult> resumeResultResponse = TestParseService.testResumeParser(bytes, fileName);
        ResumeResult data = resumeResultResponse.getData();
        ZcResume zcResume = new ZcResume();
        zcResume.setAvatarUrl("");
        zcResume.setLabel("");
        zcResume.setCity("");
        zcResume.setExpectSalary("");
        zcResume.setMajor("");
        zcResume.setWorkSalary("");
        zcResume.setPhone(data.getPhone());
        zcResume.setName(data.getName());
        zcResume.setCollege(data.getCollege());
        zcResume.setDegree(data.getDegree());
        zcResume.setWorkYear(data.getWork_year());
        zcResume.setEmail(data.getEmail());
        zcResume.setExpectJob(data.getExpect_job());
        zcResume.setGender(data.getGender());
        zcResume.setRawText(data.getRaw_text());
        zcResume.setCreateBy(createBy);

        zcResume.setContent(JSON.toJSONString(data));
        //oss链接
        zcResume.setResumeLink(objectName);
        zcResumeMapper.insertSelective(zcResume);

        //添加同步记录
        ZcSynchronize zc = new ZcSynchronize();
        zc.setName(data.getName());
        zc.setCreateBy(createBy);
        zc.setExpectJob(data.getExpect_job());
        zc.setRawText(data.getRaw_text());
        zc.setLabel("");
        zc.setResumeId(zcResume.getId());
        zc.setResumeLink(objectName);
        zcSynchronizeMapper.insertSelective(zc);

        return resumeResultResponse;
    }

    /**
     * 搜索
     *
     * @param keywords 关键字
     * @param label    标签
     * @return
     */
    public Response<Paging<Map<String, Object>>> resumeSearch(String keywords, String label, String name, String expectJob, String phone, int pageNum, int pageSize, Long createBy) {
        //index xxx mapping
        SearchResponse searchResponse;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        try {
            SearchRequest searchRequest = new SearchRequest("resume");
            searchRequest.types("doc");

            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();

            if (pageNum <= 0) {
                pageNum = 1;
            }
            searchSourceBuilder.from(pageSize * (pageNum - 1));
            searchSourceBuilder.size(pageSize);
            //结果集字段
            searchSourceBuilder.fetchSource(new String[]{"name", "phone", "expect_job", "label", "resume_id", "id"}, new String[]{});

            if (!StringUtils.isEmpty(keywords)) {
                //multiQuery  
                MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery(keywords, "keywords");
                //组合boolQuery
                boolQueryBuilder.must(multiMatchQueryBuilder);
            }
            //TermQuery
            if (!StringUtils.isEmpty(label)) {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("label", label);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if (!StringUtils.isEmpty(name)) {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("name", name);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //MatchQuery
            if (!StringUtils.isEmpty(expectJob)) {
                MatchQueryBuilder termQueryBuilder = QueryBuilders.matchQuery("expect_job", expectJob);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if (!StringUtils.isEmpty(phone)) {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("phone", phone);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if(!StringUtils.isEmpty(createBy)){
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("create_by", createBy);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //设置布尔查询对象      
            searchSourceBuilder.query(boolQueryBuilder);
            searchRequest.source(searchSourceBuilder);
            searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        SearchHits hits = searchResponse.getHits();

        List<Map<String, Object>> result = new LinkedList<>();
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return Response.yes(new Paging<>(hits.getTotalHits(), result));
    }

    /**
     * 面试任务搜索
     * @param keywords
     * @param label
     * @param name
     * @param expectJob
     * @param phone
     * @param pageNum
     * @param pageSize
     * @param createBy
     * @param interviewerName
     * @param status
     * @return
     */
    public Response<Paging<Map<String, Object>>> taskSearch(String keywords, String label, String name,
                                                            String expectJob, String phone, int pageNum,
                                                            int pageSize, Long createBy, String interviewerName,
                                                            Integer status) {
        //index xxx mapping
        SearchResponse searchResponse;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        try {
            SearchRequest searchRequest = new SearchRequest("task");
            searchRequest.types("doc");

            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();

            if (pageNum <= 0) {
                pageNum = 1;
            }
            searchSourceBuilder.from(pageSize * (pageNum - 1));
            searchSourceBuilder.size(pageSize);
            //结果集字段
            searchSourceBuilder.fetchSource(new String[]{"name", "phone", "expect_job", "label",
                    "resume_id", "id", "create_by", "interviewer_name", "status"}, new String[]{});

            if (!StringUtils.isEmpty(keywords)) {
                //multiQuery  
                MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery(keywords, "keywords");
                //组合boolQuery
                boolQueryBuilder.must(multiMatchQueryBuilder);
            }
            //TermQuery
            if (!StringUtils.isEmpty(label)) {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("label", label);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if (!StringUtils.isEmpty(name)) {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("name", name);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //MatchQuery
            if (!StringUtils.isEmpty(expectJob)) {
                MatchQueryBuilder termQueryBuilder = QueryBuilders.matchQuery("expect_job", expectJob);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if (!StringUtils.isEmpty(phone)) {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("phone", phone);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if(!StringUtils.isEmpty(createBy)){
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("create_by", createBy);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if(!StringUtils.isEmpty(status)){
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("status", status);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //TermQuery
            if(!StringUtils.isEmpty(interviewerName)){
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("interviewer_name", interviewerName);
                //组合boolQuery
                boolQueryBuilder.must(termQueryBuilder);
            }
            //设置布尔查询对象      
            searchSourceBuilder.query(boolQueryBuilder);
            searchRequest.source(searchSourceBuilder);
            searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        SearchHits hits = searchResponse.getHits();

        List<Map<String, Object>> result = new LinkedList<>();
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return Response.yes(new Paging<>(hits.getTotalHits(), result));
    }
}
