package com.takedata.resume.api;

import com.takedata.resume.common.Paging;
import com.takedata.resume.common.Response;
import com.takedata.resume.service.ResumeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

/**
 * @Author: wy
 * @Date: Created in 13:03 2019/12/5
 * @Description:
 * @Modified: By：
 */
@RestController
public class ResumeSdkController {

    @Autowired
    private ResumeService resumeService;

    /**
     * 简历分析
     *
     * @param objectName 简历信息
     * @return
     */
    @GetMapping("/api/resume/analysis")
    public Object resumeAnalysis(@RequestParam("objectName") String objectName, @RequestParam("createBy") Long createBy) {
        //resume/1575602066160.doc
        if (StringUtils.isEmpty(objectName)) {
            return Response.no(400);
        }
        String[] split = objectName.split("/");
        if (split.length != 2) {
            return Response.no(400);
        }
        return resumeService.resumeAnalysis(objectName, split[1], createBy);
    }


    /**
     * 简历搜索
     *
     * @param keywords 关键字
     * @param label    标签
     * @param name     姓名
     * @param phone    手机号
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/api/resume/search")
    public Response<Paging<Map<String, Object>>> resumeSearch(@RequestParam(value = "keywords", required = false) String keywords,
                                                              @RequestParam(value = "label", required = false) String label,
                                                              @RequestParam(value = "expectJob", required = false) String expectJob,
                                                              @RequestParam(value = "name", required = false) String name,
                                                              @RequestParam(value = "phone", required = false) String phone,
                                                              @RequestParam int pageNum, @RequestParam int pageSize,
                                                              @RequestParam(value = "createBy", required = false) Long createBy) throws UnsupportedEncodingException {
        if(keywords!=null){
            keywords = URLDecoder.decode(keywords,"UTF-8");
        }
        if(label!=null){
            label = URLDecoder.decode(label,"UTF-8");
        }
        if(expectJob!=null){
            expectJob = URLDecoder.decode(expectJob,"UTF-8");
        }
        if(name!=null){
            name = URLDecoder.decode(name,"UTF-8");
        }
        return resumeService.resumeSearch(keywords, label, name, expectJob, phone, pageNum, pageSize, createBy);
    }

    /**
     * 任务搜索
     * @param keywords
     * @param label
     * @param expectJob
     * @param name
     * @param phone
     * @param pageNum
     * @param pageSize
     * @param createBy
     * @param interviewerName
     * @param status
     * @return
     */
    @GetMapping("/api/resume/search/task")
    public Response<Paging<Map<String, Object>>> taskSearch(@RequestParam(value = "keywords", required = false) String keywords,
                                                              @RequestParam(value = "label", required = false) String label,
                                                              @RequestParam(value = "expectJob", required = false) String expectJob,
                                                              @RequestParam(value = "name", required = false) String name,
                                                              @RequestParam(value = "phone", required = false) String phone,
                                                              @RequestParam int pageNum, @RequestParam int pageSize,
                                                              @RequestParam(value = "createBy", required = false) Long createBy,
                                                            @RequestParam(value = "interviewerName", required = false) String interviewerName,
                                                            @RequestParam(value = "status" , required = false) Integer status) throws UnsupportedEncodingException {
        if(keywords!=null){
            keywords = URLDecoder.decode(keywords,"UTF-8");
        }
        if(label!=null){
            label = URLDecoder.decode(label,"UTF-8");
        }
        if(expectJob!=null){
            expectJob = URLDecoder.decode(expectJob,"UTF-8");
        }
        if(name!=null){
            name = URLDecoder.decode(name,"UTF-8");
        }
        if(interviewerName!=null){
            interviewerName = URLDecoder.decode(interviewerName,"UTF-8");
        }
        return resumeService.taskSearch(keywords, label, name, expectJob, phone, pageNum, pageSize, createBy, interviewerName, status);
    }
}